// tslint:disable:max-line-length
import * as classNames from 'classnames'
import { ClassNameProps } from 'interfaces/Props'
import * as React from 'react'
import './TextPrivacy.scss'

interface TextPrivacyProps extends ClassNameProps {}

export const TextPrivacy = (props: TextPrivacyProps) => (
  <div className={classNames('TextPrivacy', props.className)}>
    <p>Last modified: February 21, 2018</p>
    <h2>Introduction</h2>
    <p>
      Poet Technology Limited (<strong>"Company"</strong>
      or<strong>&nbsp;"We"</strong>) respects your privacy and is committed to protecting it through our compliance with
      this policy.
    </p>
    <p>
      This policy describes the types of information we may collect from you or that you may provide when you visit the
      website <a href="http://www.po.et/">www.po.et/</a> (our "<strong>Website</strong>") and our practices for
      collecting, using, maintaining, protecting, and disclosing that information.&nbsp; By submitting personal
      information through the site or Services, you agree to the terms of this Privacy Policy, and you expressly consent
      to the collection, use and disclosure of your personal information in accordance with this Privacy Policy.
    </p>
    <p>This policy applies to information we collect:</p>
    <p>· On this Website.</p>
    <p>· In email, text, and other electronic messages between you, Poet and other users of the Poet platform.</p>
    <p>
      · When you interact with our APIs and applications on our website or third-party websites and services, if those
      applications or advertising include links to this policy.
    </p>
    <p>It does not apply to information collected by:</p>
    <p>
      · us offline or through any other means, including on any other website operated by Company or any third party; or{' '}
    </p>
    <p>
      · any third party, including through any application or content (including advertising) that may link to or be
      accessible from or on the Website.
    </p>
    <p>
      Please read this policy carefully to understand our policies and practices regarding your information and how we
      will treat it. If you do not agree with our policies and practices, your choice is not to use our Website. By
      accessing or using this Website, you agree to this privacy policy. This policy may change from time to time (see
      Changes to Our Privacy Policy). Your continued use of this Website after we make changes is deemed to be
      acceptance of those changes, so please check the policy periodically for updates.{' '}
    </p>
    <h2>Children Under the Age of 18</h2>
    <p>
      Our Website is not intended for children under 18 years of age. No one under age 18 may provide any personal
      information to or on the Website. We do not knowingly collect personal information from children under 18. If you
      are under 18, do not use or provide any information on this Website or on or through any of its features/register
      on the Website, make any purchases through the Website, use any of the interactive or public comment features of
      this Website or provide any information about yourself to us, including your name, address, telephone number,
      email address, or any screen name or user name you may use. If we learn we have collected or received personal
      information from a child under 18 without verification of parental consent, we will delete that information. If
      you believe we might have any information from or about a child under 18, please contact us at [inbox@Po.et]
    </p>
    <h2>Users Outside of the United States</h2>
    <p>
      &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;If you are a non U.S. user of the Site, by visiting the Website and
      providing us with data, you acknowledge and agree that your personal information may be processed for the purposes
      identified in this Privacy Policy.&nbsp; In addition, your personal information may be processed in the country in
      which it was collected an in other countries, including the United States, where laws regarding processing of
      personal information may be less stringent than the laws in your country.&nbsp; By providing your information, you
      consent to such transfer.
    </p>
    <h2>Information We Collect About You and How We Collect It</h2>
    <p>We collect several types of information from and about users of our Website, including information:</p>
    <p>
      ·&nbsp; by which you may be personally identified, such as name, date of birth, postal address, e-mail address,
      telephone number, government ID number, account information or any other identifier by which you may be contacted
      online or offline ("<strong>personal information</strong>");
    </p>
    <p>· about your internet connection, the equipment you use to access our Website and usage details.</p>
    <p>We collect this information:</p>
    <p>·&nbsp; Directly from you when you provide it to us.</p>
    <p>
      ·&nbsp; Automatically as you navigate through the site. Information collected automatically may include usage
      details, IP addresses, and information collected through cookies and other tracking technologies.
    </p>
    <p>
      · From third parties, for example, our business partners, who have collected and may transfer your information to
      us.
    </p>
    <h2>Information You Provide to Us.&nbsp;&nbsp;</h2>
    <p>The information we collect on or through our Website may include:</p>
    <p>
      · Information that you provide by filling in forms on our Website to subscribe to or use our services. This
      includes information provided at the time of registering to use our Website, subscribing to our service, posting
      material, or requesting further services. We may also ask you for information to use certain features or when you
      report a problem with our Website.
    </p>
    <p>· Records and copies of your correspondence (including email addresses), if you contact us.</p>
    <p>· Your responses to surveys that we might ask you to complete for research purposes.</p>
    <p>· Your search queries on the Website.</p>
    <p>
      You also may provide information to be published or displayed (hereinafter, "<strong>posted</strong>") on public
      areas of the Website, or transmitted to other users of the Website or third parties (collectively, "<strong>
        User Contributions
      </strong>"). Your User Contributions are posted on and transmitted to others at your own risk. Although we limit
      access to certain pages, please be aware that no security measures are perfect or impenetrable. Additionally, we
      cannot control the actions of other users of the Website with whom you may choose to share your User
      Contributions. Therefore, we cannot and do not guarantee that your User Contributions will not be viewed by
      unauthorized persons.
    </p>
    <h2>Information We Collect Through Automatic Data Collection Technologies.&nbsp;</h2>
    <p>
      As you navigate through and interact with our Website, we may use automatic data collection technologies to
      collect certain information about your equipment, browsing actions, and patterns, including:
    </p>
    <p>
      · Details of your visits to our Website, including traffic data, location data, logs, and other communication data
      and the resources that you access and use on the Website.
    </p>
    <p>
      ·&nbsp;Information about your computer and internet connection, including your IP address, operating system, and
      browser type.
    </p>
    <p>
      We also may use these technologies to collect information about your online activities over time and across
      third-party websites or other online services (behavioral tracking).{' '}
    </p>
    <p>
      The information we collect automatically may include personal information, and we may maintain it or associate it
      with personal information we collect in other ways or receive from third parties. Collecting usage information
      helps us to improve our Website and to deliver a better and more personalized service, including by enabling us
      to:
    </p>
    <p>· Estimate our audience size and usage patterns.</p>
    <p>
      ·&nbsp;Store information about your preferences, allowing us to customize our Website according to your individual
      interests.
    </p>
    <p>· Speed up your searches.</p>
    <p>· Recognize you when you return to our Website.</p>
    <p>The technologies we use for this automatic data collection may include:</p>
    <p>&nbsp;</p>
    <p>
      ·&nbsp;<strong>Cookies (or browser cookies).</strong> A cookie is a small file placed on the hard drive of your
      computer. You may refuse to accept browser cookies by activating the appropriate setting on your browser. However,
      if you select this setting you may be unable to access certain parts of our Website. Unless you have adjusted your
      browser setting so that it will refuse cookies, our system will issue cookies when you direct your browser to our
      Website.{' '}
    </p>
    <p>
      ·&nbsp;<strong>Flash Cookies.</strong> Certain features of our Website may use local stored objects (or Flash
      cookies) to collect and store information about your preferences and navigation to, from, and on our Website.
      Flash cookies are not managed by the same browser settings as are used for browser cookies. For information about
      managing your privacy and security settings for Flash cookies, see Choices About How We Use and Disclose Your
      Information.
    </p>
    <p>
      ·&nbsp;<strong>Web Beacons.</strong> Pages of our the Website and our e-mails may contain small electronic files
      known as web beacons (also referred to as clear gifs, pixel tags, and single-pixel gifs) that permit the Company,
      for example, to count users who have visited those pages or opened an email and for other related website
      statistics (for example, recording the popularity of certain website content and verifying system and server
      integrity).{' '}
    </p>
    <p>
      We do not collect personal information automatically, but we may tie this information to personal information
      about you that we collect from other sources or you provide to us.
    </p>
    <h2>Third-Party Use of Cookies</h2>
    <p>
      Some content or applications, including advertisements, on the Website are served by third-parties, including
      advertisers, ad networks and servers, content providers, and application providers. These third parties may use
      cookies alone or in conjunction with web beacons or other tracking technologies to collect information about you
      when you use our website. The information they collect may be associated with your personal information or they
      may collect information, including personal information, about your online activities over time and across
      different websites and other online services. They may use this information to provide you with interest-based
      (behavioral) advertising or other targeted content.{' '}
    </p>
    <p>
      We do not control these third parties' tracking technologies or how they may be used. If you have any questions
      about an advertisement or other targeted content, you should contact the responsible provider directly.{' '}
    </p>
    <h2>How We Use Your Information</h2>
    <p>We use information that we collect about you or that you provide to us, including any personal information:</p>
    <p>·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To present our Website and its contents to you.</p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To provide you with information, products, or services that you
      request from us.
    </p>
    <p>·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To fulfill any other purpose for which you provide it.</p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To provide you with notices about your account/subscription, including
      expiration and renewal notices.
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To carry out our obligations and enforce our rights arising from any
      contracts entered into between you and us, including the Terms of Use and this Privacy Policy.
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To notify you about changes to our Website or any products or services
      we offer or provide though it.
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; In any other way we may describe when you provide the information.
    </p>
    <p>·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; For any other purpose with your consent.</p>
    <p>
      We may also use your information to contact you about goods and services that may be of interest to you. If you do
      not want us to use your information in this way, please send an email to privacy@Po.et.&nbsp; For more
      information, see Choices About How We Use and Disclose Your Information.
    </p>
    <p>
      We may use the information we have collected from you to enable us to display advertisements to our advertisers'
      target audiences. Even though we do not disclose your personal information for these purposes without your
      consent, if you click on or otherwise interact with an advertisement, the advertiser may assume that you meet its
      target criteria.
    </p>
    <h2>Disclosure of Your Information</h2>
    <p>
      We may disclose aggregated information about our users, and information that does not identify any individual,
      without restriction.{' '}
    </p>
    <p>We may disclose personal information that we collect or you provide as described in this privacy policy:</p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To our subsidiaries, affiliates, contractors, service providers, and
      other third parties we use to support our business and who are bound by contractual obligations to keep personal
      information confidential and use it only for the purposes for which we disclose it to them.
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To a buyer or other successor in the event of a merger, divestiture,
      restructuring, reorganization, dissolution, or other sale or transfer of some or all of Poet's assets, whether as
      a going concern or as part of bankruptcy, liquidation, or similar proceeding, in which personal information held
      by Poet about our Website users is among the assets transferred.
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To third parties to market their products or services to you if you
      have not opted out of these disclosures. We contractually require these third parties to keep personal information
      confidential and use it only for the purposes for which we disclose it to them.
    </p>
    <p>·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To fulfill the purpose for which you provide it.</p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; For any other purpose disclosed by us when you provide the
      information.
    </p>
    <p>·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; With your consent.</p>
    <p>We may also disclose your personal information:</p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To comply with any court order, law, or legal process, including to
      respond to any government or regulatory request.
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; To enforce or apply the contracts between us including our terms of
      use and other agreements, including for billing and collection purposes, if applicable.
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; If we believe disclosure is necessary or appropriate to protect the
      rights, property, or safety of Poet, our customers, or others.{' '}
    </p>
    <h2>Choices About How We Use and Disclose Your Information</h2>
    <p>
      We strive to provide you with choices regarding the personal information you provide to us. We have created
      mechanisms to provide you with the following control over your information:{' '}
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      <strong>Tracking Technologies and Advertising.</strong> You can set your browser to refuse all or some browser
      cookies, or to alert you when cookies are being sent. To learn how you can manage your Flash cookie settings,
      visit the Flash player settings page on Adobe's website. If you disable or refuse cookies, please note that some
      parts of this site may then be inaccessible or not function properly.
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      <strong>Disclosure of Your Information for Third-Party Advertising.</strong> If you do not want us to share your
      personal information with unaffiliated or non-agent third parties for promotional purposes, you can opt-out by
      sending an email stating your request to privacy@Po.et
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      <strong>Promotional Offers from the Company.</strong> If you do not wish to have your email address/contact
      information used by the Company to promote our own or third parties' products or services, you can opt-out by
      sending us an email stating your request toprivacy@Po.et If we have sent you a promotional email, you may send us
      a return email asking to be omitted from future email distributions. This opt out does not apply to information
      provided to the Company as a result of a product service experience or other transactions.
    </p>
    <p>
      ·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      <strong>Targeted Advertising.</strong> If you do not want us to use information that we collect or that you
      provide to us to deliver advertisements according to our advertisers' target-audience preferences, you can opt-out
      by sending us an email stating your request to privacy@Po.et
    </p>
    <p>
      We do not control third parties' collection or use of your information to serve interest-based advertising.
      However these third parties may provide you with ways to choose not to have your information collected or used in
      this way. You can opt out of receiving targeted ads from members of the Network Advertising Initiative ("<strong>
        NAI
      </strong>") on the NAI's website.
    </p>
    <h2>Accessing and Correcting Your Information</h2>
    <p>
      You may also send us an email at inbox@Po.et to request access to, correct or delete any personal information that
      you have provided to us. We may not accommodate a request to change information if we believe the change would
      violate any law or legal requirement or cause the information to be incorrect.
    </p>
    <h2>Your California Privacy Rights</h2>
    <p>
      California Civil Code Section § 1798.83 permits users of our Website that are California residents to request
      certain information regarding our disclosure of personal information to third parties for their direct marketing
      purposes. To make such a request, please send an email to privacy@Po.et.{' '}
    </p>
    <h2>Data Security</h2>
    <p>
      We have implemented measures, including multi-factor authentication, designed to secure your personal information
      from accidental loss and from unauthorized access, use, alteration, and disclosure. All information you provide to
      us is stored on our secure servers behind firewalls. Any payment transactions and transfers will be encrypted
      using SSL technology.{' '}
    </p>
    <p>
      Where we have given you (or where you have chosen) a password for access to certain parts of our Website, you are
      responsible for keeping this password confidential. We ask you not to share your password with anyone.{' '}
    </p>
    <p>
      Unfortunately, the transmission of information via the internet is not completely secure. Although we do our best
      to protect your personal information, we cannot guarantee the security of your personal information transmitted to
      our Website. Any transmission of personal information is at your own risk. We are not responsible for
      circumvention of any privacy settings or security measures contained on the Website.{' '}
    </p>
    <h2>Changes to Our Privacy Policy</h2>
    <p>
      It is our policy to post any changes we make to our privacy policy on this page with a notice that the privacy
      policy has been updated on the Website home page. If we make material changes to how we treat our users' personal
      information, we will notify you by email to the email address specified in your account and/or through a notice on
      the Website home page. The date the privacy policy was last revised is identified at the top of the page. You are
      responsible for ensuring we have an up-to-date active and deliverable email address for you, and for periodically
      visiting our Website and this privacy policy to check for any changes.
    </p>
    <h2>Contact Information</h2>
    <p>To ask questions or comment about this privacy policy and our privacy practices, contact us at: </p>
    <p>
      <a href="mailto:privacy@po.et">privacy@Po.et</a>&nbsp;
    </p>
  </div>
)
