# Prompt Master <img align="right" width="140" height="140" src="https://github.com/pnp/prompt-master/blob/main/Documentation/Images/prompt-master-logo.png"> 

| [Overview](/Documentation/Overview.md) | [Deployment guide](/Documentation/Deployment-guide.md) | [Architecture](/Documentation/Architecture.md)
| ---- | ---- | ----

Prompt Master is a Microsoft 365 Copilot gamification solution in the form of a Power App. It is designed to be used at events such as Copilot Excitement days, Promptathons etc. 

It allows people to compete against each other for the top spot on the leaderboard by completing 'challenges' based around prompt creation.

Prompts are automatically rated and a score from 0-100 is given, in addition suggestions on how to improve the prompt are provided.

It is designed to be opened and ran under a single user account and would be best placed displayed/used on one or two machines/screens during an event. 

Prompt Master uses Azure OpenAI together with a Custom Connector to rate and provide suggestions/feedback on prompts.

## Capabilities 🎮🕹️

Prompt Master provides the following capabilities:

- Ability to create/set up 'challenges' for prompt creation.
- Automatically rate and provide suggestions for entered prompts.
- Leaderboard.
- Ability to generate fun/unique player names.

<img src="https://github.com/pnp/prompt-master/blob/main/Documentation/Images/promptmaster-start-screenshot.png?raw=true" alt="Prompt Master Start Screenshot"><br/>

<img src="https://github.com/pnp/prompt-master/blob/main/Documentation/Images/promptmaster-challenges-screenshot.png?raw=true" alt="Prompt Master Challenges Screenshot"><br/>
## Getting Started

To get started please follow the [Deployment guide](Documentation/Deployment-guide.md). 

## How to 'Play'

For more information and how to find out how to 'play', check out the [Overview](Documentation/Overview.md).

## Issues

Please report any issues by raising an [issue](https://github.com/pnp/prompt-master/issues/new/choose).

## Contributing

We 💖 to accept contributions.

Check out our [Contribution guidelines](/CONTRIBUTING.md) for guidance on how to contribute. 

If you want to get involved with helping us enhance Prompt Pulse, whether that is suggesting or adding new functionality, updating our documentation or fixing bugs, we would love to hear from you.

## Support

This solution is open-source and community provided with no active community providing support for it. This solution is maintained by both Microsoft employees and community contributors and is not a Microsoft provided solution so there is no SLA or direct support for this from Microsoft. Please report any issues by raising an [issue](https://github.com/pnp/prompt-master/issues/new/choose).

## Microsoft 365 & Power Platform Community

Prompt Pulse is a Microsoft 365 & Power Platform Community (PnP) project. Microsoft 365 & Power Platform Community is a virtual team consisting of Microsoft employees and community members focused on helping the community make the best use of Microsoft products. Prompt Pulse is an open-source project not affiliated with Microsoft and not covered by Microsoft support. If you experience any issues using Provision Assist, please submit an issue in the [issues list](https://github.com/pnp/prompt-master/issues).

## "Sharing is Caring"

![Parker PnP](./Documentation/Images/parker-pnp.png)

## Disclaimer

**THIS CODE IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.**

## Code of Conduct

This repository has adopted the Microsoft Open Source Code of Conduct. For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or contact opencode@microsoft.com with any additional questions or comments.
