% Newton power flow method - Positive Sequence
%
%      0        1        2 
% kVLL |---zg---|---z----|--->S
%
function [V,I,losses,iter]=Newton_3(zgabc,zabc,Sabc,yshabc)
global kVLN
global Y
global Sabc
a=-0.5+j*sqrt(3)*.5;
V0=[kVLN;kVLN*a^2;kVLN*a]; %initialize v2=kVLL pos. seq. (nominal value)
Y=[   inv(zgabc),-inv(zgabc),zeros(3,3);
     -inv(zgabc),inv(zgabc)+inv(zabc)+yshabc*.5,-inv(zabc);
      zeros(3,3),-inv(zabc),inv(zabc)+yshabc*.5];
x0=[real(V0);real(V0);real(V0);imag(V0);imag(V0);imag(V0)];
%x0=[real(V0);imag(V0)];
[x]=fsolve(@solvepf1,x0);
iter=9999;

for k=1:9
V(k,1)=complex(x(k),x(k+9));
end
I(4,1)=0;
I(5,1)=0;
I(6,1)=0;
I(7,1)=conj(-Sabc(1)/(V(7,1)));
I(8,1)=conj(-Sabc(2)/(V(8,1)));
I(9,1)=conj(-Sabc(3)/(V(9,1)));
I(1,1)=-I(7,1);
I(2,1)=-I(8,1);
I(3,1)=-I(9,1);
losses=(V(4)*conj(I(1))+V(5)*conj(I(2))+V(6)*conj(I(3))+...
      V(7)*conj(I(7))+...
      V(8)*conj(I(8))+...
      V(9)*conj(I(9)))*1000;
end
 
function F=solvepf1(x)
global Y 
global Sabc
global kVLN
a=-0.5+j*sqrt(3)*.5;
x(1)=kVLN;
x(2)=real(kVLN*a^2);
x(3)=real(kVLN*a);
x(1+9)=0;
x(2+9)=imag(kVLN*a^2);
x(3+9)=imag(kVLN*a);
for k=1:9
V(k,1)=complex(x(k),x(k+9));
end
I(4,1)=0;
I(5,1)=0;
I(6,1)=0;
I(7,1)=conj(-Sabc(1)/(V(7,1)));
I(8,1)=conj(-Sabc(2)/(V(8,1)));
I(9,1)=conj(-Sabc(3)/(V(9,1)));
I(1,1)=-I(7,1);
I(2,1)=-I(8,1);
I(3,1)=-I(9,1);
Fx=real(Y*V-I);
Fy=imag(Y*V-I);
for k=1:6
  F(k)=Fx(k+3);
  F(k+6)=Fy(k+3);
end
end
