% Newton power flow method - Positive Sequence
%
%      0        1        2 
% kVLL |---zg---|---z----|--->S
%
function [V,I,losses,iter]=Newton_1(zg012,z012,S,ysh012)
global kVLN
global Y
global S
Y=[   inv(zg012(2,2)) -inv(zg012(2,2))                                        0;
     -inv(zg012(2,2))  inv(zg012(2,2))+inv(z012(2,2))+ysh012(2,2)*.5 -inv(z012(2,2));
      0               -inv(z012(2,2))             inv(z012(2,2))+ysh012(2,2)*.5];
x0=[kVLN; kVLN; kVLN; 0; 0; 0];
[x]=fsolve(@solvepf1,x0);
iter=9999;
for k=1:3
V(k,1)=complex(x(k),x(k+3));
end
I(3,1)=conj(-S/(3*V(3,1)));
I(2,1)=0;
I(1,1)=-I(3,1);
%I-Y*V
losses=sum(3*[V(2,1);V(3,1)].*conj([I(1,1);I(3,1)]))*1000;%kW+jkvar
end
 
function F=solvepf1(x)
global Y 
global S
global kVLN
x(1)=kVLN;
x(4)=0;
for k=1:3
V(k,1)=complex(x(k),x(k+3));
end
I(3,1)=conj(-S/(3*V(3,1)));
I(2,1)=0;
I(1,1)=-I(3,1);
Fx=real(Y*V-I);
Fy=imag(Y*V-I);
%F=[Fx',Fy']';
F=[Fx(2);Fx(3);Fy(2);Fy(3)];
end
