% Newton power flow method - Positive Sequence
%
%      0        1        2 
% kVLL |---zg---|---z----|--->S
%
function [V,I,losses,iter]=NewtonRaphson_1(zg012,z012,S,ysh012)
global kVLN
global Y
global S
Y=[   inv(zg012(2,2)) -inv(zg012(2,2))                                        0;
     -inv(zg012(2,2))  inv(zg012(2,2))+inv(z012(2,2))+ysh012(2,2)*.5 -inv(z012(2,2));
      0               -inv(z012(2,2))             inv(z012(2,2))+ysh012(2,2)*.5];
x0=[kVLN; kVLN; kVLN; 0; 0; 0];
[x]=fsolve(@solvepf2,x0);
iter=9999;
for k=1:3
V(k,1)=complex(x(k),x(k+3));
end
I(3,1)=conj(-S/(3*V(3,1)));
I(2,1)=0;
I(1,1)=-I(3,1);
%I-Y*V
losses=sum(3*[V(2,1);V(3,1)].*conj([I(1,1);I(3,1)]))*1000;%kW+jkvar
end
 
function F=solvepf2(x)
global Y 
global S
global kVLN
v(1)=kVLN;
t(1)=0;
for k=2:3
v(k)=abs(complex(x(k),x(k+3)));
t(k)=angle(complex(x(k),x(k+3)));
end
%solution vi apower flow equations:
G=real(Y);
B=imag(Y);
P=zeros(3,1);
Q=zeros(3,1);
Pl=zeros(3,1);
Pl(3)=real(S);
Ql=zeros(3,1);
Ql(3)=imag(S);
for j=2:3
  for k=1:3
P(j)=3*v(j)*v(k)*(G(j,k)*cos(t(j)-t(k))+B(j,k)*sin(t(j)-t(k)))+P(j);
Q(j)=3*v(j)*v(k)*(G(j,k)*sin(t(j)-t(k))-B(j,k)*cos(t(j)-t(k)))+Q(j);
end
P(j)=+Pl(j)+P(j);
Q(j)=+Ql(j)+Q(j);
end
F=[P(2);P(3);Q(2);Q(3)];
end

 
 
 