# Contributing to KLLM

Thank you for considering contributing to the KLLM project! Your contributions help improve the project and make it more valuable for the community. Please follow these guidelines to ensure a smooth and effective contribution process.

## How to Contribute

### 1. Reporting Bugs

If you encounter a bug, please open an issue on our [GitHub Issues](https://github.com/plushpluto/kllm/issues) page and include the following details:
- A clear and descriptive title.
- Steps to reproduce the issue.
- Expected and actual results.
- Any relevant screenshots, logs, or error messages.

### 2. Suggesting Features

We welcome feature suggestions! To propose a new feature, please open an issue with the following information:
- A clear and descriptive title.
- A detailed description of the feature.
- The problem the feature would solve.
- Any relevant examples or use cases.

### 3. Forking the Repository

To make changes to the codebase, follow these steps:

1. **Fork the Repository**
   - Fork the repository on GitHub.

2. **Clone the Repository**
   - Clone your forked repository:
     ```sh
     git clone https://github.com/your-username/kllm.git
     ```
   - Navigate to the project directory:
     ```sh
     cd kllm
     ```

3. **Creating a Branch**
   - Create a new branch for your changes:
     ```sh
     git checkout -b your-branch-name
     ```

4. **Making Changes**
   - Make your changes to the codebase. Ensure that you follow the existing code style and conventions. Write or update tests as necessary.

5. **Running Tests**
   - Before submitting your changes, run the tests to ensure everything works correctly:
     ```sh
     ./run_tests.sh
     ```

6. **Committing Changes**
   - Commit your changes with a clear and descriptive message:
     ```sh
     git add .
     git commit -m "Brief description of your changes"
     ```

7. **Pushing Changes**
   - Push your changes to your forked repository:
     ```sh
     git push origin your-branch-name
     ```

8. **Opening a Pull Request**
   - Open a pull request (PR) from your forked repository to the main repository:
     1. Go to the original repository on GitHub.
     2. Click the "New pull request" button.
     3. Select the base and compare branches.
     4. Provide a clear and descriptive title for your PR.
     5. Describe your changes in detail, including the problem they solve and any relevant context.
     6. Submit the pull request.

## Code of Conduct

Please adhere to our [Code of Conduct](CODE_OF_CONDUCT.md) in all your interactions with the project. We expect all contributors to foster a welcoming and inclusive environment.

## Acknowledgments

We appreciate your contributions to the KLLM project! Thank you for helping us improve and grow.
