/**
 * Suppose you have a random list of people standing in a queue. Each person is
 * described by a pair of integers (h, k), where h is the height of the person
 * and k is the number of people in front of this person who have a height
 * greater than or equal to h. Write an algorithm to reconstruct the queue.
 *
 * Note:
 * The number of people is less than 1,100.
 *
 * Example
 * Input:
 * [[7,0], [4,4], [7,1], [5,0], [6,1], [5,2]]
 *
 * Output:
 * [[5,0], [7,0], [5,2], [6,1], [4,4], [7,1]]
 */
const reconstructQueue = function (people) {
  let sorted = people.sort(([aH, aQ], [bH, bQ]) => {
    if (aH === bH) return aQ - bQ;
    else return bH - aH;
  });

  const result = [];

  for (let i = 0; i < sorted.length; i++) {
    let person = sorted[i];
    let index = person[1];

    result.splice(index, 0, person);
  }

  return result;
};
