/**
 * Given a m * n matrix of ones and zeros, return how many square submatrices
 * have all ones.
 *
 * Example 1:
 *
 * Input: matrix =
 * [
 *   [0,1,1,1],
 *   [1,1,1,1],
 *   [0,1,1,1]
 * ]
 * Output: 15
 * Explanation:
 * There are 10 squares of side 1.
 * There are 4 squares of side 2.
 * There is  1 square of side 3.
 * Total number of squares = 10 + 4 + 1 = 15.
 *
 * Example 2:
 * Input: matrix =
 * [
 *   [1,0,1],
 *   [1,1,0],
 *   [1,1,0]
 * ]
 * Output: 7
 * Explanation:
 * There are 6 squares of side 1.
 * There is 1 square of side 2.
 * Total number of squares = 6 + 1 = 7.
 *
 * Constraints:
 * 1 <= arr.length <= 300
 * 1 <= arr[0].length <= 300
 * 0 <= arr[i][j] <= 1
 *
 * Hint 1:
 * Create an additive table that counts the sum of elements of submatrix with
 * the superior corner at (0,0).
 *
 * Hint 2:
 * Loop over all subsquares in O(n^3) and check if the sum make the whole array
 * to be ones, if it checks then add 1 to the answer.
 */
// Time: O(2(nm)) => O(n);
// Space: O(2(nm)) => O(n);
const countSquares = function (matrix) {
  let result = 0;
  let rows = matrix.length;
  let cols = matrix[0].length;
  // Create a shallow copy that way when we mark the matrix
  // the input shouldn't mutate.
  let dp = matrix.slice().map((row) => row.slice());

  for (let row = 0; row < rows; row++) {
    for (let col = 0; col < cols; col++) {
      if (dp[row][col] && row && col) {
        dp[row][col] =
          1 +
          Math.min(dp[row][col - 1], dp[row - 1][col - 1], dp[row - 1][col]);
      }
    }
  }

  for (let row = 0; row < rows; row++) {
    for (let col = 0; col < cols; col++) {
      result += dp[row][col];
    }
  }

  return result;
};

// Time: O(nm) => O(n);
// Space: O(1);
const countSquares = function (matrix) {
  let result = 0;
  let rows = matrix.length;
  let cols = matrix[0].length;

  for (let row = 0; row < rows; row++) {
    for (let col = 0; col < cols; col++) {
      let curr = matrix[row][col];

      if (curr && row && col) {
        matrix[row][col] =
          1 +
          Math.min(
            matrix[row][col - 1],
            matrix[row - 1][col - 1],
            matrix[row - 1][col]
          );
        result += matrix[row][col];
      } else {
        result += curr;
      }
    }
  }

  return result;
};
