# Contributing to PizzaQL

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

Please note we have a [code of conduct](https://github.com/pizzaql/pizzaql/blob/master/code-of-conduct.md), please follow it in all your interactions with the project.

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for PizzaQL. Following these guidelines helps maintainers and the community
understand your report :pencil:, reproduce the behavior :computer: :computer:, and find related reports :mag_right:.

When you are creating a bug report, explain the problem and include additional details to help maintainers reproduce the problem:

* **Use a clear and descriptive title** for the issue to identify the problem.
* **Describe the exact steps which reproduce the problem** in as many details as possible.
* **Which version of Node.js are you using?** You can run `node -v` in your terminal to see the version number.
* **Which browser are you using? What version?**
* **What's the name and version of the OS you're using?**
* **Check your grammar**!

> **Note:** If you find a **Closed** issue that seems like it is the same thing that you're experiencing, open a new issue and include a link to the original issue in the body of your new one.

### Adding Enhancements

This section guides you through adding an enhancement for PizzaQL, including completely new features and minor
improvements to existing functionality. Following these guidelines helps maintainers and the community understand your pull request
:pencil:.

When you are creating a pull request:

* **Use a clear and descriptive title** to identify the enhancement.
* **Provide a description of the enhancement** in as many details as possible.
* **Explain why this enhancement would be useful**?
* **Before submitting a code change, check the code style** by running `npm test`.
* **Check your grammar**!
