Fonto — Custom Web Fonts Manager
========

## Description

Fonto is a custom fonts management plugin that will seamlessly integrate with the WordPress editor, allowing you to get right to using your fancy free or premium fonts.

It is built to work with pretty much any configuration font vendors offer (like Typekit, Fonts.com, MyFonts.com, Google Fonts), either by allowing them to serve the fonts via an embed code or by self-hosting the font files.

Plus, we've integrated Fonto with our [Customify](https://wordpress.org/plugins/customify/) plugin to make it even smoother to control your site's general typography.

### Compatible

Use your premium web fonts directly in the Editor or with the Customify plugin. Works with Typekit, MyFonts, Fonts.com, self-hosted fonts, and others.

**Made with love by [Pixelgrade](https://pixelgrade.com)**

## Installation

Installing "Fonto" can be done either by searching for "Fonto" via the "Plugins > Add New" screen in your WordPress dashboard, or by using the following steps:

1. Download the plugin via WordPress.org
1. Upload the ZIP file through the 'Plugins > Add New > Upload' screen in your WordPress dashboard
1. Activate the plugin through the 'Plugins' menu in WordPress

## Issues

If you identify any errors or have an idea for improving the plugin, please open an [issue](https://github.com/pixelgrade/fonto/issues?stage=open). We're more than excited to see what the community thinks of this little plugin, and we welcome your input!

If Github is not your thing but you are passionate about Backstage and want to help us make it better, don't hesitate to [reach us](https://pixelgrade.com/contact/).

## Frequently Asked Questions

### I am a developer. Can I easily change how things work?

We are also developers (and designers, and marketers, and support people...) just like you. We know how important it is that plugins get coded in a open, thoughtful manner that is friendly towards those that have custom requirements.

The plugin provides actions and filters in all the right places allowing you introduce custom logic just about anywhere, if the need arises.

## Credits

* [CMB2](https://github.com/CMB2/CMB2) Metaboxes, custom fields library - License: GPLv2 or later
* [CMB2 Conditionals](https://github.com/jcchavezs/cmb2-conditionals/) plugin for CMB2 - License: GPLv2 or later

## Changelog

### 1.2.1
* Fix issues with wrong uploads folder and attachments not attached to the current post.
* Improve compatibility with WordPress 5.9.2.
* Update CMB2 and CMB2-Conditionals dependencies to their latest version.

### 1.2.0
* Improve integrations with Customify and Style Manager.
* Fix issues with wrong uploads folder and attachments not attached to the current post.
* Improve compatibility with WordPress 5.7.2.
* Update CMB2 and CMB2-Conditionals dependencies to their latest version.

### 1.1.0
* Updated CMB2 to the latest version (v2.6.0), thus avoiding issues with other plugins or themes that use CMB2.
* Fixed minor styling issues.

### 1.0.5
* We did several compatibility checks with the latest WordPress releases, so everything will be working at least as smoothly as normal.

### 1.0.4
* Fixed incompatibility with other plugins that use the CMB2 Conditional Fields add-on.

### 1.0.3
* Updated CMB2 to the latest version.

### 1.0.2
* Added compatibility with the latest developments in Customify.

### 1.0
* 2016-06-10
* Initial release
