# Simple Chatbot

<img src="image.png" width="420px">

This app connects you to a chatbot powered by GPT-4, complete with animations generated by Stable Video Diffusion.

See a video of it in action: https://x.com/kwindla/status/1778628911817183509

And a quick video walkthrough of the code: https://www.loom.com/share/13df1967161f4d24ade054e7f8753416

ℹ️ The first time, things might take extra time to get started since VAD (Voice Activity Detection) model needs to be downloaded.

## Get started

```python
python3 -m venv venv
source venv/bin/activate
pip install -r requirements.txt

cp env.example .env # and add your credentials

```

## Run the server

```bash
python server.py
```

Then, visit `http://localhost:7860/` in your browser to start a chatbot session.

## Build and test the Docker image

```
docker build -t chatbot .
docker run --env-file .env -p 7860:7860 chatbot
```
