// Copyright 2022 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package importer

import (
	"fmt"

	"github.com/pingcap/tidb/pkg/util/dbutil"
)

// Config is the configuration.
type Config struct {
	TableSQL    string          `toml:"table-sql" json:"table-sql"`
	IndexSQL    string          `toml:"index-sql" json:"index-sql"`
	LogLevel    string          `toml:"log-level" json:"log-level"`
	DBCfg       dbutil.DBConfig `toml:"db" json:"db"`
	WorkerCount int             `toml:"worker-count" json:"worker-count"`
	JobCount    int             `toml:"job-count" json:"job-count"`
	Batch       int             `toml:"batch" json:"batch"`
}

func (c *Config) String() string {
	if c == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Config(%+v)", *c)
}
