// Copyright 2024 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by hash64_equals_generator; DO NOT EDIT IT DIRECTLY.

package logicalop

import (
	"github.com/pingcap/tidb/pkg/planner/cascades/base"
	"github.com/pingcap/tidb/pkg/util/plancodec"
)

// Hash64 implements the Hash64Equals interface.
func (op *LogicalJoin) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeJoin)
	op.LogicalSchemaProducer.Hash64(h)
	h.HashInt64(int64(op.JoinType))
	if op.EqualConditions == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.EqualConditions))
		for _, one := range op.EqualConditions {
			one.Hash64(h)
		}
	}
	if op.NAEQConditions == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.NAEQConditions))
		for _, one := range op.NAEQConditions {
			one.Hash64(h)
		}
	}
	if op.LeftConditions == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.LeftConditions))
		for _, one := range op.LeftConditions {
			one.Hash64(h)
		}
	}
	if op.RightConditions == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.RightConditions))
		for _, one := range op.RightConditions {
			one.Hash64(h)
		}
	}
	if op.OtherConditions == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.OtherConditions))
		for _, one := range op.OtherConditions {
			one.Hash64(h)
		}
	}
}

// Equals implements the Hash64Equals interface, only receive *LogicalJoin pointer.
func (op *LogicalJoin) Equals(other any) bool {
	op2, ok := other.(*LogicalJoin)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if op.JoinType != op2.JoinType {
		return false
	}
	if (op.EqualConditions == nil && op2.EqualConditions != nil) || (op.EqualConditions != nil && op2.EqualConditions == nil) || len(op.EqualConditions) != len(op2.EqualConditions) {
		return false
	}
	for i, one := range op.EqualConditions {
		if !one.Equals(op2.EqualConditions[i]) {
			return false
		}
	}
	if (op.NAEQConditions == nil && op2.NAEQConditions != nil) || (op.NAEQConditions != nil && op2.NAEQConditions == nil) || len(op.NAEQConditions) != len(op2.NAEQConditions) {
		return false
	}
	for i, one := range op.NAEQConditions {
		if !one.Equals(op2.NAEQConditions[i]) {
			return false
		}
	}
	if (op.LeftConditions == nil && op2.LeftConditions != nil) || (op.LeftConditions != nil && op2.LeftConditions == nil) || len(op.LeftConditions) != len(op2.LeftConditions) {
		return false
	}
	for i, one := range op.LeftConditions {
		if !one.Equals(op2.LeftConditions[i]) {
			return false
		}
	}
	if (op.RightConditions == nil && op2.RightConditions != nil) || (op.RightConditions != nil && op2.RightConditions == nil) || len(op.RightConditions) != len(op2.RightConditions) {
		return false
	}
	for i, one := range op.RightConditions {
		if !one.Equals(op2.RightConditions[i]) {
			return false
		}
	}
	if (op.OtherConditions == nil && op2.OtherConditions != nil) || (op.OtherConditions != nil && op2.OtherConditions == nil) || len(op.OtherConditions) != len(op2.OtherConditions) {
		return false
	}
	for i, one := range op.OtherConditions {
		if !one.Equals(op2.OtherConditions[i]) {
			return false
		}
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalAggregation) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeAgg)
	op.LogicalSchemaProducer.Hash64(h)
	if op.AggFuncs == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.AggFuncs))
		for _, one := range op.AggFuncs {
			one.Hash64(h)
		}
	}
	if op.GroupByItems == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.GroupByItems))
		for _, one := range op.GroupByItems {
			one.Hash64(h)
		}
	}
	if op.PossibleProperties == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.PossibleProperties))
		for _, one := range op.PossibleProperties {
			h.HashInt(len(one))
			for _, onee := range one {
				onee.Hash64(h)
			}
		}
	}
}

// Equals implements the Hash64Equals interface, only receive *LogicalAggregation pointer.
func (op *LogicalAggregation) Equals(other any) bool {
	op2, ok := other.(*LogicalAggregation)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if (op.AggFuncs == nil && op2.AggFuncs != nil) || (op.AggFuncs != nil && op2.AggFuncs == nil) || len(op.AggFuncs) != len(op2.AggFuncs) {
		return false
	}
	for i, one := range op.AggFuncs {
		if !one.Equals(op2.AggFuncs[i]) {
			return false
		}
	}
	if (op.GroupByItems == nil && op2.GroupByItems != nil) || (op.GroupByItems != nil && op2.GroupByItems == nil) || len(op.GroupByItems) != len(op2.GroupByItems) {
		return false
	}
	for i, one := range op.GroupByItems {
		if !one.Equals(op2.GroupByItems[i]) {
			return false
		}
	}
	if (op.PossibleProperties == nil && op2.PossibleProperties != nil) || (op.PossibleProperties != nil && op2.PossibleProperties == nil) || len(op.PossibleProperties) != len(op2.PossibleProperties) {
		return false
	}
	for i, one := range op.PossibleProperties {
		if (one == nil && op2.PossibleProperties[i] != nil) || (one != nil && op2.PossibleProperties[i] == nil) || len(one) != len(op2.PossibleProperties[i]) {
			return false
		}
		for ii, onee := range one {
			if !onee.Equals(op2.PossibleProperties[i][ii]) {
				return false
			}
		}
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalApply) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeApply)
	op.LogicalJoin.Hash64(h)
	if op.CorCols == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.CorCols))
		for _, one := range op.CorCols {
			one.Hash64(h)
		}
	}
	h.HashBool(op.NoDecorrelate)
}

// Equals implements the Hash64Equals interface, only receive *LogicalApply pointer.
func (op *LogicalApply) Equals(other any) bool {
	op2, ok := other.(*LogicalApply)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalJoin.Equals(&op2.LogicalJoin) {
		return false
	}
	if (op.CorCols == nil && op2.CorCols != nil) || (op.CorCols != nil && op2.CorCols == nil) || len(op.CorCols) != len(op2.CorCols) {
		return false
	}
	for i, one := range op.CorCols {
		if !one.Equals(op2.CorCols[i]) {
			return false
		}
	}
	if op.NoDecorrelate != op2.NoDecorrelate {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalExpand) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeExpand)
	op.LogicalSchemaProducer.Hash64(h)
	if op.DistinctGroupByCol == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.DistinctGroupByCol))
		for _, one := range op.DistinctGroupByCol {
			one.Hash64(h)
		}
	}
	if op.DistinctGbyExprs == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.DistinctGbyExprs))
		for _, one := range op.DistinctGbyExprs {
			one.Hash64(h)
		}
	}
	h.HashInt64(int64(op.DistinctSize))
	if op.RollupGroupingSets == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.RollupGroupingSets))
		for _, one := range op.RollupGroupingSets {
			h.HashInt(len(one))
			for _, onee := range one {
				h.HashInt(len(onee))
				for _, oneee := range onee {
					oneee.Hash64(h)
				}
			}
		}
	}
	if op.LevelExprs == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.LevelExprs))
		for _, one := range op.LevelExprs {
			h.HashInt(len(one))
			for _, onee := range one {
				onee.Hash64(h)
			}
		}
	}
	if op.GID == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		op.GID.Hash64(h)
	}
	if op.GPos == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		op.GPos.Hash64(h)
	}
}

// Equals implements the Hash64Equals interface, only receive *LogicalExpand pointer.
func (op *LogicalExpand) Equals(other any) bool {
	op2, ok := other.(*LogicalExpand)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if (op.DistinctGroupByCol == nil && op2.DistinctGroupByCol != nil) || (op.DistinctGroupByCol != nil && op2.DistinctGroupByCol == nil) || len(op.DistinctGroupByCol) != len(op2.DistinctGroupByCol) {
		return false
	}
	for i, one := range op.DistinctGroupByCol {
		if !one.Equals(op2.DistinctGroupByCol[i]) {
			return false
		}
	}
	if (op.DistinctGbyExprs == nil && op2.DistinctGbyExprs != nil) || (op.DistinctGbyExprs != nil && op2.DistinctGbyExprs == nil) || len(op.DistinctGbyExprs) != len(op2.DistinctGbyExprs) {
		return false
	}
	for i, one := range op.DistinctGbyExprs {
		if !one.Equals(op2.DistinctGbyExprs[i]) {
			return false
		}
	}
	if op.DistinctSize != op2.DistinctSize {
		return false
	}
	if (op.RollupGroupingSets == nil && op2.RollupGroupingSets != nil) || (op.RollupGroupingSets != nil && op2.RollupGroupingSets == nil) || len(op.RollupGroupingSets) != len(op2.RollupGroupingSets) {
		return false
	}
	for i, one := range op.RollupGroupingSets {
		if (one == nil && op2.RollupGroupingSets[i] != nil) || (one != nil && op2.RollupGroupingSets[i] == nil) || len(one) != len(op2.RollupGroupingSets[i]) {
			return false
		}
		for ii, onee := range one {
			if (onee == nil && op2.RollupGroupingSets[i][ii] != nil) || (onee != nil && op2.RollupGroupingSets[i][ii] == nil) || len(onee) != len(op2.RollupGroupingSets[i][ii]) {
				return false
			}
			for iii, oneee := range onee {
				if !oneee.Equals(op2.RollupGroupingSets[i][ii][iii]) {
					return false
				}
			}
		}
	}
	if (op.LevelExprs == nil && op2.LevelExprs != nil) || (op.LevelExprs != nil && op2.LevelExprs == nil) || len(op.LevelExprs) != len(op2.LevelExprs) {
		return false
	}
	for i, one := range op.LevelExprs {
		if (one == nil && op2.LevelExprs[i] != nil) || (one != nil && op2.LevelExprs[i] == nil) || len(one) != len(op2.LevelExprs[i]) {
			return false
		}
		for ii, onee := range one {
			if !onee.Equals(op2.LevelExprs[i][ii]) {
				return false
			}
		}
	}
	if !op.GID.Equals(op2.GID) {
		return false
	}
	if !op.GPos.Equals(op2.GPos) {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalLimit) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeLimit)
	op.LogicalSchemaProducer.Hash64(h)
	if op.PartitionBy == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.PartitionBy))
		for _, one := range op.PartitionBy {
			one.Hash64(h)
		}
	}
	h.HashUint64(uint64(op.Offset))
	h.HashUint64(uint64(op.Count))
}

// Equals implements the Hash64Equals interface, only receive *LogicalLimit pointer.
func (op *LogicalLimit) Equals(other any) bool {
	op2, ok := other.(*LogicalLimit)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if (op.PartitionBy == nil && op2.PartitionBy != nil) || (op.PartitionBy != nil && op2.PartitionBy == nil) || len(op.PartitionBy) != len(op2.PartitionBy) {
		return false
	}
	for i, one := range op.PartitionBy {
		if !one.Equals(&op2.PartitionBy[i]) {
			return false
		}
	}
	if op.Offset != op2.Offset {
		return false
	}
	if op.Count != op2.Count {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalMaxOneRow) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeMaxOneRow)
	op.BaseLogicalPlan.Hash64(h)
}

// Equals implements the Hash64Equals interface, only receive *LogicalMaxOneRow pointer.
func (op *LogicalMaxOneRow) Equals(other any) bool {
	op2, ok := other.(*LogicalMaxOneRow)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.BaseLogicalPlan.Equals(&op2.BaseLogicalPlan) {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *DataSource) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeDataSource)
	op.LogicalSchemaProducer.Hash64(h)
	if op.TableInfo == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		op.TableInfo.Hash64(h)
	}
	if op.TableAsName == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		op.TableAsName.Hash64(h)
	}
	if op.PushedDownConds == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.PushedDownConds))
		for _, one := range op.PushedDownConds {
			one.Hash64(h)
		}
	}
	if op.AllConds == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.AllConds))
		for _, one := range op.AllConds {
			one.Hash64(h)
		}
	}
	h.HashInt64(int64(op.PreferStoreType))
	h.HashBool(op.IsForUpdateRead)
}

// Equals implements the Hash64Equals interface, only receive *DataSource pointer.
func (op *DataSource) Equals(other any) bool {
	op2, ok := other.(*DataSource)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if !op.TableInfo.Equals(op2.TableInfo) {
		return false
	}
	if !op.TableAsName.Equals(op2.TableAsName) {
		return false
	}
	if (op.PushedDownConds == nil && op2.PushedDownConds != nil) || (op.PushedDownConds != nil && op2.PushedDownConds == nil) || len(op.PushedDownConds) != len(op2.PushedDownConds) {
		return false
	}
	for i, one := range op.PushedDownConds {
		if !one.Equals(op2.PushedDownConds[i]) {
			return false
		}
	}
	if (op.AllConds == nil && op2.AllConds != nil) || (op.AllConds != nil && op2.AllConds == nil) || len(op.AllConds) != len(op2.AllConds) {
		return false
	}
	for i, one := range op.AllConds {
		if !one.Equals(op2.AllConds[i]) {
			return false
		}
	}
	if op.PreferStoreType != op2.PreferStoreType {
		return false
	}
	if op.IsForUpdateRead != op2.IsForUpdateRead {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalMemTable) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeMemTableScan)
	op.LogicalSchemaProducer.Hash64(h)
	op.DBName.Hash64(h)
	if op.TableInfo == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		op.TableInfo.Hash64(h)
	}
}

// Equals implements the Hash64Equals interface, only receive *LogicalMemTable pointer.
func (op *LogicalMemTable) Equals(other any) bool {
	op2, ok := other.(*LogicalMemTable)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if !op.DBName.Equals(&op2.DBName) {
		return false
	}
	if !op.TableInfo.Equals(op2.TableInfo) {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalUnionAll) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeUnion)
	op.LogicalSchemaProducer.Hash64(h)
}

// Equals implements the Hash64Equals interface, only receive *LogicalUnionAll pointer.
func (op *LogicalUnionAll) Equals(other any) bool {
	op2, ok := other.(*LogicalUnionAll)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalPartitionUnionAll) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypePartitionUnion)
	op.LogicalUnionAll.Hash64(h)
}

// Equals implements the Hash64Equals interface, only receive *LogicalPartitionUnionAll pointer.
func (op *LogicalPartitionUnionAll) Equals(other any) bool {
	op2, ok := other.(*LogicalPartitionUnionAll)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalUnionAll.Equals(&op2.LogicalUnionAll) {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalProjection) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeProj)
	op.LogicalSchemaProducer.Hash64(h)
	if op.Exprs == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.Exprs))
		for _, one := range op.Exprs {
			one.Hash64(h)
		}
	}
	h.HashBool(op.CalculateNoDelay)
	h.HashBool(op.Proj4Expand)
}

// Equals implements the Hash64Equals interface, only receive *LogicalProjection pointer.
func (op *LogicalProjection) Equals(other any) bool {
	op2, ok := other.(*LogicalProjection)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if (op.Exprs == nil && op2.Exprs != nil) || (op.Exprs != nil && op2.Exprs == nil) || len(op.Exprs) != len(op2.Exprs) {
		return false
	}
	for i, one := range op.Exprs {
		if !one.Equals(op2.Exprs[i]) {
			return false
		}
	}
	if op.CalculateNoDelay != op2.CalculateNoDelay {
		return false
	}
	if op.Proj4Expand != op2.Proj4Expand {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalSelection) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeSel)
	if op.Conditions == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.Conditions))
		for _, one := range op.Conditions {
			one.Hash64(h)
		}
	}
}

// Equals implements the Hash64Equals interface, only receive *LogicalSelection pointer.
func (op *LogicalSelection) Equals(other any) bool {
	op2, ok := other.(*LogicalSelection)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if (op.Conditions == nil && op2.Conditions != nil) || (op.Conditions != nil && op2.Conditions == nil) || len(op.Conditions) != len(op2.Conditions) {
		return false
	}
	for i, one := range op.Conditions {
		if !one.Equals(op2.Conditions[i]) {
			return false
		}
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalSequence) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeSequence)
	op.BaseLogicalPlan.Hash64(h)
}

// Equals implements the Hash64Equals interface, only receive *LogicalSequence pointer.
func (op *LogicalSequence) Equals(other any) bool {
	op2, ok := other.(*LogicalSequence)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.BaseLogicalPlan.Equals(&op2.BaseLogicalPlan) {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalShow) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeShow)
	op.LogicalSchemaProducer.Hash64(h)
}

// Equals implements the Hash64Equals interface, only receive *LogicalShow pointer.
func (op *LogicalShow) Equals(other any) bool {
	op2, ok := other.(*LogicalShow)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalShowDDLJobs) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeShowDDLJobs)
	op.LogicalSchemaProducer.Hash64(h)
}

// Equals implements the Hash64Equals interface, only receive *LogicalShowDDLJobs pointer.
func (op *LogicalShowDDLJobs) Equals(other any) bool {
	op2, ok := other.(*LogicalShowDDLJobs)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalSort) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeSort)
	if op.ByItems == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.ByItems))
		for _, one := range op.ByItems {
			one.Hash64(h)
		}
	}
}

// Equals implements the Hash64Equals interface, only receive *LogicalSort pointer.
func (op *LogicalSort) Equals(other any) bool {
	op2, ok := other.(*LogicalSort)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if (op.ByItems == nil && op2.ByItems != nil) || (op.ByItems != nil && op2.ByItems == nil) || len(op.ByItems) != len(op2.ByItems) {
		return false
	}
	for i, one := range op.ByItems {
		if !one.Equals(op2.ByItems[i]) {
			return false
		}
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalTableDual) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeDual)
	op.LogicalSchemaProducer.Hash64(h)
	h.HashInt64(int64(op.RowCount))
}

// Equals implements the Hash64Equals interface, only receive *LogicalTableDual pointer.
func (op *LogicalTableDual) Equals(other any) bool {
	op2, ok := other.(*LogicalTableDual)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if op.RowCount != op2.RowCount {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalTopN) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeTopN)
	op.LogicalSchemaProducer.Hash64(h)
	if op.ByItems == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.ByItems))
		for _, one := range op.ByItems {
			one.Hash64(h)
		}
	}
	if op.PartitionBy == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.PartitionBy))
		for _, one := range op.PartitionBy {
			one.Hash64(h)
		}
	}
	h.HashUint64(uint64(op.Offset))
	h.HashUint64(uint64(op.Count))
	h.HashBool(op.PreferLimitToCop)
}

// Equals implements the Hash64Equals interface, only receive *LogicalTopN pointer.
func (op *LogicalTopN) Equals(other any) bool {
	op2, ok := other.(*LogicalTopN)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if (op.ByItems == nil && op2.ByItems != nil) || (op.ByItems != nil && op2.ByItems == nil) || len(op.ByItems) != len(op2.ByItems) {
		return false
	}
	for i, one := range op.ByItems {
		if !one.Equals(op2.ByItems[i]) {
			return false
		}
	}
	if (op.PartitionBy == nil && op2.PartitionBy != nil) || (op.PartitionBy != nil && op2.PartitionBy == nil) || len(op.PartitionBy) != len(op2.PartitionBy) {
		return false
	}
	for i, one := range op.PartitionBy {
		if !one.Equals(&op2.PartitionBy[i]) {
			return false
		}
	}
	if op.Offset != op2.Offset {
		return false
	}
	if op.Count != op2.Count {
		return false
	}
	if op.PreferLimitToCop != op2.PreferLimitToCop {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalUnionScan) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeUnionScan)
	if op.Conditions == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.Conditions))
		for _, one := range op.Conditions {
			one.Hash64(h)
		}
	}
	op.HandleCols.Hash64(h)
}

// Equals implements the Hash64Equals interface, only receive *LogicalUnionScan pointer.
func (op *LogicalUnionScan) Equals(other any) bool {
	op2, ok := other.(*LogicalUnionScan)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if (op.Conditions == nil && op2.Conditions != nil) || (op.Conditions != nil && op2.Conditions == nil) || len(op.Conditions) != len(op2.Conditions) {
		return false
	}
	for i, one := range op.Conditions {
		if !one.Equals(op2.Conditions[i]) {
			return false
		}
	}
	if !op.HandleCols.Equals(op2.HandleCols) {
		return false
	}
	return true
}

// Hash64 implements the Hash64Equals interface.
func (op *LogicalWindow) Hash64(h base.Hasher) {
	h.HashString(plancodec.TypeWindow)
	op.LogicalSchemaProducer.Hash64(h)
	if op.WindowFuncDescs == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.WindowFuncDescs))
		for _, one := range op.WindowFuncDescs {
			one.Hash64(h)
		}
	}
	if op.PartitionBy == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.PartitionBy))
		for _, one := range op.PartitionBy {
			one.Hash64(h)
		}
	}
	if op.OrderBy == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		h.HashInt(len(op.OrderBy))
		for _, one := range op.OrderBy {
			one.Hash64(h)
		}
	}
	if op.Frame == nil {
		h.HashByte(base.NilFlag)
	} else {
		h.HashByte(base.NotNilFlag)
		op.Frame.Hash64(h)
	}
}

// Equals implements the Hash64Equals interface, only receive *LogicalWindow pointer.
func (op *LogicalWindow) Equals(other any) bool {
	op2, ok := other.(*LogicalWindow)
	if !ok {
		return false
	}
	if op == nil {
		return op2 == nil
	}
	if op2 == nil {
		return false
	}
	if !op.LogicalSchemaProducer.Equals(&op2.LogicalSchemaProducer) {
		return false
	}
	if (op.WindowFuncDescs == nil && op2.WindowFuncDescs != nil) || (op.WindowFuncDescs != nil && op2.WindowFuncDescs == nil) || len(op.WindowFuncDescs) != len(op2.WindowFuncDescs) {
		return false
	}
	for i, one := range op.WindowFuncDescs {
		if !one.Equals(op2.WindowFuncDescs[i]) {
			return false
		}
	}
	if (op.PartitionBy == nil && op2.PartitionBy != nil) || (op.PartitionBy != nil && op2.PartitionBy == nil) || len(op.PartitionBy) != len(op2.PartitionBy) {
		return false
	}
	for i, one := range op.PartitionBy {
		if !one.Equals(&op2.PartitionBy[i]) {
			return false
		}
	}
	if (op.OrderBy == nil && op2.OrderBy != nil) || (op.OrderBy != nil && op2.OrderBy == nil) || len(op.OrderBy) != len(op2.OrderBy) {
		return false
	}
	for i, one := range op.OrderBy {
		if !one.Equals(&op2.OrderBy[i]) {
			return false
		}
	}
	if !op.Frame.Equals(op2.Frame) {
		return false
	}
	return true
}
