// Copyright 2019 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by go generate in expression/generator; DO NOT EDIT.

package expression

import (
	"math"
	"testing"

	"github.com/pingcap/tidb/pkg/parser/ast"
	"github.com/pingcap/tidb/pkg/parser/mysql"
	"github.com/pingcap/tidb/pkg/types"
)

type gener struct {
	defaultGener
}

func (g gener) gen() any {
	result := g.defaultGener.gen()
	if _, ok := result.(string); ok {
		dg := newDefaultGener(0, types.ETDuration)
		d := dg.gen().(types.Duration)
		if d.Duration%2 == 0 {
			d.Fsp = 0
		} else {
			d.Fsp = 1
		}
		result = d.String()
	}
	return result
}

var vecBuiltinTimeGeneratedCases = map[string][]vecExprBenchCase{
	ast.AddTime: {
		// builtinAddDatetimeAndDurationSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDuration},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETDuration)},
			},
		},
		// builtinAddDatetimeAndStringSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETString)},
			},
		},
		// builtinAddDurationAndDurationSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDuration},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDuration)},
				gener{*newDefaultGener(0.2, types.ETDuration)},
			},
		},
		// builtinAddDurationAndStringSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDuration)},
				gener{*newDefaultGener(0.2, types.ETString)},
			},
		},
		// builtinAddStringAndDurationSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDuration},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETString)},
				gener{*newDefaultGener(0.2, types.ETDuration)},
			},
		},
		// builtinAddStringAndStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETString)},
				gener{*newDefaultGener(0.2, types.ETString)},
			},
		},
		// builtinAddDateAndDurationSig
		{
			retEvalType:        types.ETString,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDuration},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDuration)},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETDuration)},
			},
		},
		// builtinAddDateAndStringSig
		{
			retEvalType:        types.ETString,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETString)},
			},
		},
		// builtinAddTimeDateTimeNullSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDatetime},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETDatetime)},
			},
		},
		// builtinAddTimeStringNullSig
		{
			retEvalType:        types.ETString,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDatetime},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDatetime)},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETDatetime)},
			},
		},
		// builtinAddTimeDurationNullSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDatetime},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDuration)},
				gener{*newDefaultGener(0.2, types.ETDatetime)},
			},
		},
	},

	ast.SubTime: {
		// builtinSubDatetimeAndDurationSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDuration},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETDuration)},
			},
		},
		// builtinSubDatetimeAndStringSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETString)},
			},
		},
		// builtinSubDurationAndDurationSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDuration},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDuration)},
				gener{*newDefaultGener(0.2, types.ETDuration)},
			},
		},
		// builtinSubDurationAndStringSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDuration)},
				gener{*newDefaultGener(0.2, types.ETString)},
			},
		},
		// builtinSubStringAndDurationSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDuration},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETString)},
				gener{*newDefaultGener(0.2, types.ETDuration)},
			},
		},
		// builtinSubStringAndStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETString)},
				gener{*newDefaultGener(0.2, types.ETString)},
			},
		},
		// builtinSubDateAndDurationSig
		{
			retEvalType:        types.ETString,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDuration},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDuration)},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETDuration)},
			},
		},
		// builtinSubDateAndStringSig
		{
			retEvalType:        types.ETString,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETString)},
			},
		},
		// builtinSubTimeDateTimeNullSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDatetime},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETDatetime)},
			},
		},
		// builtinSubTimeStringNullSig
		{
			retEvalType:        types.ETString,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDatetime},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDatetime)},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDatetime)},
				gener{*newDefaultGener(0.2, types.ETDatetime)},
			},
		},
		// builtinSubTimeDurationNullSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDatetime},
			geners: []dataGenerator{
				gener{*newDefaultGener(0.2, types.ETDuration)},
				gener{*newDefaultGener(0.2, types.ETDatetime)},
			},
		},
	},

	ast.TimeDiff: {
		// builtinNullTimeDiffSig
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDuration, types.ETDatetime}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDuration, types.ETTimestamp}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDatetime, types.ETDuration}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETTimestamp, types.ETDuration}},
		// builtinDurationDurationTimeDiffSig
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDuration, types.ETDuration}},
		// builtinDurationStringTimeDiffSig
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDuration, types.ETString}, geners: []dataGenerator{nil, &dateTimeStrGener{Year: 2019, Month: 11, Fsp: 0, randGen: newDefaultRandGen()}}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDuration, types.ETString}, geners: []dataGenerator{nil, &dateTimeStrGener{Year: 2019, Month: 10, Fsp: 0, randGen: newDefaultRandGen()}}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDuration, types.ETString}, geners: []dataGenerator{nil, &dateTimeStrGener{Year: 2019, Month: 10, Fsp: 4, randGen: newDefaultRandGen()}}},
		// builtinTimeTimeTimeDiffSig
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDatetime, types.ETDatetime}, geners: []dataGenerator{&dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}, &dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDatetime, types.ETTimestamp}, geners: []dataGenerator{&dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}, &dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETTimestamp, types.ETTimestamp}, geners: []dataGenerator{&dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}, &dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETTimestamp, types.ETDatetime}, geners: []dataGenerator{&dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}, &dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}}},
		// builtinTimeStringTimeDiffSig
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETDatetime, types.ETString}, geners: []dataGenerator{&dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}, &dateTimeStrGener{Year: 2019, Month: 10, Fsp: 0, randGen: newDefaultRandGen()}}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETTimestamp, types.ETString}, geners: []dataGenerator{&dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}, &dateTimeStrGener{Year: 2019, Month: 10, Fsp: 0, randGen: newDefaultRandGen()}}},
		// builtinStringDurationTimeDiffSig
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETString, types.ETDuration}, geners: []dataGenerator{&dateTimeStrGener{Year: 2019, Month: 10, Fsp: 0, randGen: newDefaultRandGen()}, nil}},
		// builtinStringTimeTimeDiffSig
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETString, types.ETDatetime}, geners: []dataGenerator{&dateTimeStrGener{Year: 2019, Month: 10, Fsp: 0, randGen: newDefaultRandGen()}, &dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}}},
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETString, types.ETTimestamp}, geners: []dataGenerator{&dateTimeStrGener{Year: 2019, Month: 10, Fsp: 0, randGen: newDefaultRandGen()}, &dateTimeGener{Year: 2019, Month: 10, randGen: newDefaultRandGen()}}},
		// builtinStringStringTimeDiffSig
		{retEvalType: types.ETDuration, childrenTypes: []types.EvalType{types.ETString, types.ETString}, geners: []dataGenerator{&dateTimeStrGener{Year: 2019, Month: 10, Fsp: 0, randGen: newDefaultRandGen()}, &dateTimeStrGener{Year: 2019, Month: 10, Fsp: 0, randGen: newDefaultRandGen()}}},
	},

	ast.AddDate: {
		// builtinAddDateStringStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateStringIntSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateStringRealSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateStringDecimalSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateIntStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateIntIntSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateIntRealSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateIntDecimalSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateRealStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateRealIntSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateRealRealSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateRealDecimalSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDecimalStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDecimalIntSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDecimalRealSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDecimalDecimalSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDatetimeStringSig
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDatetimeIntSig
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDatetimeRealSig
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDatetimeDecimalSig
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDatetimeStringSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDatetimeIntSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDatetimeRealSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDatetimeDecimalSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDurationStringSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDurationIntSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDurationRealSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDurationDecimalSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDurationStringSig// TODO: Make the following cases stable, i.e., shouldn't be affected by crossing a day (date part is padded to current date).
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDurationIntSig// TODO: Make the following cases stable, i.e., shouldn't be affected by crossing a day (date part is padded to current date).
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDurationRealSig// TODO: Make the following cases stable, i.e., shouldn't be affected by crossing a day (date part is padded to current date).
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinAddDateDurationDecimalSig// TODO: Make the following cases stable, i.e., shouldn't be affected by crossing a day (date part is padded to current date).
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
	},

	ast.SubDate: {
		// builtinSubDateStringStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateStringIntSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateStringRealSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateStringDecimalSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETString, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeStrGener{dateRatio: 0.2, dateStrGener: dateStrGener{randGen: newDefaultRandGen()}, dateTimeStrGener: dateTimeStrGener{Fsp: -1, randGen: newDefaultRandGen()}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateIntStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateIntIntSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateIntRealSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateIntDecimalSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETInt, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeIntGener{dateRatio: 0.2, dateIntGener: dateIntGener{dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeIntGener: dateTimeIntGener{dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateRealStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateRealIntSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateRealRealSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateRealDecimalSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETReal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeRealGener{dateRatio: 0.2, dateRealGener: dateRealGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeRealGener: dateTimeRealGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDecimalStringSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETString, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDecimalIntSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDecimalRealSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDecimalDecimalSig
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETString,
			childrenTypes: []types.EvalType{types.ETDecimal, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateOrDatetimeDecimalGener{dateRatio: 0.2, dateDecimalGener: dateDecimalGener{fspRatio: 0.5, dateGener: dateGener{randGen: newDefaultRandGen()}}, dateTimeDecimalGener: dateTimeDecimalGener{fspRatio: 0.5, dateTimeGener: dateTimeGener{randGen: newDefaultRandGen()}}}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDatetimeStringSig
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeString)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDatetimeIntSig
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeLonglong)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDatetimeRealSig
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeDouble)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDatetimeDecimalSig
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:        types.ETDatetime,
			childrenTypes:      []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			childrenFieldTypes: []*types.FieldType{types.NewFieldType(mysql.TypeDate), types.NewFieldType(mysql.TypeNewDecimal)},
			geners: []dataGenerator{
				newNullWrappedGener(0.2, dateGener{randGen: newDefaultRandGen()}),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDatetimeStringSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDatetimeIntSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDatetimeRealSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDatetimeDecimalSig
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDatetime, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDatetime),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDurationStringSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDurationIntSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDurationRealSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDurationDecimalSig
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("SECOND_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MINUTE_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("HOUR_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDuration,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MICROSECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDurationStringSig// TODO: Make the following cases stable, i.e., shouldn't be affected by crossing a day (date part is padded to current date).
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETString, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				&numStrGener{rangeInt64Gener{math.MinInt32 + 1, math.MaxInt32, newDefaultRandGen()}},
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDurationIntSig// TODO: Make the following cases stable, i.e., shouldn't be affected by crossing a day (date part is padded to current date).
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETInt, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETInt),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDurationRealSig// TODO: Make the following cases stable, i.e., shouldn't be affected by crossing a day (date part is padded to current date).
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETReal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETReal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		// builtinSubDateDurationDecimalSig// TODO: Make the following cases stable, i.e., shouldn't be affected by crossing a day (date part is padded to current date).
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("WEEK"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("QUARTER"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_SECOND"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_MINUTE"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("DAY_HOUR"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
		{
			retEvalType:   types.ETDatetime,
			childrenTypes: []types.EvalType{types.ETDuration, types.ETDecimal, types.ETString},
			geners: []dataGenerator{
				newDefaultGener(0.2, types.ETDuration),
				newDefaultGener(0.2, types.ETDecimal),
			},
			constants: []*Constant{nil, nil, {Value: types.NewStringDatum("YEAR_MONTH"), RetType: types.NewFieldType(mysql.TypeString)}},
			chunkSize: 128,
		},
	},
}

func TestVectorizedBuiltinTimeEvalOneVecGenerated(t *testing.T) {
	testVectorizedEvalOneVec(t, vecBuiltinTimeGeneratedCases)
}

func TestVectorizedBuiltinTimeFuncGenerated(t *testing.T) {
	testVectorizedBuiltinFunc(t, vecBuiltinTimeGeneratedCases)
}

func BenchmarkVectorizedBuiltinTimeEvalOneVecGenerated(b *testing.B) {
	benchmarkVectorizedEvalOneVec(b, vecBuiltinTimeGeneratedCases)
}

func BenchmarkVectorizedBuiltinTimeFuncGenerated(b *testing.B) {
	benchmarkVectorizedBuiltinFunc(b, vecBuiltinTimeGeneratedCases)
}
