// Copyright 2024 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by go generate in expression/generator; DO NOT EDIT.

package expression

import "sync/atomic"

func safeToShareAcrossSession(flag *uint32, args []Expression) bool {
	flagV := atomic.LoadUint32(flag)
	if flagV != 0 {
		return flagV == 1
	}

	allArgsSafe := true
	for _, arg := range args {
		if !arg.SafeToShareAcrossSession() {
			allArgsSafe = false
			break
		}
	}
	if allArgsSafe {
		atomic.StoreUint32(flag, 1)
	} else {
		atomic.StoreUint32(flag, 2)
	}
	return allArgsSafe
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinASCIISig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAbsDecSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAbsIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAbsRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAbsUIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAcosSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddDateAndDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddDateAndStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddDatetimeAndDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddDatetimeAndStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddDurationAndDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddDurationAndStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddStringAndDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddStringAndStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddTimeDateTimeNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddTimeDurationNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAddTimeStringNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticDivideDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticDivideRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticIntDivideDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticIntDivideIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticMinusDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticMinusIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticMinusRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticMinusVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticModDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticModIntSignedSignedSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticModIntSignedUnsignedSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticModIntUnsignedSignedSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticModIntUnsignedUnsignedSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticModRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticMultiplyDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticMultiplyIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticMultiplyIntUnsignedSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticMultiplyVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticPlusDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticPlusIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticPlusRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinArithmeticPlusVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAsinSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAtan1ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinAtan2ArgsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinBinSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinBinToUUIDSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinBitAndSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinBitCountSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinBitLengthSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinBitNegSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinBitOrSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinBitXorSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCRC32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCaseWhenDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCaseWhenDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCaseWhenIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCaseWhenJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCaseWhenRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCaseWhenStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCaseWhenTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCaseWhenVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDecimalAsDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDecimalAsDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDecimalAsIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDecimalAsJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDecimalAsRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDecimalAsStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDecimalAsTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDurationAsDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDurationAsDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDurationAsIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDurationAsJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDurationAsRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDurationAsStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastDurationAsTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastIntAsDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastIntAsDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastIntAsIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastIntAsJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastIntAsRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastIntAsStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastIntAsTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastJSONAsDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastJSONAsDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastJSONAsIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastJSONAsJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastJSONAsRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastJSONAsStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastJSONAsTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastRealAsDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastRealAsDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastRealAsIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastRealAsJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastRealAsRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastRealAsStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastRealAsTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastStringAsDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastStringAsDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastStringAsIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastStringAsJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastStringAsRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastStringAsStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastStringAsTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastStringAsVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastTimeAsDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastTimeAsDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastTimeAsIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastTimeAsJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastTimeAsRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastTimeAsStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastTimeAsTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastUnsupportedAsVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastVectorFloat32AsStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastVectorFloat32AsUnsupportedSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCastVectorFloat32AsVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCeilDecToDecSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCeilDecToIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCeilIntToDecSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCeilIntToIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCeilRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCharLengthBinarySig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCharLengthUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCharSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCharsetSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCoalesceDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCoalesceDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCoalesceIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCoalesceJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCoalesceRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCoalesceStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCoalesceTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCoalesceVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCoercibilitySig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCollationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCompressSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinConvSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinConvertSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCosSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCotSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCurrentDateSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCurrentTime0ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinCurrentTime1ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDatabaseSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDateDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDateFormatSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDateSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDayNameSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDayOfMonthSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDayOfWeekSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDayOfYearSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDecimalAnyValueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDecimalIsFalseSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDecimalIsNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDecimalIsTrueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDecodeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDegreesSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDurationAnyValueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDurationDurationTimeDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDurationIsNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinDurationStringTimeDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEQDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEQDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEQIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEQJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEQRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEQStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEQTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEQVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEltSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinEncodeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinExpSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinExportSet3ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinExportSet4ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinExportSet5ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinExtractDatetimeFromStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinExtractDatetimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinExtractDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFieldIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFieldRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFieldStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFindInSetSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFloorDecToDecSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFloorDecToIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFloorIntToDecSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFloorIntToIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFloorRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFormatBytesSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFormatNanoTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFormatSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFormatWithLocaleSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFromDaysSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFromUnixTime1ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinFromUnixTime2ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGEDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGEDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGEIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGEJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGERealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGEStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGETimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGEVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGTDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGTDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGTIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGTJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGTRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGTStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGTTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGTVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGetDecimalVarSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGetFormatSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGetIntVarSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGetParamStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGetRealVarSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGetStringVarSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGetTimeVarSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGreatestDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGreatestDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGreatestIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGreatestRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGreatestStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinGreatestVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinHexIntArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinHexStrArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinHourSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfNullDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfNullDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfNullIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfNullJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfNullRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfNullStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfNullTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfNullVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIfVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInet6AtonSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInet6NtoaSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInetAtonSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInetNtoaSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInstrSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInstrUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIntAnyValueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIntIsFalseSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIntIsNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIntIsTrueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinInternalToBinarySig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIsIPv4CompatSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIsIPv4MappedSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIsIPv4Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIsIPv6Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinIsUUIDSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONAnyValueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONArrayAppendSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONArrayInsertSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONArraySig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONContainsPathSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONContainsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONDepthSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONExtractSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONInsertSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONKeys2ArgsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONKeysSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONLengthSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONMemberOfSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONMergePatchSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONMergeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONObjectSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONOverlapsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONQuoteSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONRemoveSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONReplaceSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONSPrettySig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONSearchSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONSetSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONStorageFreeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONStorageSizeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONTypeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONUnquoteSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONValidJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONValidOthersSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinJSONValidStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLEDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLEDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLEIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLEJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLERealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLEStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLETimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLEVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLTDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLTDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLTIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLTJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLTRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLTStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLTTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLTVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLTrimSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLastDaySig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLeastDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLeastDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLeastIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLeastRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLeastStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLeastVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLeftShiftSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLeftSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLeftUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLengthSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLoadFileSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLocate2ArgsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLocate2ArgsUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLocate3ArgsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLocate3ArgsUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLog10Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLog1ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLog2ArgsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLog2Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLogicAndSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLogicOrSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLogicXorSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLowerSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinLowerUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinMD5Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinMakeDateSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinMakeSetSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinMakeTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinMicroSecondSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinMinuteSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinMonthNameSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinMonthSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNEDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNEDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNEIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNEJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNERealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNEStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNETimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNEVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNameConstDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNameConstDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNameConstIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNameConstJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNameConstRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNameConstStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNameConstTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNameConstVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNowWithArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNowWithoutArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNullEQDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNullEQDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNullEQIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNullEQJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNullEQRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNullEQStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNullEQTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNullEQVectorFloat32Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinNullTimeDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinOctIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinOctStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinOrdSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinPISig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinPasswordSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinPeriodAddSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinPeriodDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinPowSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinQuarterSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinQuoteSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRTrimSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRadiansSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRandWithSeedFirstGenSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRandomBytesSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRealAnyValueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRealIsFalseSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRealIsNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRealIsTrueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinReplaceSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinReverseSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinReverseUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRightShiftSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRightSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRightUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRoundDecSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRoundIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRoundRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRoundWithFracDecSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRoundWithFracIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRoundWithFracRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinRowSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSHA1Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSHA2Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSM3Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSecToTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSecondSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSignSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSinSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSqrtSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinStrToDateDateSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinStrToDateDatetimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinStrToDateDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinStrcmpSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinStringAnyValueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinStringDurationTimeDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinStringIsNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinStringStringTimeDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinStringTimeTimeDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubDateAndDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubDateAndStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubDatetimeAndDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubDatetimeAndStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubDurationAndDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubDurationAndStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubStringAndDurationSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubStringAndStringSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubTimeDateTimeNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubTimeDurationNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubTimeStringNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubstring2ArgsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubstring2ArgsUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubstring3ArgsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubstring3ArgsUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSubstringIndexSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSysDateWithFspSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinSysDateWithoutFspSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTanSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTiDBDecodeBinaryPlanSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTiDBDecodePlanSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTiDBEncodeSQLDigestSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTiDBVersionSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTidbParseTsoLogicalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTidbParseTsoSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTidbShardSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTimeAnyValueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTimeFormatSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTimeIsNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTimeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTimeStringTimeDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTimeTimeTimeDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTimeToSecSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTimestampAddSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTimestampDiffSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinToDaysSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinToSecondsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTranslateBinarySig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTranslateUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTrim1ArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTrim2ArgsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTrim3ArgsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTruncateDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTruncateIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTruncateRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinTruncateUintSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUTCDateSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUTCTimeWithArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUTCTimeWithoutArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUTCTimestampWithArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUTCTimestampWithoutArgSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUUIDSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUUIDToBinSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnHexSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnaryMinusIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnaryMinusRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnaryNotDecimalSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnaryNotIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnaryNotJSONSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnaryNotRealSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUncompressSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUncompressedLengthSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnixTimestampCurrentSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnixTimestampDecSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUnixTimestampIntSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUpperSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinUpperUTF8Sig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVecAsTextSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVecCosineDistanceSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVecDimsSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVecFromTextSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVecL1DistanceSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVecL2DistanceSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVecL2NormSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVecNegativeInnerProductSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVectorFloat32AnyValueSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVectorFloat32IsNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVersionSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinVitessHashSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinWeekDaySig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinWeekOfYearSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinWeekWithModeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinWeekWithoutModeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinWeightStringNullSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinYearSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinYearWeekWithModeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}

// SafeToShareAcrossSession implements BuiltinFunc.SafeToShareAcrossSession.
func (s *builtinYearWeekWithoutModeSig) SafeToShareAcrossSession() bool {
	return safeToShareAcrossSession(&s.safeToShareAcrossSessionFlag, s.args)
}
