// Copyright 2019 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by go generate in expression/generator; DO NOT EDIT.

package expression

import (
	"cmp"

	"github.com/pingcap/tidb/pkg/parser/mysql"
	"github.com/pingcap/tidb/pkg/types"
	"github.com/pingcap/tidb/pkg/util/chunk"
	"github.com/pingcap/tidb/pkg/util/collate"
)

func (b *builtinInIntSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalInt(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)

	args0 := buf0.Int64s()
	result.ResizeInt64(n, true)
	r64s := result.Int64s()
	for i := 0; i < n; i++ {
		r64s[i] = 0
	}
	hasNull := make([]bool, n)
	if b.hasNull {
		for i := 0; i < n; i++ {
			hasNull[i] = true
		}
	}
	isUnsigned0 := mysql.HasUnsignedFlag(b.args[0].GetType(ctx).GetFlag())
	var compareResult int
	args := b.args[1:]
	if len(b.hashSet) != 0 {
		for i := 0; i < n; i++ {
			if buf0.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			if isUnsigned, ok := b.hashSet[arg0]; ok {
				if (isUnsigned0 && isUnsigned) || (!isUnsigned0 && !isUnsigned) {
					r64s[i] = 1
					result.SetNull(i, false)
				}
				if arg0 >= 0 {
					r64s[i] = 1
					result.SetNull(i, false)
				}
			}
		}
		args = make([]Expression, 0, len(b.nonConstArgsIdx))
		for _, i := range b.nonConstArgsIdx {
			args = append(args, b.args[i])
		}
	}

	for j := 0; j < len(args); j++ {
		if err := args[j].VecEvalInt(ctx, input, buf1); err != nil {
			return err
		}
		isUnsigned := mysql.HasUnsignedFlag(args[j].GetType(ctx).GetFlag())
		args1 := buf1.Int64s()
		buf1.MergeNulls(buf0)
		for i := 0; i < n; i++ {
			if r64s[i] != 0 {
				continue
			}
			if buf1.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			arg1 := args1[i]
			compareResult = 1
			switch {
			case (isUnsigned0 && isUnsigned), (!isUnsigned0 && !isUnsigned):
				if arg1 == arg0 {
					compareResult = 0
				}
			case !isUnsigned0 && isUnsigned:
				if arg0 >= 0 && arg1 == arg0 {
					compareResult = 0
				}
			case isUnsigned0 && !isUnsigned:
				if arg1 >= 0 && arg1 == arg0 {
					compareResult = 0
				}
			}
			if compareResult == 0 {
				result.SetNull(i, false)
				r64s[i] = 1
			}
		} // for i
	} // for j
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			result.SetNull(i, hasNull[i])
		}
	}
	return nil
}

func (b *builtinInIntSig) vectorized() bool {
	return true
}

func (b *builtinInStringSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalString(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)

	result.ResizeInt64(n, true)
	r64s := result.Int64s()
	for i := 0; i < n; i++ {
		r64s[i] = 0
	}
	hasNull := make([]bool, n)
	if b.hasNull {
		for i := 0; i < n; i++ {
			hasNull[i] = true
		}
	}
	var compareResult int
	args := b.args[1:]
	if len(b.hashSet) != 0 {
		collator := collate.GetCollator(b.collation)
		for i := 0; i < n; i++ {
			if buf0.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := buf0.GetString(i)
			if _, ok := b.hashSet[string(collator.Key(arg0))]; ok {
				r64s[i] = 1
				result.SetNull(i, false)
			}
		}
		args = make([]Expression, 0, len(b.nonConstArgsIdx))
		for _, i := range b.nonConstArgsIdx {
			args = append(args, b.args[i])
		}
	}

	for j := 0; j < len(args); j++ {
		if err := args[j].VecEvalString(ctx, input, buf1); err != nil {
			return err
		}
		for i := 0; i < n; i++ {
			if r64s[i] != 0 {
				continue
			}
			if buf1.IsNull(i) || buf0.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := buf0.GetString(i)
			arg1 := buf1.GetString(i)
			compareResult = types.CompareString(arg0, arg1, b.collation)
			if compareResult == 0 {
				result.SetNull(i, false)
				r64s[i] = 1
			}
		} // for i
	} // for j
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			result.SetNull(i, hasNull[i])
		}
	}
	return nil
}

func (b *builtinInStringSig) vectorized() bool {
	return true
}

func (b *builtinInDecimalSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDecimal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)

	args0 := buf0.Decimals()
	result.ResizeInt64(n, true)
	r64s := result.Int64s()
	for i := 0; i < n; i++ {
		r64s[i] = 0
	}
	hasNull := make([]bool, n)
	if b.hasNull {
		for i := 0; i < n; i++ {
			hasNull[i] = true
		}
	}
	var compareResult int
	args := b.args[1:]
	if len(b.hashSet) != 0 {
		for i := 0; i < n; i++ {
			if buf0.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			key, err := arg0.ToHashKey()
			if err != nil {
				return err
			}
			if _, ok := b.hashSet[string(key)]; ok {
				r64s[i] = 1
				result.SetNull(i, false)
			}
		}
		args = make([]Expression, 0, len(b.nonConstArgsIdx))
		for _, i := range b.nonConstArgsIdx {
			args = append(args, b.args[i])
		}
	}

	for j := 0; j < len(args); j++ {
		if err := args[j].VecEvalDecimal(ctx, input, buf1); err != nil {
			return err
		}
		args1 := buf1.Decimals()
		buf1.MergeNulls(buf0)
		for i := 0; i < n; i++ {
			if r64s[i] != 0 {
				continue
			}
			if buf1.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			arg1 := args1[i]
			compareResult = 1
			if arg0.Compare(&arg1) == 0 {
				compareResult = 0
			}
			if compareResult == 0 {
				result.SetNull(i, false)
				r64s[i] = 1
			}
		} // for i
	} // for j
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			result.SetNull(i, hasNull[i])
		}
	}
	return nil
}

func (b *builtinInDecimalSig) vectorized() bool {
	return true
}

func (b *builtinInRealSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalReal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)

	args0 := buf0.Float64s()
	result.ResizeInt64(n, true)
	r64s := result.Int64s()
	for i := 0; i < n; i++ {
		r64s[i] = 0
	}
	hasNull := make([]bool, n)
	if b.hasNull {
		for i := 0; i < n; i++ {
			hasNull[i] = true
		}
	}
	var compareResult int
	args := b.args[1:]
	if len(b.hashSet) != 0 {
		for i := 0; i < n; i++ {
			if buf0.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			if _, ok := b.hashSet[arg0]; ok {
				r64s[i] = 1
				result.SetNull(i, false)
			}
		}
		args = make([]Expression, 0, len(b.nonConstArgsIdx))
		for _, i := range b.nonConstArgsIdx {
			args = append(args, b.args[i])
		}
	}

	for j := 0; j < len(args); j++ {
		if err := args[j].VecEvalReal(ctx, input, buf1); err != nil {
			return err
		}
		args1 := buf1.Float64s()
		buf1.MergeNulls(buf0)
		for i := 0; i < n; i++ {
			if r64s[i] != 0 {
				continue
			}
			if buf1.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			arg1 := args1[i]
			compareResult = cmp.Compare(arg0, arg1)
			if compareResult == 0 {
				result.SetNull(i, false)
				r64s[i] = 1
			}
		} // for i
	} // for j
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			result.SetNull(i, hasNull[i])
		}
	}
	return nil
}

func (b *builtinInRealSig) vectorized() bool {
	return true
}

func (b *builtinInTimeSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalTime(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)

	args0 := buf0.Times()
	result.ResizeInt64(n, true)
	r64s := result.Int64s()
	for i := 0; i < n; i++ {
		r64s[i] = 0
	}
	hasNull := make([]bool, n)
	if b.hasNull {
		for i := 0; i < n; i++ {
			hasNull[i] = true
		}
	}
	var compareResult int
	args := b.args[1:]
	if len(b.hashSet) != 0 {
		for i := 0; i < n; i++ {
			if buf0.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			if _, ok := b.hashSet[arg0.CoreTime()]; ok {
				r64s[i] = 1
				result.SetNull(i, false)
			}
		}
		args = make([]Expression, 0, len(b.nonConstArgsIdx))
		for _, i := range b.nonConstArgsIdx {
			args = append(args, b.args[i])
		}
	}

	for j := 0; j < len(args); j++ {
		if err := args[j].VecEvalTime(ctx, input, buf1); err != nil {
			return err
		}
		args1 := buf1.Times()
		buf1.MergeNulls(buf0)
		for i := 0; i < n; i++ {
			if r64s[i] != 0 {
				continue
			}
			if buf1.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			arg1 := args1[i]
			compareResult = arg0.Compare(arg1)
			if compareResult == 0 {
				result.SetNull(i, false)
				r64s[i] = 1
			}
		} // for i
	} // for j
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			result.SetNull(i, hasNull[i])
		}
	}
	return nil
}

func (b *builtinInTimeSig) vectorized() bool {
	return true
}

func (b *builtinInDurationSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDuration(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)

	args0 := buf0.GoDurations()
	result.ResizeInt64(n, true)
	r64s := result.Int64s()
	for i := 0; i < n; i++ {
		r64s[i] = 0
	}
	hasNull := make([]bool, n)
	if b.hasNull {
		for i := 0; i < n; i++ {
			hasNull[i] = true
		}
	}
	var compareResult int
	args := b.args[1:]
	if len(b.hashSet) != 0 {
		for i := 0; i < n; i++ {
			if buf0.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			if _, ok := b.hashSet[arg0]; ok {
				r64s[i] = 1
				result.SetNull(i, false)
			}
		}
		args = make([]Expression, 0, len(b.nonConstArgsIdx))
		for _, i := range b.nonConstArgsIdx {
			args = append(args, b.args[i])
		}
	}

	for j := 0; j < len(args); j++ {
		if err := args[j].VecEvalDuration(ctx, input, buf1); err != nil {
			return err
		}
		args1 := buf1.GoDurations()
		buf1.MergeNulls(buf0)
		for i := 0; i < n; i++ {
			if r64s[i] != 0 {
				continue
			}
			if buf1.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := args0[i]
			arg1 := args1[i]
			compareResult = cmp.Compare(arg0, arg1)
			if compareResult == 0 {
				result.SetNull(i, false)
				r64s[i] = 1
			}
		} // for i
	} // for j
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			result.SetNull(i, hasNull[i])
		}
	}
	return nil
}

func (b *builtinInDurationSig) vectorized() bool {
	return true
}

func (b *builtinInJSONSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalJSON(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)

	result.ResizeInt64(n, true)
	r64s := result.Int64s()
	for i := 0; i < n; i++ {
		r64s[i] = 0
	}
	hasNull := make([]bool, n)
	var compareResult int
	args := b.args[1:]

	for j := 0; j < len(args); j++ {
		if err := args[j].VecEvalJSON(ctx, input, buf1); err != nil {
			return err
		}
		for i := 0; i < n; i++ {
			if r64s[i] != 0 {
				continue
			}
			if buf1.IsNull(i) || buf0.IsNull(i) {
				hasNull[i] = true
				continue
			}
			arg0 := buf0.GetJSON(i)
			arg1 := buf1.GetJSON(i)
			compareResult = types.CompareBinaryJSON(arg0, arg1)
			if compareResult == 0 {
				result.SetNull(i, false)
				r64s[i] = 1
			}
		} // for i
	} // for j
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			result.SetNull(i, hasNull[i])
		}
	}
	return nil
}

func (b *builtinInJSONSig) vectorized() bool {
	return true
}
