// Copyright 2019 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by go generate in expression/generator; DO NOT EDIT.

package expression

import (
	"time"

	"github.com/pingcap/tidb/pkg/types"
	"github.com/pingcap/tidb/pkg/util/chunk"
)

// NOTE: Control expressions optionally evaluate some branches depending on conditions, but vectorization executes all
// branches, during which the unnecessary branches may return errors or warnings. To avoid this case, when branches
// meet errors or warnings, the vectorization falls back the scalar execution.

func (b *builtinCaseWhenIntSig) fallbackEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeInt64(n, false)
	x := result.Int64s()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalInt(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinCaseWhenIntSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	args, l := b.getArgs(), len(b.getArgs())
	whens := make([]*chunk.Column, l/2)
	whensSlice := make([][]int64, l/2)
	thens := make([]*chunk.Column, l/2)
	var eLse *chunk.Column
	thensSlice := make([][]int64, l/2)
	var eLseSlice []int64
	beforeWarns := warningCount(ctx)

	for j := 0; j < l-1; j += 2 {
		bufWhen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufWhen)
		err = args[j].VecEvalInt(ctx, input, bufWhen)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalInt(ctx, input, result)
		}
		whens[j/2] = bufWhen
		whensSlice[j/2] = bufWhen.Int64s()

		bufThen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufThen)
		err = args[j+1].VecEvalInt(ctx, input, bufThen)
		afterWarns = warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalInt(ctx, input, result)
		}
		thens[j/2] = bufThen
		thensSlice[j/2] = bufThen.Int64s()
	}
	// when clause(condition, result) -> args[i], args[i+1]; (i >= 0 && i+1 < l-1)
	// else clause -> args[l-1]
	// If case clause has else clause, l%2 == 1.
	if l%2 == 1 {
		bufElse, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufElse)
		err = args[l-1].VecEvalInt(ctx, input, bufElse)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalInt(ctx, input, result)
		}
		eLse = bufElse
		eLseSlice = bufElse.Int64s()
	}
	result.ResizeInt64(n, false)
	resultSlice := result.Int64s()
ROW:
	for i := 0; i < n; i++ {
		for j := 0; j < l/2; j++ {
			if whens[j].IsNull(i) || whensSlice[j][i] == 0 {
				continue
			}
			resultSlice[i] = thensSlice[j][i]
			result.SetNull(i, thens[j].IsNull(i))
			continue ROW
		}
		if eLse != nil {
			resultSlice[i] = eLseSlice[i]
			result.SetNull(i, eLse.IsNull(i))
		} else {
			result.SetNull(i, true)
		}
	}
	return nil
}

func (b *builtinCaseWhenIntSig) vectorized() bool {
	return true
}

func (b *builtinCaseWhenRealSig) fallbackEvalReal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeFloat64(n, false)
	x := result.Float64s()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalReal(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinCaseWhenRealSig) vecEvalReal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	args, l := b.getArgs(), len(b.getArgs())
	whens := make([]*chunk.Column, l/2)
	whensSlice := make([][]int64, l/2)
	thens := make([]*chunk.Column, l/2)
	var eLse *chunk.Column
	thensSlice := make([][]float64, l/2)
	var eLseSlice []float64
	beforeWarns := warningCount(ctx)

	for j := 0; j < l-1; j += 2 {
		bufWhen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufWhen)
		err = args[j].VecEvalInt(ctx, input, bufWhen)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalReal(ctx, input, result)
		}
		whens[j/2] = bufWhen
		whensSlice[j/2] = bufWhen.Int64s()

		bufThen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufThen)
		err = args[j+1].VecEvalReal(ctx, input, bufThen)
		afterWarns = warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalReal(ctx, input, result)
		}
		thens[j/2] = bufThen
		thensSlice[j/2] = bufThen.Float64s()
	}
	// when clause(condition, result) -> args[i], args[i+1]; (i >= 0 && i+1 < l-1)
	// else clause -> args[l-1]
	// If case clause has else clause, l%2 == 1.
	if l%2 == 1 {
		bufElse, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufElse)
		err = args[l-1].VecEvalReal(ctx, input, bufElse)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalReal(ctx, input, result)
		}
		eLse = bufElse
		eLseSlice = bufElse.Float64s()
	}
	result.ResizeFloat64(n, false)
	resultSlice := result.Float64s()
ROW:
	for i := 0; i < n; i++ {
		for j := 0; j < l/2; j++ {
			if whens[j].IsNull(i) || whensSlice[j][i] == 0 {
				continue
			}
			resultSlice[i] = thensSlice[j][i]
			result.SetNull(i, thens[j].IsNull(i))
			continue ROW
		}
		if eLse != nil {
			resultSlice[i] = eLseSlice[i]
			result.SetNull(i, eLse.IsNull(i))
		} else {
			result.SetNull(i, true)
		}
	}
	return nil
}

func (b *builtinCaseWhenRealSig) vectorized() bool {
	return true
}

func (b *builtinCaseWhenDecimalSig) fallbackEvalDecimal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeDecimal(n, false)
	x := result.Decimals()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalDecimal(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = *res

	}
	return nil
}

func (b *builtinCaseWhenDecimalSig) vecEvalDecimal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	args, l := b.getArgs(), len(b.getArgs())
	whens := make([]*chunk.Column, l/2)
	whensSlice := make([][]int64, l/2)
	thens := make([]*chunk.Column, l/2)
	var eLse *chunk.Column
	thensSlice := make([][]types.MyDecimal, l/2)
	var eLseSlice []types.MyDecimal
	beforeWarns := warningCount(ctx)

	for j := 0; j < l-1; j += 2 {
		bufWhen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufWhen)
		err = args[j].VecEvalInt(ctx, input, bufWhen)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalDecimal(ctx, input, result)
		}
		whens[j/2] = bufWhen
		whensSlice[j/2] = bufWhen.Int64s()

		bufThen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufThen)
		err = args[j+1].VecEvalDecimal(ctx, input, bufThen)
		afterWarns = warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalDecimal(ctx, input, result)
		}
		thens[j/2] = bufThen
		thensSlice[j/2] = bufThen.Decimals()
	}
	// when clause(condition, result) -> args[i], args[i+1]; (i >= 0 && i+1 < l-1)
	// else clause -> args[l-1]
	// If case clause has else clause, l%2 == 1.
	if l%2 == 1 {
		bufElse, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufElse)
		err = args[l-1].VecEvalDecimal(ctx, input, bufElse)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalDecimal(ctx, input, result)
		}
		eLse = bufElse
		eLseSlice = bufElse.Decimals()
	}
	result.ResizeDecimal(n, false)
	resultSlice := result.Decimals()
ROW:
	for i := 0; i < n; i++ {
		for j := 0; j < l/2; j++ {
			if whens[j].IsNull(i) || whensSlice[j][i] == 0 {
				continue
			}
			resultSlice[i] = thensSlice[j][i]
			result.SetNull(i, thens[j].IsNull(i))
			continue ROW
		}
		if eLse != nil {
			resultSlice[i] = eLseSlice[i]
			result.SetNull(i, eLse.IsNull(i))
		} else {
			result.SetNull(i, true)
		}
	}
	return nil
}

func (b *builtinCaseWhenDecimalSig) vectorized() bool {
	return true
}

func (b *builtinCaseWhenStringSig) fallbackEvalString(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ReserveString(n)
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalString(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		if isNull {
			result.AppendNull()
			continue
		}
		result.AppendString(res)
	}
	return nil
}

func (b *builtinCaseWhenStringSig) vecEvalString(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	args, l := b.getArgs(), len(b.getArgs())
	whens := make([]*chunk.Column, l/2)
	whensSlice := make([][]int64, l/2)
	thens := make([]*chunk.Column, l/2)
	var eLse *chunk.Column
	beforeWarns := warningCount(ctx)

	for j := 0; j < l-1; j += 2 {
		bufWhen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufWhen)
		err = args[j].VecEvalInt(ctx, input, bufWhen)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalString(ctx, input, result)
		}
		whens[j/2] = bufWhen
		whensSlice[j/2] = bufWhen.Int64s()

		bufThen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufThen)
		err = args[j+1].VecEvalString(ctx, input, bufThen)
		afterWarns = warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalString(ctx, input, result)
		}
		thens[j/2] = bufThen
	}
	// when clause(condition, result) -> args[i], args[i+1]; (i >= 0 && i+1 < l-1)
	// else clause -> args[l-1]
	// If case clause has else clause, l%2 == 1.
	if l%2 == 1 {
		bufElse, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufElse)
		err = args[l-1].VecEvalString(ctx, input, bufElse)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalString(ctx, input, result)
		}
		eLse = bufElse
	}
	result.ReserveString(n)
ROW:
	for i := 0; i < n; i++ {
		for j := 0; j < l/2; j++ {
			if whens[j].IsNull(i) || whensSlice[j][i] == 0 {
				continue
			}
			if thens[j].IsNull(i) {
				result.AppendNull()
			} else {
				result.AppendString(thens[j].GetString(i))
			}
			continue ROW
		}
		if eLse != nil {
			if eLse.IsNull(i) {
				result.AppendNull()
			} else {
				result.AppendString(eLse.GetString(i))
			}
		} else {
			result.AppendNull()
		}
	}
	return nil
}

func (b *builtinCaseWhenStringSig) vectorized() bool {
	return true
}

func (b *builtinCaseWhenTimeSig) fallbackEvalTime(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeTime(n, false)
	x := result.Times()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalTime(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinCaseWhenTimeSig) vecEvalTime(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	args, l := b.getArgs(), len(b.getArgs())
	whens := make([]*chunk.Column, l/2)
	whensSlice := make([][]int64, l/2)
	thens := make([]*chunk.Column, l/2)
	var eLse *chunk.Column
	thensSlice := make([][]types.Time, l/2)
	var eLseSlice []types.Time
	beforeWarns := warningCount(ctx)

	for j := 0; j < l-1; j += 2 {
		bufWhen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufWhen)
		err = args[j].VecEvalInt(ctx, input, bufWhen)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalTime(ctx, input, result)
		}
		whens[j/2] = bufWhen
		whensSlice[j/2] = bufWhen.Int64s()

		bufThen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufThen)
		err = args[j+1].VecEvalTime(ctx, input, bufThen)
		afterWarns = warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalTime(ctx, input, result)
		}
		thens[j/2] = bufThen
		thensSlice[j/2] = bufThen.Times()
	}
	// when clause(condition, result) -> args[i], args[i+1]; (i >= 0 && i+1 < l-1)
	// else clause -> args[l-1]
	// If case clause has else clause, l%2 == 1.
	if l%2 == 1 {
		bufElse, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufElse)
		err = args[l-1].VecEvalTime(ctx, input, bufElse)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalTime(ctx, input, result)
		}
		eLse = bufElse
		eLseSlice = bufElse.Times()
	}
	result.ResizeTime(n, false)
	resultSlice := result.Times()
ROW:
	for i := 0; i < n; i++ {
		for j := 0; j < l/2; j++ {
			if whens[j].IsNull(i) || whensSlice[j][i] == 0 {
				continue
			}
			resultSlice[i] = thensSlice[j][i]
			result.SetNull(i, thens[j].IsNull(i))
			continue ROW
		}
		if eLse != nil {
			resultSlice[i] = eLseSlice[i]
			result.SetNull(i, eLse.IsNull(i))
		} else {
			result.SetNull(i, true)
		}
	}
	return nil
}

func (b *builtinCaseWhenTimeSig) vectorized() bool {
	return true
}

func (b *builtinCaseWhenDurationSig) fallbackEvalDuration(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeGoDuration(n, false)
	x := result.GoDurations()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalDuration(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res.Duration

	}
	return nil
}

func (b *builtinCaseWhenDurationSig) vecEvalDuration(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	args, l := b.getArgs(), len(b.getArgs())
	whens := make([]*chunk.Column, l/2)
	whensSlice := make([][]int64, l/2)
	thens := make([]*chunk.Column, l/2)
	var eLse *chunk.Column
	thensSlice := make([][]time.Duration, l/2)
	var eLseSlice []time.Duration
	beforeWarns := warningCount(ctx)

	for j := 0; j < l-1; j += 2 {
		bufWhen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufWhen)
		err = args[j].VecEvalInt(ctx, input, bufWhen)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalDuration(ctx, input, result)
		}
		whens[j/2] = bufWhen
		whensSlice[j/2] = bufWhen.Int64s()

		bufThen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufThen)
		err = args[j+1].VecEvalDuration(ctx, input, bufThen)
		afterWarns = warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalDuration(ctx, input, result)
		}
		thens[j/2] = bufThen
		thensSlice[j/2] = bufThen.GoDurations()
	}
	// when clause(condition, result) -> args[i], args[i+1]; (i >= 0 && i+1 < l-1)
	// else clause -> args[l-1]
	// If case clause has else clause, l%2 == 1.
	if l%2 == 1 {
		bufElse, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufElse)
		err = args[l-1].VecEvalDuration(ctx, input, bufElse)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalDuration(ctx, input, result)
		}
		eLse = bufElse
		eLseSlice = bufElse.GoDurations()
	}
	result.ResizeGoDuration(n, false)
	resultSlice := result.GoDurations()
ROW:
	for i := 0; i < n; i++ {
		for j := 0; j < l/2; j++ {
			if whens[j].IsNull(i) || whensSlice[j][i] == 0 {
				continue
			}
			resultSlice[i] = thensSlice[j][i]
			result.SetNull(i, thens[j].IsNull(i))
			continue ROW
		}
		if eLse != nil {
			resultSlice[i] = eLseSlice[i]
			result.SetNull(i, eLse.IsNull(i))
		} else {
			result.SetNull(i, true)
		}
	}
	return nil
}

func (b *builtinCaseWhenDurationSig) vectorized() bool {
	return true
}

func (b *builtinCaseWhenJSONSig) fallbackEvalJSON(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ReserveJSON(n)
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalJSON(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		if isNull {
			result.AppendNull()
			continue
		}
		result.AppendJSON(res)
	}
	return nil
}

func (b *builtinCaseWhenJSONSig) vecEvalJSON(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	args, l := b.getArgs(), len(b.getArgs())
	whens := make([]*chunk.Column, l/2)
	whensSlice := make([][]int64, l/2)
	thens := make([]*chunk.Column, l/2)
	var eLse *chunk.Column
	beforeWarns := warningCount(ctx)

	for j := 0; j < l-1; j += 2 {
		bufWhen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufWhen)
		err = args[j].VecEvalInt(ctx, input, bufWhen)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalJSON(ctx, input, result)
		}
		whens[j/2] = bufWhen
		whensSlice[j/2] = bufWhen.Int64s()

		bufThen, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufThen)
		err = args[j+1].VecEvalJSON(ctx, input, bufThen)
		afterWarns = warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalJSON(ctx, input, result)
		}
		thens[j/2] = bufThen
	}
	// when clause(condition, result) -> args[i], args[i+1]; (i >= 0 && i+1 < l-1)
	// else clause -> args[l-1]
	// If case clause has else clause, l%2 == 1.
	if l%2 == 1 {
		bufElse, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(bufElse)
		err = args[l-1].VecEvalJSON(ctx, input, bufElse)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalJSON(ctx, input, result)
		}
		eLse = bufElse
	}
	result.ReserveJSON(n)
ROW:
	for i := 0; i < n; i++ {
		for j := 0; j < l/2; j++ {
			if whens[j].IsNull(i) || whensSlice[j][i] == 0 {
				continue
			}
			if thens[j].IsNull(i) {
				result.AppendNull()
			} else {
				result.AppendJSON(thens[j].GetJSON(i))
			}
			continue ROW
		}
		if eLse != nil {
			if eLse.IsNull(i) {
				result.AppendNull()
			} else {
				result.AppendJSON(eLse.GetJSON(i))
			}
		} else {
			result.AppendNull()
		}
	}
	return nil
}

func (b *builtinCaseWhenJSONSig) vectorized() bool {
	return true
}

func (b *builtinIfNullIntSig) fallbackEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeInt64(n, false)
	x := result.Int64s()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalInt(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinIfNullIntSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	if err := b.args[0].VecEvalInt(ctx, input, result); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalInt(ctx, input, buf1)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalInt(ctx, input, result)
	}
	arg0 := result.Int64s()
	arg1 := buf1.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) && !buf1.IsNull(i) {
			result.SetNull(i, false)
			arg0[i] = arg1[i]
		}
	}
	return nil
}

func (b *builtinIfNullIntSig) vectorized() bool {
	return true
}

func (b *builtinIfNullRealSig) fallbackEvalReal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeFloat64(n, false)
	x := result.Float64s()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalReal(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinIfNullRealSig) vecEvalReal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	if err := b.args[0].VecEvalReal(ctx, input, result); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalReal(ctx, input, buf1)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalReal(ctx, input, result)
	}
	arg0 := result.Float64s()
	arg1 := buf1.Float64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) && !buf1.IsNull(i) {
			result.SetNull(i, false)
			arg0[i] = arg1[i]
		}
	}
	return nil
}

func (b *builtinIfNullRealSig) vectorized() bool {
	return true
}

func (b *builtinIfNullDecimalSig) fallbackEvalDecimal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeDecimal(n, false)
	x := result.Decimals()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalDecimal(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = *res

	}
	return nil
}

func (b *builtinIfNullDecimalSig) vecEvalDecimal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	if err := b.args[0].VecEvalDecimal(ctx, input, result); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalDecimal(ctx, input, buf1)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalDecimal(ctx, input, result)
	}
	arg0 := result.Decimals()
	arg1 := buf1.Decimals()
	for i := 0; i < n; i++ {
		if result.IsNull(i) && !buf1.IsNull(i) {
			result.SetNull(i, false)
			arg0[i] = arg1[i]
		}
	}
	return nil
}

func (b *builtinIfNullDecimalSig) vectorized() bool {
	return true
}

func (b *builtinIfNullStringSig) fallbackEvalString(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ReserveString(n)
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalString(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		if isNull {
			result.AppendNull()
			continue
		}
		result.AppendString(res)
	}
	return nil
}

func (b *builtinIfNullStringSig) vecEvalString(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalString(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalString(ctx, input, buf1)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalString(ctx, input, result)
	}

	result.ReserveString(n)
	for i := 0; i < n; i++ {
		if !buf0.IsNull(i) {
			result.AppendString(buf0.GetString(i))
		} else if !buf1.IsNull(i) {
			result.AppendString(buf1.GetString(i))
		} else {
			result.AppendNull()
		}
	}
	return nil
}

func (b *builtinIfNullStringSig) vectorized() bool {
	return true
}

func (b *builtinIfNullTimeSig) fallbackEvalTime(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeTime(n, false)
	x := result.Times()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalTime(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinIfNullTimeSig) vecEvalTime(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	if err := b.args[0].VecEvalTime(ctx, input, result); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalTime(ctx, input, buf1)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalTime(ctx, input, result)
	}
	arg0 := result.Times()
	arg1 := buf1.Times()
	for i := 0; i < n; i++ {
		if result.IsNull(i) && !buf1.IsNull(i) {
			result.SetNull(i, false)
			arg0[i] = arg1[i]
		}
	}
	return nil
}

func (b *builtinIfNullTimeSig) vectorized() bool {
	return true
}

func (b *builtinIfNullDurationSig) fallbackEvalDuration(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeGoDuration(n, false)
	x := result.GoDurations()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalDuration(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res.Duration

	}
	return nil
}

func (b *builtinIfNullDurationSig) vecEvalDuration(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	if err := b.args[0].VecEvalDuration(ctx, input, result); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalDuration(ctx, input, buf1)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalDuration(ctx, input, result)
	}
	arg0 := result.GoDurations()
	arg1 := buf1.GoDurations()
	for i := 0; i < n; i++ {
		if result.IsNull(i) && !buf1.IsNull(i) {
			result.SetNull(i, false)
			arg0[i] = arg1[i]
		}
	}
	return nil
}

func (b *builtinIfNullDurationSig) vectorized() bool {
	return true
}

func (b *builtinIfNullJSONSig) fallbackEvalJSON(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ReserveJSON(n)
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalJSON(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		if isNull {
			result.AppendNull()
			continue
		}
		result.AppendJSON(res)
	}
	return nil
}

func (b *builtinIfNullJSONSig) vecEvalJSON(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalJSON(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalJSON(ctx, input, buf1)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalJSON(ctx, input, result)
	}

	result.ReserveJSON(n)
	for i := 0; i < n; i++ {
		if !buf0.IsNull(i) {
			result.AppendJSON(buf0.GetJSON(i))
		} else if !buf1.IsNull(i) {
			result.AppendJSON(buf1.GetJSON(i))
		} else {
			result.AppendNull()
		}
	}
	return nil
}

func (b *builtinIfNullJSONSig) vectorized() bool {
	return true
}

func (b *builtinIfIntSig) fallbackEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeInt64(n, false)
	x := result.Int64s()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalInt(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinIfIntSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalInt(ctx, input, buf0); err != nil {
		return err
	}
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalInt(ctx, input, result)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalInt(ctx, input, result)
	}

	buf2, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf2)
	err = b.args[2].VecEvalInt(ctx, input, buf2)
	afterWarns = warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalInt(ctx, input, result)
	}

	arg0 := buf0.Int64s()
	arg2 := buf2.Int64s()
	rs := result.Int64s()
	for i := 0; i < n; i++ {
		arg := arg0[i]
		isNull0 := buf0.IsNull(i)
		switch {
		case isNull0 || arg == 0:
			if buf2.IsNull(i) {
				result.SetNull(i, true)
			} else {
				result.SetNull(i, false)
				rs[i] = arg2[i]
			}
		case arg != 0:
		}
	}
	return nil
}

func (b *builtinIfIntSig) vectorized() bool {
	return true
}

func (b *builtinIfRealSig) fallbackEvalReal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeFloat64(n, false)
	x := result.Float64s()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalReal(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinIfRealSig) vecEvalReal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalInt(ctx, input, buf0); err != nil {
		return err
	}
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalReal(ctx, input, result)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalReal(ctx, input, result)
	}

	buf2, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf2)
	err = b.args[2].VecEvalReal(ctx, input, buf2)
	afterWarns = warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalReal(ctx, input, result)
	}

	arg0 := buf0.Int64s()
	arg2 := buf2.Float64s()
	rs := result.Float64s()
	for i := 0; i < n; i++ {
		arg := arg0[i]
		isNull0 := buf0.IsNull(i)
		switch {
		case isNull0 || arg == 0:
			if buf2.IsNull(i) {
				result.SetNull(i, true)
			} else {
				result.SetNull(i, false)
				rs[i] = arg2[i]
			}
		case arg != 0:
		}
	}
	return nil
}

func (b *builtinIfRealSig) vectorized() bool {
	return true
}

func (b *builtinIfDecimalSig) fallbackEvalDecimal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeDecimal(n, false)
	x := result.Decimals()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalDecimal(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = *res

	}
	return nil
}

func (b *builtinIfDecimalSig) vecEvalDecimal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalInt(ctx, input, buf0); err != nil {
		return err
	}
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalDecimal(ctx, input, result)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalDecimal(ctx, input, result)
	}

	buf2, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf2)
	err = b.args[2].VecEvalDecimal(ctx, input, buf2)
	afterWarns = warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalDecimal(ctx, input, result)
	}

	arg0 := buf0.Int64s()
	arg2 := buf2.Decimals()
	rs := result.Decimals()
	for i := 0; i < n; i++ {
		arg := arg0[i]
		isNull0 := buf0.IsNull(i)
		switch {
		case isNull0 || arg == 0:
			if buf2.IsNull(i) {
				result.SetNull(i, true)
			} else {
				result.SetNull(i, false)
				rs[i] = arg2[i]
			}
		case arg != 0:
		}
	}
	return nil
}

func (b *builtinIfDecimalSig) vectorized() bool {
	return true
}

func (b *builtinIfStringSig) fallbackEvalString(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ReserveString(n)
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalString(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		if isNull {
			result.AppendNull()
			continue
		}
		result.AppendString(res)
	}
	return nil
}

func (b *builtinIfStringSig) vecEvalString(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalInt(ctx, input, buf0); err != nil {
		return err
	}
	beforeWarns := warningCount(ctx)
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	err = b.args[1].VecEvalString(ctx, input, buf1)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalString(ctx, input, result)
	}

	buf2, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf2)
	err = b.args[2].VecEvalString(ctx, input, buf2)
	afterWarns = warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalString(ctx, input, result)
	}

	result.ReserveString(n)
	arg0 := buf0.Int64s()
	for i := 0; i < n; i++ {
		arg := arg0[i]
		isNull0 := buf0.IsNull(i)
		switch {
		case isNull0 || arg == 0:
			if buf2.IsNull(i) {
				result.AppendNull()
			} else {
				result.AppendString(buf2.GetString(i))
			}
		case arg != 0:
			if buf1.IsNull(i) {
				result.AppendNull()
			} else {
				result.AppendString(buf1.GetString(i))
			}
		}
	}
	return nil
}

func (b *builtinIfStringSig) vectorized() bool {
	return true
}

func (b *builtinIfTimeSig) fallbackEvalTime(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeTime(n, false)
	x := result.Times()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalTime(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinIfTimeSig) vecEvalTime(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalInt(ctx, input, buf0); err != nil {
		return err
	}
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalTime(ctx, input, result)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalTime(ctx, input, result)
	}

	buf2, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf2)
	err = b.args[2].VecEvalTime(ctx, input, buf2)
	afterWarns = warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalTime(ctx, input, result)
	}

	arg0 := buf0.Int64s()
	arg2 := buf2.Times()
	rs := result.Times()
	for i := 0; i < n; i++ {
		arg := arg0[i]
		isNull0 := buf0.IsNull(i)
		switch {
		case isNull0 || arg == 0:
			if buf2.IsNull(i) {
				result.SetNull(i, true)
			} else {
				result.SetNull(i, false)
				rs[i] = arg2[i]
			}
		case arg != 0:
		}
	}
	return nil
}

func (b *builtinIfTimeSig) vectorized() bool {
	return true
}

func (b *builtinIfDurationSig) fallbackEvalDuration(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeGoDuration(n, false)
	x := result.GoDurations()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalDuration(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res.Duration

	}
	return nil
}

func (b *builtinIfDurationSig) vecEvalDuration(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalInt(ctx, input, buf0); err != nil {
		return err
	}
	beforeWarns := warningCount(ctx)
	err = b.args[1].VecEvalDuration(ctx, input, result)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalDuration(ctx, input, result)
	}

	buf2, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf2)
	err = b.args[2].VecEvalDuration(ctx, input, buf2)
	afterWarns = warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalDuration(ctx, input, result)
	}

	arg0 := buf0.Int64s()
	arg2 := buf2.GoDurations()
	rs := result.GoDurations()
	for i := 0; i < n; i++ {
		arg := arg0[i]
		isNull0 := buf0.IsNull(i)
		switch {
		case isNull0 || arg == 0:
			if buf2.IsNull(i) {
				result.SetNull(i, true)
			} else {
				result.SetNull(i, false)
				rs[i] = arg2[i]
			}
		case arg != 0:
		}
	}
	return nil
}

func (b *builtinIfDurationSig) vectorized() bool {
	return true
}

func (b *builtinIfJSONSig) fallbackEvalJSON(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ReserveJSON(n)
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalJSON(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		if isNull {
			result.AppendNull()
			continue
		}
		result.AppendJSON(res)
	}
	return nil
}

func (b *builtinIfJSONSig) vecEvalJSON(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalInt(ctx, input, buf0); err != nil {
		return err
	}
	beforeWarns := warningCount(ctx)
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	err = b.args[1].VecEvalJSON(ctx, input, buf1)
	afterWarns := warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalJSON(ctx, input, result)
	}

	buf2, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf2)
	err = b.args[2].VecEvalJSON(ctx, input, buf2)
	afterWarns = warningCount(ctx)
	if err != nil || afterWarns > beforeWarns {
		if afterWarns > beforeWarns {
			truncateWarnings(ctx, beforeWarns)
		}
		return b.fallbackEvalJSON(ctx, input, result)
	}

	result.ReserveJSON(n)
	arg0 := buf0.Int64s()
	for i := 0; i < n; i++ {
		arg := arg0[i]
		isNull0 := buf0.IsNull(i)
		switch {
		case isNull0 || arg == 0:
			if buf2.IsNull(i) {
				result.AppendNull()
			} else {
				result.AppendJSON(buf2.GetJSON(i))
			}
		case arg != 0:
			if buf1.IsNull(i) {
				result.AppendNull()
			} else {
				result.AppendJSON(buf1.GetJSON(i))
			}
		}
	}
	return nil
}

func (b *builtinIfJSONSig) vectorized() bool {
	return true
}
