// Copyright 2019 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by go generate in expression/generator; DO NOT EDIT.

package expression

import (
	"cmp"

	"github.com/pingcap/tidb/pkg/types"
	"github.com/pingcap/tidb/pkg/util/chunk"
)

func (b *builtinLTRealSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalReal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalReal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Float64s()
	arg1 := buf1.Float64s()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val < 0)
	}
	return nil
}

func (b *builtinLTRealSig) vectorized() bool {
	return true
}

func (b *builtinLTDecimalSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDecimal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDecimal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Decimals()
	arg1 := buf1.Decimals()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(&arg1[i])
		i64s[i] = boolToInt64(val < 0)
	}
	return nil
}

func (b *builtinLTDecimalSig) vectorized() bool {
	return true
}

func (b *builtinLTStringSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalString(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalString(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareString(buf0.GetString(i), buf1.GetString(i), b.collation)
		i64s[i] = boolToInt64(val < 0)
	}
	return nil
}

func (b *builtinLTStringSig) vectorized() bool {
	return true
}

func (b *builtinLTTimeSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalTime(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalTime(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Times()
	arg1 := buf1.Times()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(arg1[i])
		i64s[i] = boolToInt64(val < 0)
	}
	return nil
}

func (b *builtinLTTimeSig) vectorized() bool {
	return true
}

func (b *builtinLTDurationSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDuration(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDuration(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.GoDurations()
	arg1 := buf1.GoDurations()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val < 0)
	}
	return nil
}

func (b *builtinLTDurationSig) vectorized() bool {
	return true
}

func (b *builtinLTJSONSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalJSON(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalJSON(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareBinaryJSON(buf0.GetJSON(i), buf1.GetJSON(i))
		i64s[i] = boolToInt64(val < 0)
	}
	return nil
}

func (b *builtinLTJSONSig) vectorized() bool {
	return true
}

func (b *builtinLERealSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalReal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalReal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Float64s()
	arg1 := buf1.Float64s()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val <= 0)
	}
	return nil
}

func (b *builtinLERealSig) vectorized() bool {
	return true
}

func (b *builtinLEDecimalSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDecimal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDecimal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Decimals()
	arg1 := buf1.Decimals()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(&arg1[i])
		i64s[i] = boolToInt64(val <= 0)
	}
	return nil
}

func (b *builtinLEDecimalSig) vectorized() bool {
	return true
}

func (b *builtinLEStringSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalString(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalString(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareString(buf0.GetString(i), buf1.GetString(i), b.collation)
		i64s[i] = boolToInt64(val <= 0)
	}
	return nil
}

func (b *builtinLEStringSig) vectorized() bool {
	return true
}

func (b *builtinLETimeSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalTime(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalTime(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Times()
	arg1 := buf1.Times()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(arg1[i])
		i64s[i] = boolToInt64(val <= 0)
	}
	return nil
}

func (b *builtinLETimeSig) vectorized() bool {
	return true
}

func (b *builtinLEDurationSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDuration(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDuration(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.GoDurations()
	arg1 := buf1.GoDurations()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val <= 0)
	}
	return nil
}

func (b *builtinLEDurationSig) vectorized() bool {
	return true
}

func (b *builtinLEJSONSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalJSON(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalJSON(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareBinaryJSON(buf0.GetJSON(i), buf1.GetJSON(i))
		i64s[i] = boolToInt64(val <= 0)
	}
	return nil
}

func (b *builtinLEJSONSig) vectorized() bool {
	return true
}

func (b *builtinGTRealSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalReal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalReal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Float64s()
	arg1 := buf1.Float64s()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val > 0)
	}
	return nil
}

func (b *builtinGTRealSig) vectorized() bool {
	return true
}

func (b *builtinGTDecimalSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDecimal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDecimal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Decimals()
	arg1 := buf1.Decimals()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(&arg1[i])
		i64s[i] = boolToInt64(val > 0)
	}
	return nil
}

func (b *builtinGTDecimalSig) vectorized() bool {
	return true
}

func (b *builtinGTStringSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalString(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalString(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareString(buf0.GetString(i), buf1.GetString(i), b.collation)
		i64s[i] = boolToInt64(val > 0)
	}
	return nil
}

func (b *builtinGTStringSig) vectorized() bool {
	return true
}

func (b *builtinGTTimeSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalTime(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalTime(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Times()
	arg1 := buf1.Times()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(arg1[i])
		i64s[i] = boolToInt64(val > 0)
	}
	return nil
}

func (b *builtinGTTimeSig) vectorized() bool {
	return true
}

func (b *builtinGTDurationSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDuration(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDuration(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.GoDurations()
	arg1 := buf1.GoDurations()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val > 0)
	}
	return nil
}

func (b *builtinGTDurationSig) vectorized() bool {
	return true
}

func (b *builtinGTJSONSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalJSON(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalJSON(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareBinaryJSON(buf0.GetJSON(i), buf1.GetJSON(i))
		i64s[i] = boolToInt64(val > 0)
	}
	return nil
}

func (b *builtinGTJSONSig) vectorized() bool {
	return true
}

func (b *builtinGERealSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalReal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalReal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Float64s()
	arg1 := buf1.Float64s()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val >= 0)
	}
	return nil
}

func (b *builtinGERealSig) vectorized() bool {
	return true
}

func (b *builtinGEDecimalSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDecimal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDecimal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Decimals()
	arg1 := buf1.Decimals()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(&arg1[i])
		i64s[i] = boolToInt64(val >= 0)
	}
	return nil
}

func (b *builtinGEDecimalSig) vectorized() bool {
	return true
}

func (b *builtinGEStringSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalString(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalString(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareString(buf0.GetString(i), buf1.GetString(i), b.collation)
		i64s[i] = boolToInt64(val >= 0)
	}
	return nil
}

func (b *builtinGEStringSig) vectorized() bool {
	return true
}

func (b *builtinGETimeSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalTime(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalTime(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Times()
	arg1 := buf1.Times()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(arg1[i])
		i64s[i] = boolToInt64(val >= 0)
	}
	return nil
}

func (b *builtinGETimeSig) vectorized() bool {
	return true
}

func (b *builtinGEDurationSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDuration(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDuration(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.GoDurations()
	arg1 := buf1.GoDurations()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val >= 0)
	}
	return nil
}

func (b *builtinGEDurationSig) vectorized() bool {
	return true
}

func (b *builtinGEJSONSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalJSON(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalJSON(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareBinaryJSON(buf0.GetJSON(i), buf1.GetJSON(i))
		i64s[i] = boolToInt64(val >= 0)
	}
	return nil
}

func (b *builtinGEJSONSig) vectorized() bool {
	return true
}

func (b *builtinEQRealSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalReal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalReal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Float64s()
	arg1 := buf1.Float64s()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val == 0)
	}
	return nil
}

func (b *builtinEQRealSig) vectorized() bool {
	return true
}

func (b *builtinEQDecimalSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDecimal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDecimal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Decimals()
	arg1 := buf1.Decimals()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(&arg1[i])
		i64s[i] = boolToInt64(val == 0)
	}
	return nil
}

func (b *builtinEQDecimalSig) vectorized() bool {
	return true
}

func (b *builtinEQStringSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalString(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalString(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareString(buf0.GetString(i), buf1.GetString(i), b.collation)
		i64s[i] = boolToInt64(val == 0)
	}
	return nil
}

func (b *builtinEQStringSig) vectorized() bool {
	return true
}

func (b *builtinEQTimeSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalTime(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalTime(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Times()
	arg1 := buf1.Times()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(arg1[i])
		i64s[i] = boolToInt64(val == 0)
	}
	return nil
}

func (b *builtinEQTimeSig) vectorized() bool {
	return true
}

func (b *builtinEQDurationSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDuration(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDuration(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.GoDurations()
	arg1 := buf1.GoDurations()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val == 0)
	}
	return nil
}

func (b *builtinEQDurationSig) vectorized() bool {
	return true
}

func (b *builtinEQJSONSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalJSON(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalJSON(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareBinaryJSON(buf0.GetJSON(i), buf1.GetJSON(i))
		i64s[i] = boolToInt64(val == 0)
	}
	return nil
}

func (b *builtinEQJSONSig) vectorized() bool {
	return true
}

func (b *builtinNERealSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalReal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalReal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Float64s()
	arg1 := buf1.Float64s()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val != 0)
	}
	return nil
}

func (b *builtinNERealSig) vectorized() bool {
	return true
}

func (b *builtinNEDecimalSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDecimal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDecimal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Decimals()
	arg1 := buf1.Decimals()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(&arg1[i])
		i64s[i] = boolToInt64(val != 0)
	}
	return nil
}

func (b *builtinNEDecimalSig) vectorized() bool {
	return true
}

func (b *builtinNEStringSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalString(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalString(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareString(buf0.GetString(i), buf1.GetString(i), b.collation)
		i64s[i] = boolToInt64(val != 0)
	}
	return nil
}

func (b *builtinNEStringSig) vectorized() bool {
	return true
}

func (b *builtinNETimeSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalTime(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalTime(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Times()
	arg1 := buf1.Times()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := arg0[i].Compare(arg1[i])
		i64s[i] = boolToInt64(val != 0)
	}
	return nil
}

func (b *builtinNETimeSig) vectorized() bool {
	return true
}

func (b *builtinNEDurationSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDuration(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDuration(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.GoDurations()
	arg1 := buf1.GoDurations()
	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := cmp.Compare(arg0[i], arg1[i])
		i64s[i] = boolToInt64(val != 0)
	}
	return nil
}

func (b *builtinNEDurationSig) vectorized() bool {
	return true
}

func (b *builtinNEJSONSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalJSON(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalJSON(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	result.MergeNulls(buf0, buf1)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		if result.IsNull(i) {
			continue
		}
		val := types.CompareBinaryJSON(buf0.GetJSON(i), buf1.GetJSON(i))
		i64s[i] = boolToInt64(val != 0)
	}
	return nil
}

func (b *builtinNEJSONSig) vectorized() bool {
	return true
}

func (b *builtinNullEQRealSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalReal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalReal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Float64s()
	arg1 := buf1.Float64s()
	result.ResizeInt64(n, false)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		isNull0 := buf0.IsNull(i)
		isNull1 := buf1.IsNull(i)
		switch {
		case isNull0 && isNull1:
			i64s[i] = 1
		case isNull0 != isNull1:
			i64s[i] = 0
		case cmp.Compare(arg0[i], arg1[i]) == 0:
			i64s[i] = 1
		}
	}
	return nil
}

func (b *builtinNullEQRealSig) vectorized() bool {
	return true
}

func (b *builtinNullEQDecimalSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDecimal(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDecimal(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Decimals()
	arg1 := buf1.Decimals()
	result.ResizeInt64(n, false)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		isNull0 := buf0.IsNull(i)
		isNull1 := buf1.IsNull(i)
		switch {
		case isNull0 && isNull1:
			i64s[i] = 1
		case isNull0 != isNull1:
			i64s[i] = 0
		case arg0[i].Compare(&arg1[i]) == 0:
			i64s[i] = 1
		}
	}
	return nil
}

func (b *builtinNullEQDecimalSig) vectorized() bool {
	return true
}

func (b *builtinNullEQStringSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalString(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalString(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		isNull0 := buf0.IsNull(i)
		isNull1 := buf1.IsNull(i)
		switch {
		case isNull0 && isNull1:
			i64s[i] = 1
		case isNull0 != isNull1:
			i64s[i] = 0
		case types.CompareString(buf0.GetString(i), buf1.GetString(i), b.collation) == 0:
			i64s[i] = 1
		}
	}
	return nil
}

func (b *builtinNullEQStringSig) vectorized() bool {
	return true
}

func (b *builtinNullEQTimeSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalTime(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalTime(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.Times()
	arg1 := buf1.Times()
	result.ResizeInt64(n, false)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		isNull0 := buf0.IsNull(i)
		isNull1 := buf1.IsNull(i)
		switch {
		case isNull0 && isNull1:
			i64s[i] = 1
		case isNull0 != isNull1:
			i64s[i] = 0
		case arg0[i].Compare(arg1[i]) == 0:
			i64s[i] = 1
		}
	}
	return nil
}

func (b *builtinNullEQTimeSig) vectorized() bool {
	return true
}

func (b *builtinNullEQDurationSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalDuration(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalDuration(ctx, input, buf1); err != nil {
		return err
	}

	arg0 := buf0.GoDurations()
	arg1 := buf1.GoDurations()
	result.ResizeInt64(n, false)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		isNull0 := buf0.IsNull(i)
		isNull1 := buf1.IsNull(i)
		switch {
		case isNull0 && isNull1:
			i64s[i] = 1
		case isNull0 != isNull1:
			i64s[i] = 0
		case cmp.Compare(arg0[i], arg1[i]) == 0:
			i64s[i] = 1
		}
	}
	return nil
}

func (b *builtinNullEQDurationSig) vectorized() bool {
	return true
}

func (b *builtinNullEQJSONSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	buf0, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf0)
	if err := b.args[0].VecEvalJSON(ctx, input, buf0); err != nil {
		return err
	}
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	if err := b.args[1].VecEvalJSON(ctx, input, buf1); err != nil {
		return err
	}

	result.ResizeInt64(n, false)
	i64s := result.Int64s()
	for i := 0; i < n; i++ {
		isNull0 := buf0.IsNull(i)
		isNull1 := buf1.IsNull(i)
		switch {
		case isNull0 && isNull1:
			i64s[i] = 1
		case isNull0 != isNull1:
			i64s[i] = 0
		case types.CompareBinaryJSON(buf0.GetJSON(i), buf1.GetJSON(i)) == 0:
			i64s[i] = 1
		}
	}
	return nil
}

func (b *builtinNullEQJSONSig) vectorized() bool {
	return true
}

// NOTE: Coalesce just return the first non-null item, but vectorization do each item, which would incur additional errors. If this case happen,
// the vectorization falls back to the scalar execution.
func (b *builtinCoalesceIntSig) fallbackEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()

	x := result.Int64s()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalInt(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinCoalesceIntSig) vecEvalInt(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeInt64(n, true)
	i64s := result.Int64s()
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	for j := 0; j < len(b.args); j++ {
		err := b.args[j].VecEvalInt(ctx, input, buf1)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalInt(ctx, input, result)
		}
		args := buf1.Int64s()
		for i := 0; i < n; i++ {
			if !buf1.IsNull(i) && result.IsNull(i) {
				i64s[i] = args[i]
				result.SetNull(i, false)
			}
		}
	}
	return nil
}

func (b *builtinCoalesceIntSig) vectorized() bool {
	return true
}

// NOTE: Coalesce just return the first non-null item, but vectorization do each item, which would incur additional errors. If this case happen,
// the vectorization falls back to the scalar execution.
func (b *builtinCoalesceRealSig) fallbackEvalReal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()

	x := result.Float64s()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalReal(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinCoalesceRealSig) vecEvalReal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeFloat64(n, true)
	i64s := result.Float64s()
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	for j := 0; j < len(b.args); j++ {
		err := b.args[j].VecEvalReal(ctx, input, buf1)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalReal(ctx, input, result)
		}
		args := buf1.Float64s()
		for i := 0; i < n; i++ {
			if !buf1.IsNull(i) && result.IsNull(i) {
				i64s[i] = args[i]
				result.SetNull(i, false)
			}
		}
	}
	return nil
}

func (b *builtinCoalesceRealSig) vectorized() bool {
	return true
}

// NOTE: Coalesce just return the first non-null item, but vectorization do each item, which would incur additional errors. If this case happen,
// the vectorization falls back to the scalar execution.
func (b *builtinCoalesceDecimalSig) fallbackEvalDecimal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()

	x := result.Decimals()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalDecimal(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = *res

	}
	return nil
}

func (b *builtinCoalesceDecimalSig) vecEvalDecimal(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeDecimal(n, true)
	i64s := result.Decimals()
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	for j := 0; j < len(b.args); j++ {
		err := b.args[j].VecEvalDecimal(ctx, input, buf1)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalDecimal(ctx, input, result)
		}
		args := buf1.Decimals()
		for i := 0; i < n; i++ {
			if !buf1.IsNull(i) && result.IsNull(i) {
				i64s[i] = args[i]
				result.SetNull(i, false)
			}
		}
	}
	return nil
}

func (b *builtinCoalesceDecimalSig) vectorized() bool {
	return true
}

// NOTE: Coalesce just return the first non-null item, but vectorization do each item, which would incur additional errors. If this case happen,
// the vectorization falls back to the scalar execution.
func (b *builtinCoalesceStringSig) fallbackEvalString(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()

	result.ReserveString(n)
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalString(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		if isNull {
			result.AppendNull()
			continue
		}
		result.AppendString(res)
	}
	return nil
}

func (b *builtinCoalesceStringSig) vecEvalString(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	argLen := len(b.args)

	bufs := make([]*chunk.Column, argLen)
	beforeWarns := warningCount(ctx)
	for i := 0; i < argLen; i++ {
		buf, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(buf)
		err = b.args[i].VecEvalString(ctx, input, buf)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalString(ctx, input, result)
		}
		bufs[i] = buf
	}
	result.ReserveString(n)

	for i := 0; i < n; i++ {
		for j := 0; j < argLen; j++ {
			if !bufs[j].IsNull(i) {
				result.AppendString(bufs[j].GetString(i))
				break
			}
			if j == argLen-1 && bufs[j].IsNull(i) {
				result.AppendNull()
			}
		}
	}
	return nil
}

func (b *builtinCoalesceStringSig) vectorized() bool {
	return true
}

// NOTE: Coalesce just return the first non-null item, but vectorization do each item, which would incur additional errors. If this case happen,
// the vectorization falls back to the scalar execution.
func (b *builtinCoalesceTimeSig) fallbackEvalTime(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()

	x := result.Times()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalTime(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res

	}
	return nil
}

func (b *builtinCoalesceTimeSig) vecEvalTime(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeTime(n, true)
	i64s := result.Times()
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	for j := 0; j < len(b.args); j++ {
		err := b.args[j].VecEvalTime(ctx, input, buf1)
		fsp := b.tp.GetDecimal()
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalTime(ctx, input, result)
		}
		args := buf1.Times()
		for i := 0; i < n; i++ {
			if !buf1.IsNull(i) && result.IsNull(i) {
				i64s[i] = args[i]
				i64s[i].SetFsp(fsp)
				result.SetNull(i, false)
			}
		}
	}
	return nil
}

func (b *builtinCoalesceTimeSig) vectorized() bool {
	return true
}

// NOTE: Coalesce just return the first non-null item, but vectorization do each item, which would incur additional errors. If this case happen,
// the vectorization falls back to the scalar execution.
func (b *builtinCoalesceDurationSig) fallbackEvalDuration(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()

	x := result.GoDurations()
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalDuration(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		result.SetNull(i, isNull)
		if isNull {
			continue
		}

		x[i] = res.Duration

	}
	return nil
}

func (b *builtinCoalesceDurationSig) vecEvalDuration(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	result.ResizeGoDuration(n, true)
	i64s := result.GoDurations()
	buf1, err := b.bufAllocator.get()
	if err != nil {
		return err
	}
	defer b.bufAllocator.put(buf1)
	beforeWarns := warningCount(ctx)
	for j := 0; j < len(b.args); j++ {
		err := b.args[j].VecEvalDuration(ctx, input, buf1)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalDuration(ctx, input, result)
		}
		args := buf1.GoDurations()
		for i := 0; i < n; i++ {
			if !buf1.IsNull(i) && result.IsNull(i) {
				i64s[i] = args[i]
				result.SetNull(i, false)
			}
		}
	}
	return nil
}

func (b *builtinCoalesceDurationSig) vectorized() bool {
	return true
}

// NOTE: Coalesce just return the first non-null item, but vectorization do each item, which would incur additional errors. If this case happen,
// the vectorization falls back to the scalar execution.
func (b *builtinCoalesceJSONSig) fallbackEvalJSON(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()

	result.ReserveJSON(n)
	for i := 0; i < n; i++ {
		res, isNull, err := b.evalJSON(ctx, input.GetRow(i))
		if err != nil {
			return err
		}
		if isNull {
			result.AppendNull()
			continue
		}
		result.AppendJSON(res)
	}
	return nil
}

func (b *builtinCoalesceJSONSig) vecEvalJSON(ctx EvalContext, input *chunk.Chunk, result *chunk.Column) error {
	n := input.NumRows()
	argLen := len(b.args)

	bufs := make([]*chunk.Column, argLen)
	beforeWarns := warningCount(ctx)
	for i := 0; i < argLen; i++ {
		buf, err := b.bufAllocator.get()
		if err != nil {
			return err
		}
		defer b.bufAllocator.put(buf)
		err = b.args[i].VecEvalJSON(ctx, input, buf)
		afterWarns := warningCount(ctx)
		if err != nil || afterWarns > beforeWarns {
			if afterWarns > beforeWarns {
				truncateWarnings(ctx, beforeWarns)
			}
			return b.fallbackEvalJSON(ctx, input, result)
		}
		bufs[i] = buf
	}
	result.ReserveJSON(n)

	for i := 0; i < n; i++ {
		for j := 0; j < argLen; j++ {
			if !bufs[j].IsNull(i) {
				result.AppendJSON(bufs[j].GetJSON(i))
				break
			}
			if j == argLen-1 && bufs[j].IsNull(i) {
				result.AppendNull()
			}
		}
	}
	return nil
}

func (b *builtinCoalesceJSONSig) vectorized() bool {
	return true
}
