CREATE TABLE multi_indexes (
    c1 bigint PRIMARY KEY CLUSTERED,
    c2 varchar(255) NOT NULL UNIQUE KEY,
    c3 varchar(255) NOT NULL,
    c4 varchar(255) NOT NULL,
    c5 varchar(255) NOT NULL,
    c6 varchar(255) NOT NULL,
    c7 varchar(255) NOT NULL,
    c8 varchar(255) NOT NULL,
    c9 varchar(255) NOT NULL,
    c10 varchar(255) NOT NULL,
    c11 varchar(255) NOT NULL,
    INDEX idx_c2 (c2) COMMENT 'single column index',
    INDEX idx_c2_c3(c2, c3) COMMENT 'multiple column index',
    UNIQUE KEY uniq_c4 (c4) COMMENT 'single column unique key',
    UNIQUE KEY uniq_c4_c5 (c4, c5) COMMENT 'multiple column unique key',
    INDEX idx_c6 (c6 ASC)  COMMENT 'single column index with asc order',
    INDEX idx_c7 (c7 DESC) COMMENT 'single column index with desc order',
    INDEX idx_c6_c7 (c6 ASC, c7 DESC) COMMENT 'multiple column index with asc and desc order',
    INDEX idx_c8 (c8) VISIBLE COMMENT 'single column index with visible',
    INDEX idx_c9 (c9) INVISIBLE COMMENT 'single column index with invisible',
    INDEX idx_lower_c10 ((lower(c10))) COMMENT 'single column index with function',
    INDEX idx_prefix_c11 (c11(3)) COMMENT 'single column index with prefix'
);
