// Copyright 2024 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//go:build !intest

package printexpression_test

import (
	"testing"

	"github.com/pingcap/tidb/build/linter/printexpression"
	"golang.org/x/tools/go/analysis/analysistest"
)

// TODO: investigate the CI environment and check how to run this test in CI.
// The CI environment doesn't have `go` executable in $PATH.

func Test(t *testing.T) {
	testdata := analysistest.TestData()
	pkgs := []string{"t", "github.com/pingcap/tidb/pkg/expression"}
	analysistest.Run(t, testdata, printexpression.Analyzer, pkgs...)
}
