// Copyright 2023 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package build

import (
	_ "embed"
	"encoding/json"
)

//go:embed nogo_config.json
var configFile []byte

// NogoConfig is the nogo config file
var NogoConfig NogoConfigFormat

// NogoConfigFormat is the format of the nogo config file
type NogoConfigFormat map[string]AnalysisConfig

// AnalysisConfig represents the config of an analysis pass
type AnalysisConfig struct {
	ExcludeFiles map[string]string `json:"exclude_files"`
	OnlyFiles    map[string]string `json:"only_files"`
}

func init() {
	err := json.Unmarshal(configFile, &NogoConfig)
	if err != nil {
		panic("fail to parse nogo_config.json")
	}
}
