/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnetplusplus;

import edu.mit.jwi.item.IPointer;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class WordNetPlusPlusPointer
implements IPointer,
Serializable {
    private static final long serialVersionUID = -8065288275131372908L;
    public static final WordNetPlusPlusPointer SEMANTICALLY_RELATED = new WordNetPlusPlusPointer("r", "Semantically related form");
    public static final WordNetPlusPlusPointer GLOSS_MONOSEMOUS = new WordNetPlusPlusPointer("gmono", "Gloss related form (monosemous)");
    public static final WordNetPlusPlusPointer GLOSS_DISAMBIGUATED = new WordNetPlusPlusPointer("gdis", "Gloss related form (disambiguated)");
    public static final WordNetPlusPlusPointer ALSO_SEE = new WordNetPlusPlusPointer("^", "Also See");
    public static final WordNetPlusPlusPointer ANTONYM = new WordNetPlusPlusPointer("!", "Antonym");
    public static final WordNetPlusPlusPointer ATTRIBUTE = new WordNetPlusPlusPointer("=", "Attribute");
    public static final WordNetPlusPlusPointer CAUSE = new WordNetPlusPlusPointer(">", "Cause");
    public static final WordNetPlusPlusPointer DERIVATIONALLY_RELATED = new WordNetPlusPlusPointer("+", "Derivationally related form");
    public static final WordNetPlusPlusPointer ENTAILMENT = new WordNetPlusPlusPointer("*", "Entailment");
    public static final WordNetPlusPlusPointer HYPERNYM = new WordNetPlusPlusPointer("@", "Hypernym");
    public static final WordNetPlusPlusPointer HYPERNYM_INSTANCE = new WordNetPlusPlusPointer("@i", "Instance hypernym");
    public static final WordNetPlusPlusPointer HYPONYM = new WordNetPlusPlusPointer("~", "Hyponym");
    public static final WordNetPlusPlusPointer HYPONYM_INSTANCE = new WordNetPlusPlusPointer("~i", "Instance hyponym");
    public static final WordNetPlusPlusPointer HOLONYM_MEMBER = new WordNetPlusPlusPointer("#m", "Member holonym");
    public static final WordNetPlusPlusPointer HOLONYM_SUBSTANCE = new WordNetPlusPlusPointer("#s", "Substance holonym");
    public static final WordNetPlusPlusPointer HOLONYM_PART = new WordNetPlusPlusPointer("#p", "Part holonym");
    public static final WordNetPlusPlusPointer MERONYM_MEMBER = new WordNetPlusPlusPointer("%m", "Member meronym");
    public static final WordNetPlusPlusPointer MERONYM_SUBSTANCE = new WordNetPlusPlusPointer("%s", "Substance meronym");
    public static final WordNetPlusPlusPointer MERONYM_PART = new WordNetPlusPlusPointer("%p", "Part meronym");
    public static final WordNetPlusPlusPointer PARTICIPLE = new WordNetPlusPlusPointer("<", "Participle");
    public static final WordNetPlusPlusPointer PERTAINYM = new WordNetPlusPlusPointer("\\", "Pertainym (pertains to nouns)");
    public static final WordNetPlusPlusPointer REGION = new WordNetPlusPlusPointer(";r", "Domain of synset - REGION");
    public static final WordNetPlusPlusPointer REGION_MEMBER = new WordNetPlusPlusPointer("-r", "Member of this domain - REGION");
    public static final WordNetPlusPlusPointer SIMILAR_TO = new WordNetPlusPlusPointer("&", "Similar To");
    public static final WordNetPlusPlusPointer TOPIC = new WordNetPlusPlusPointer(";c", "Domain of synset - TOPIC");
    public static final WordNetPlusPlusPointer TOPIC_MEMBER = new WordNetPlusPlusPointer("-c", "Member of this domain - TOPIC");
    public static final WordNetPlusPlusPointer USAGE = new WordNetPlusPlusPointer(";u", "Domain of synset - USAGE");
    public static final WordNetPlusPlusPointer USAGE_MEMBER = new WordNetPlusPlusPointer("-u", "Member of this domain - USAGE");
    public static final WordNetPlusPlusPointer VERB_GROUP = new WordNetPlusPlusPointer("$", "Verb Group");
    private final String fSymbol;
    private final String fName;
    private static final Map<String, WordNetPlusPlusPointer> pointerMap;
    private static final Set<WordNetPlusPlusPointer> pointerSet;

    static {
        Field[] fields = WordNetPlusPlusPointer.class.getFields();
        ArrayList<Field> instanceFields = new ArrayList<Field>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getGenericType() == WordNetPlusPlusPointer.class) {
                instanceFields.add(field);
            }
            ++n2;
        }
        LinkedHashSet<WordNetPlusPlusPointer> hiddenSet = new LinkedHashSet<WordNetPlusPlusPointer>(instanceFields.size());
        LinkedHashMap<String, WordNetPlusPlusPointer> hiddenMap = new LinkedHashMap<String, WordNetPlusPlusPointer>(instanceFields.size() - 1);
        for (Field field : instanceFields) {
            try {
                WordNetPlusPlusPointer ptr = (WordNetPlusPlusPointer)field.get(null);
                if (ptr == null) continue;
                hiddenSet.add(ptr);
                hiddenMap.put(ptr.getSymbol(), ptr);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        pointerSet = Collections.unmodifiableSet(hiddenSet);
        pointerMap = Collections.unmodifiableMap(hiddenMap);
    }

    public WordNetPlusPlusPointer(String symbol, String name) {
        this.fSymbol = symbol;
        this.fName = name;
    }

    public String getSymbol() {
        return this.fSymbol;
    }

    public String getName() {
        return this.fName;
    }

    public String toString() {
        return this.fName.toLowerCase().replace(' ', '_').replace(",", "");
    }

    public boolean equals(Object obj) {
        return this.fName.equals(((WordNetPlusPlusPointer)obj).fName) && this.fSymbol.equals(((WordNetPlusPlusPointer)obj).fSymbol);
    }

    public int hashCode() {
        return this.fName.hashCode() + this.fSymbol.hashCode();
    }

    public static Collection<WordNetPlusPlusPointer> values() {
        return pointerSet;
    }

    public static WordNetPlusPlusPointer getPointerType(String symbol) {
        WordNetPlusPlusPointer pointerType = pointerMap.get(symbol);
        return pointerType;
    }
}

