/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnetplusplus;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.ScoredItem;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WordNetPlusPlus {
    private static final Log log = LogFactory.getLog(WordNetPlusPlus.class);
    private final Multimap<String, ScoredItem<String>> addedRelations = new HashMultimap();
    private static WordNetPlusPlus instance;

    private WordNetPlusPlus() {
        try {
            this.load();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load: " + e);
        }
    }

    public static synchronized WordNetPlusPlus getInstance() {
        if (instance == null) {
            instance = new WordNetPlusPlus();
        }
        return instance;
    }

    private void load() throws IOException {
        Configuration config = Configuration.getInstance();
        List<String> dataSetFileNames = config.getWordNetPlusPlusSourceFiles();
        for (String dSFileName : dataSetFileNames) {
            log.info((Object)("LOADING WN++ FROM: " + dSFileName + "..."));
            BufferedReader br = new BufferedReader(new FileReader(dSFileName));
            while (br.ready()) {
                String line = br.readLine();
                String[] split = line.split("\t");
                if (split.length <= 1) continue;
                String key = split[0];
                int value = 1;
                while (value < split.length) {
                    String link = split[value];
                    int index = link.indexOf(":");
                    String offset = link.substring(0, index);
                    Double score = Double.valueOf(link.substring(index + 1));
                    this.addedRelations.put((Object)key, new ScoredItem<String>(offset, score));
                    ++value;
                }
            }
            br.close();
        }
        log.info((Object)("ADDED " + this.addedRelations.size() + " NEW RELATIONS, DONE!"));
    }

    public Collection<ScoredItem<String>> getRelatedSynsets(String s) {
        HashSet<ScoredItem<String>> related = new HashSet<ScoredItem<String>>();
        related.addAll(this.addedRelations.get((Object)s));
        return related;
    }

    public static void main(String[] args) {
        try {
            WordNetPlusPlus.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

