/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet.morph;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.wordnet.morph.MySimpleStemmer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class MyWordnetStemmer
extends MySimpleStemmer {
    IDictionary fDictionary;

    public MyWordnetStemmer(IDictionary dictionary) {
        assert (dictionary != null);
        this.fDictionary = dictionary;
    }

    public List<String> findStems(String word, POS pos) {
        if (pos == null) {
            return this.findStems(word);
        }
        word = this.normalize(word);
        TreeSet<String> result = new TreeSet<String>();
        IExceptionEntry entry = this.fDictionary.getExceptionEntry(word, pos);
        if (entry != null) {
            for (String rootForm : entry.getRootForms()) {
                result.add(rootForm);
            }
        }
        if (this.fDictionary.getIndexWord(word, pos) != null) {
            result.add(word);
        }
        if (result.isEmpty()) {
            List possibles = super.findStems(word, pos);
            for (String possible : possibles) {
                if (this.fDictionary.getIndexWord(possible, pos) == null) continue;
                if (result == null) {
                    result = new TreeSet();
                }
                result.add(possible);
            }
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }

    public List<String> findStems(String word) {
        TreeSet<String> result = new TreeSet<String>();
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            result.addAll(this.findStems(word, pos));
            ++n2;
        }
        return result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
    }
}

