/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet.data;

import com.google.common.collect.Multimap;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.util.Dataset;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.util.Timer;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetGlossPointer;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetGlosses;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class WordNetWeights
extends Dataset {
    private static final String SEPARATOR = ":";
    private Map<String, Double> offsetPair2score;

    protected WordNetWeights(String ... files) {
        super(files);
    }

    @Override
    protected void load(String file) {
        if (!new File(file).exists()) {
            try {
                this.create(file);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot init: " + e);
            }
        }
        super.load(file);
    }

    @Override
    protected void init() {
        if (this.offsetPair2score == null) {
            this.offsetPair2score = new HashMap<String, Double>();
        }
    }

    public double getWeight(ISynset synset1, ISynset synset2) {
        return this.getWeight(WordNet.synsetToString(synset1), WordNet.synsetToString(synset2));
    }

    public double getWeight(String offset1, String offset2) {
        String key = WordNetWeights.createKey(offset1, offset2);
        return this.offsetPair2score.get(key);
    }

    @Override
    protected void put(String line) {
        String[] split = line.split("\t+");
        if (split.length != 4) {
            throw new RuntimeException("Invalid input format: expected \"offset_1:offset_2 <tab> count <tab> info\", got " + Arrays.asList(line) + " instead!\n");
        }
        String key = split[0];
        Double score = Double.valueOf(split[1]);
        this.offsetPair2score.put(key, score);
    }

    public void create(String dataFile) throws SQLException, IOException {
        int counter = 0;
        Timer timer = new Timer();
        WordNet wn = WordNet.getInstance();
        WordNetGlosses wnGlosses = WordNetGlosses.getInstance();
        NumberFormat nf = DecimalFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(10);
        nf.setMinimumFractionDigits(10);
        FileWriter writer = new FileWriter(dataFile);
        HashSet<ISynset> synsetsDone = new HashSet<ISynset>();
        HashSet<String> synsetPairsDone = new HashSet<String>();
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            Iterator<IIndexWord> i = wn.getSenseIterator(pos);
            while (i.hasNext()) {
                IIndexWord iw = i.next();
                for (IWordID wordID : iw.getWordIDs()) {
                    IWord word = wn.getSenseFromID(wordID);
                    ISynset synset = word.getSynset();
                    if (synsetsDone.contains(synset)) continue;
                    synsetsDone.add(synset);
                    String synsetOffset = WordNet.synsetToString(synset);
                    String synsetDescription = wn.synsetToSenseString(synset);
                    Set<String> synsetBow = this.getSynsetBOW(synset);
                    double synsetScore = this.weightSynsetBow(synsetBow);
                    Multimap<IPointer, ISynset> related = wn.getRelatedSynsetsMap(synset, true);
                    for (String glossOffset : wnGlosses.getMonosemousGlossWordsOffsets(synset)) {
                        related.put((Object)WordNetGlossPointer.GLOSS_MONOSEMOUS, (Object)wn.getSynsetFromOffset(glossOffset));
                    }
                    for (String glossOffset : wnGlosses.getDisambiguatedGlossWordsOffsets(synset)) {
                        related.put((Object)WordNetGlossPointer.GLOSS_DISAMBIGUATED, (Object)wn.getSynsetFromOffset(glossOffset));
                    }
                    for (IPointer relation : related.keySet()) {
                        for (ISynset relatedSynset : related.get((Object)relation)) {
                            String relatedOffset = WordNet.synsetToString(relatedSynset);
                            String relatedDescription = wn.synsetToSenseString(relatedSynset);
                            String synsetPair = WordNetWeights.createKey(synsetOffset, relatedOffset);
                            if (synsetPairsDone.contains(synsetPair)) continue;
                            synsetPairsDone.add(synsetPair);
                            Set<String> relatedBow = this.getSynsetBOW(relatedSynset);
                            double relatedScore = this.weightSynsetBow(relatedBow);
                            double jointScore = this.weightSynsetBows(synsetBow, relatedBow);
                            double denominator = synsetScore + relatedScore;
                            double dice = 0.0;
                            if (denominator != 0.0) {
                                dice = 2.0 * jointScore / denominator;
                            }
                            writer.write(String.valueOf(synsetPair) + "\t" + nf.format(dice) + "\t" + relation.getSymbol() + "\t" + synsetDescription + SEPARATOR + relatedDescription + "\n");
                        }
                        if (++counter % 1000 != 0) continue;
                        timer.tick("TO PROCESS " + counter + " WORDNET SYNSETS");
                    }
                }
            }
            ++n2;
        }
        writer.close();
    }

    protected abstract Set<String> getSynsetBOW(ISynset var1);

    protected abstract double weightSynsetBow(Set<String> var1);

    protected abstract double weightSynsetBows(Set<String> var1, Set<String> var2);

    private static String createKey(String offset1, String offset2) {
        if (offset1.compareTo(offset2) > 0) {
            return Strings.join(new String[]{offset1, offset2}, SEPARATOR);
        }
        return Strings.join(new String[]{offset2, offset1}, SEPARATOR);
    }

    protected void test() {
        WordNet wn = WordNet.getInstance();
        ISynset auto = wn.getSynsets("auto").get(0);
        ISynset vehicle = wn.getSynsets("motor vehicle").get(0);
        System.out.println("WEIGHT BETWEEN " + wn.synsetToSenseString(auto) + " AND " + wn.synsetToSenseString(vehicle) + ": " + this.getWeight(auto, vehicle));
    }
}

