/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Dataset;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class WordNetGlosses
extends Dataset {
    private Multimap<String, String> targetToPointing;
    private Multimap<String, String> targetToPointingExamples;
    private static WordNetGlosses instance;

    private WordNetGlosses() {
        super(Configuration.getInstance().getWordNetGlosses());
    }

    public static synchronized WordNetGlosses getInstance() {
        if (instance == null) {
            instance = new WordNetGlosses();
        }
        return instance;
    }

    @Override
    protected void init() {
        if (this.targetToPointing == null) {
            this.targetToPointing = new HashMultimap();
        }
        if (this.targetToPointingExamples == null) {
            this.targetToPointingExamples = new HashMultimap();
        }
    }

    @Override
    protected void put(String line) {
        String[] split = line.split("\\|");
        if (split.length > 1) {
            String[] senses;
            String target = split[0];
            String[] stringArray = senses = split[1].toLowerCase().split(",");
            int n = senses.length;
            int n2 = 0;
            while (n2 < n) {
                String sense = stringArray[n2];
                this.targetToPointing.put((Object)target, (Object)sense);
                ++n2;
            }
            if (split.length > 2) {
                String[] exampleSenses;
                String[] stringArray2 = exampleSenses = split[2].toLowerCase().split(",");
                int n3 = exampleSenses.length;
                n = 0;
                while (n < n3) {
                    String exampleSense = stringArray2[n];
                    this.targetToPointingExamples.put((Object)target, (Object)exampleSense);
                    ++n;
                }
            }
        }
    }

    public Collection<String> getGlossWords(IWord sense) {
        return this.getGlossWords(sense.getSynset());
    }

    public Collection<String> getGlossWords(ISynset synset) {
        return this.getGlossWords(synset, null);
    }

    public Collection<String> getGlossWords(ISynset synset, POS onlyPOS) {
        return WordNetGlosses.getGlossWords(synset, onlyPOS, this.targetToPointing);
    }

    public Collection<String> getExampleWords(IWord sense) {
        return this.getExampleWords(sense.getSynset());
    }

    public Collection<String> getExampleWords(ISynset synset) {
        return this.getExampleWords(synset, null);
    }

    public Collection<String> getExampleWords(ISynset synset, POS onlyPOS) {
        return WordNetGlosses.getGlossWords(synset, onlyPOS, this.targetToPointingExamples);
    }

    private static Collection<String> getGlossWords(ISynset synset, POS onlyPOS, Multimap<String, String> glossMap) {
        HashSet<String> words = new HashSet<String>();
        for (String posWord : glossMap.get((Object)WordNetGlosses.getOffset(synset))) {
            int idx = posWord.indexOf(35);
            if (idx != -1) {
                if (onlyPOS != null && posWord.charAt(idx + 1) != onlyPOS.getTag()) continue;
                posWord = posWord.substring(0, idx);
            }
            words.add(posWord);
        }
        return words;
    }

    public Collection<IWord> getMonosemousGlossWords(ISynset synset) {
        WordNet wn = WordNet.getInstance();
        HashSet<IWord> senses = new HashSet<IWord>();
        for (String glossWord : this.getPOSTaggedGlossWords(synset)) {
            POS pos;
            String[] lemmaPOS = glossWord.split("#");
            List<IWord> iwords = wn.getSenses(lemmaPOS[0], pos = WordNet.getPOSfromChar(lemmaPOS[1]));
            if (iwords.size() != 1) continue;
            senses.add(iwords.get(0));
        }
        return senses;
    }

    public Collection<String> getMonosemousGlossWordsOffsets(ISynset synset) {
        HashSet<String> offsets = new HashSet<String>();
        Collection<IWord> monosemousGlossWords = this.getMonosemousGlossWords(synset);
        for (IWord monosemousGlossWord : monosemousGlossWords) {
            offsets.add(WordNet.synsetToString(monosemousGlossWord.getSynset()));
        }
        return offsets;
    }

    public Collection<IWord> getDisambiguatedGlossWords(IWord sense) {
        return this.getDisambiguatedGlossWords(sense.getSynset());
    }

    public Collection<IWord> getDisambiguatedGlossWords(ISynset synset) {
        return this.getDisambiguatedGlossWords(synset, null);
    }

    public Collection<IWord> getDisambiguatedGlossWords(ISynset synset, POS onlyPOS) {
        WordNet wn = WordNet.getInstance();
        HashSet<IWord> senses = new HashSet<IWord>();
        for (String posWord : this.targetToPointing.get((Object)WordNetGlosses.getOffset(synset))) {
            int senseNumber;
            POS pos;
            IWord sense;
            String[] split = posWord.split("#");
            if (split.length <= 2) continue;
            char posChar = split[1].charAt(0);
            if (onlyPOS != null && posChar != onlyPOS.getTag() || (sense = wn.getSense(split[0], pos = WordNet.getPOSfromChar(posChar), senseNumber = Integer.parseInt(split[2]))) == null) continue;
            senses.add(sense);
        }
        return senses;
    }

    public Collection<String> getDisambiguatedGlossWordsOffsets(ISynset synset) {
        HashSet<String> offsets = new HashSet<String>();
        Collection<IWord> disambiguatedGlossWords = this.getDisambiguatedGlossWords(synset);
        for (IWord disambiguatedGlossWord : disambiguatedGlossWords) {
            offsets.add(WordNet.synsetToString(disambiguatedGlossWord.getSynset()));
        }
        return offsets;
    }

    public Collection<String> getPOSTaggedGlossWords(ISynset synset) {
        return this.targetToPointing.get((Object)WordNetGlosses.getOffset(synset));
    }

    public static String getOffset(IWord sense) {
        return WordNetGlosses.getOffset(sense.getSynset());
    }

    public static String getOffset(ISynset synset) {
        StringBuffer sb = new StringBuffer();
        char posChar = WordNet.getCharFromPOS(synset);
        sb.append(posChar);
        String offset = "" + synset.getOffset();
        int k = 8;
        while (k > offset.length()) {
            sb.append("0");
            --k;
        }
        sb.append(offset);
        return sb.toString();
    }
}

