/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet.data;

import edu.mit.jwi.item.IPointer;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class WordNetGlossPointer
implements IPointer,
Serializable {
    private static final long serialVersionUID = -8065288275131372908L;
    public static final WordNetGlossPointer GLOSS_MONOSEMOUS = new WordNetGlossPointer("gmono", "Gloss related form (monosemous)");
    public static final WordNetGlossPointer GLOSS_DISAMBIGUATED = new WordNetGlossPointer("gdis", "Gloss related form (disambiguated)");
    private final String fSymbol;
    private final String fName;
    private static final Map<String, WordNetGlossPointer> pointerMap;
    private static final Set<WordNetGlossPointer> pointerSet;

    static {
        Field[] fields = WordNetGlossPointer.class.getFields();
        ArrayList<Field> instanceFields = new ArrayList<Field>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getGenericType() == WordNetGlossPointer.class) {
                instanceFields.add(field);
            }
            ++n2;
        }
        LinkedHashSet<WordNetGlossPointer> hiddenSet = new LinkedHashSet<WordNetGlossPointer>(instanceFields.size());
        LinkedHashMap<String, WordNetGlossPointer> hiddenMap = new LinkedHashMap<String, WordNetGlossPointer>(instanceFields.size() - 1);
        for (Field field : instanceFields) {
            try {
                WordNetGlossPointer ptr = (WordNetGlossPointer)field.get(null);
                if (ptr == null) continue;
                hiddenSet.add(ptr);
                hiddenMap.put(ptr.getSymbol(), ptr);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        pointerSet = Collections.unmodifiableSet(hiddenSet);
        pointerMap = Collections.unmodifiableMap(hiddenMap);
    }

    public WordNetGlossPointer(String symbol, String name) {
        this.fSymbol = symbol;
        this.fName = name;
    }

    public String getSymbol() {
        return this.fSymbol;
    }

    public String getName() {
        return this.fName;
    }

    public String toString() {
        return this.fName.toLowerCase().replace(' ', '_').replace(",", "");
    }

    public boolean equals(Object obj) {
        return this.fName.equals(((WordNetGlossPointer)obj).fName) && this.fSymbol.equals(((WordNetGlossPointer)obj).fSymbol);
    }

    public int hashCode() {
        return this.fName.hashCode() + this.fSymbol.hashCode();
    }

    public static Collection<WordNetGlossPointer> values() {
        return pointerSet;
    }

    public static WordNetGlossPointer getPointerType(String symbol) {
        WordNetGlossPointer pointerType = pointerMap.get(symbol);
        return pointerType;
    }
}

