/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet.data;

import edu.mit.jwi.item.ISynset;
import it.uniroma1.lcl.jlt.util.ScoredItem;
import it.uniroma1.lcl.jlt.util.Stopwords;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetGlosses;
import it.uniroma1.lcl.jlt.wordnetplusplus.WordNetPlusPlus;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SynsetBoW {
    private static final Stopwords STOPWORDS = Stopwords.getInstance();

    public static Set<String> getSynsetBoW(ISynset s) {
        return SynsetBoW.getSynsetBoW(s, SynsetBoWType.EXPANDED_SYNONYMS_GLOSS_WORDS);
    }

    public static Set<String> getSynsetBoW(ISynset s, SynsetBoWType type) {
        WordNet wn = WordNet.getInstance();
        WordNetGlosses wnGlosses = WordNetGlosses.getInstance();
        HashSet<String> bow = new HashSet<String>();
        if (type != SynsetBoWType.GLOSS_WORDS) {
            for (String w : wn.getSynsetWords(s)) {
                bow.add(w.toLowerCase());
            }
        }
        if (type != SynsetBoWType.SYNONYMS) {
            for (String w : wnGlosses.getGlossWords(s)) {
                bow.add(w.toLowerCase());
            }
        }
        if (type == SynsetBoWType.EXPANDED_SYNONYMS_GLOSS_WORDS) {
            for (ISynset r : wn.getRelatedSynsets(s, true)) {
                for (String w : wn.getSynsetWords(r)) {
                    bow.add(w.toLowerCase());
                }
                for (String w : wnGlosses.getGlossWords(r)) {
                    bow.add(w.toLowerCase());
                }
            }
        }
        for (String w : new HashSet(bow)) {
            if (!STOPWORDS.isStopword(w)) continue;
            bow.remove(w);
        }
        return bow;
    }

    public static Set<String> getSynsetBoWPP(ISynset s) {
        return SynsetBoW.getSynsetBoWPP(s, SynsetBoWType.EXPANDED_SYNONYMS_GLOSS_WORDS);
    }

    public static Set<String> getSynsetBoWPP(ISynset s, SynsetBoWType type) {
        WordNet wn = WordNet.getInstance();
        WordNetGlosses wnGlosses = WordNetGlosses.getInstance();
        WordNetPlusPlus wnPlusPlus = WordNetPlusPlus.getInstance();
        HashSet<String> bow = new HashSet<String>();
        if (type != SynsetBoWType.GLOSS_WORDS) {
            for (String w : wn.getSynsetWords(s)) {
                bow.add(w.toLowerCase());
            }
        }
        if (type != SynsetBoWType.SYNONYMS) {
            for (String w : wnGlosses.getGlossWords(s)) {
                bow.add(w.toLowerCase());
            }
        }
        if (type == SynsetBoWType.EXPANDED_SYNONYMS_GLOSS_WORDS) {
            String offset = WordNet.synsetToString(s);
            Collection<ScoredItem<String>> related = wnPlusPlus.getRelatedSynsets(offset);
            Set<ISynset> relatedSyn = wn.getRelatedSynsets(s, true);
            for (ScoredItem<String> rel : related) {
                ISynset newsyn = wn.getSynsetFromOffset(rel.getItem());
                relatedSyn.add(newsyn);
            }
            for (ISynset r : relatedSyn) {
                for (String w : wn.getSynsetWords(r)) {
                    bow.add(w.toLowerCase());
                }
                for (String w : wnGlosses.getGlossWords(r)) {
                    bow.add(w.toLowerCase());
                }
            }
        }
        for (String w : new HashSet(bow)) {
            if (!STOPWORDS.isStopword(w)) continue;
            bow.remove(w);
        }
        return bow;
    }

    public static enum SynsetBoWType {
        SYNONYMS,
        GLOSS_WORDS,
        SYNONYMS_GLOSS_WORDS,
        EXPANDED_SYNONYMS_GLOSS_WORDS;

    }
}

