/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet.data;

import com.google.common.collect.Sets;
import edu.mit.jwi.item.ISynset;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.wordnet.data.SynsetBoW;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetWeightType;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetWeights;
import java.util.Set;

public class GlossOverlapWordNetWeights
extends WordNetWeights {
    private static GlossOverlapWordNetWeights instance;

    private GlossOverlapWordNetWeights() {
        super(Configuration.getInstance().getWordNetWeightFile(WordNetWeightType.GLOSS_OVERLAP));
    }

    public static synchronized GlossOverlapWordNetWeights getInstance() {
        if (instance == null) {
            instance = new GlossOverlapWordNetWeights();
        }
        return instance;
    }

    @Override
    protected Set<String> getSynsetBOW(ISynset synset) {
        return SynsetBoW.getSynsetBoW(synset);
    }

    @Override
    protected double weightSynsetBow(Set<String> bow) {
        return bow.size();
    }

    @Override
    protected double weightSynsetBows(Set<String> bow1, Set<String> bow2) {
        return Sets.intersection(bow1, bow2).size();
    }

    public static void main(String[] args) {
        try {
            GlossOverlapWordNetWeights.getInstance().test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

