/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet.data;

import edu.mit.jwi.item.ISynset;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.collocs.Collocs;
import it.uniroma1.lcl.jlt.collocs.Lexicon;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.wordnet.data.SynsetBoW;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetWeightType;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetWeights;
import java.util.Set;

public class FrequencyWordNetWeights
extends WordNetWeights {
    private static FrequencyWordNetWeights instance;

    public static synchronized FrequencyWordNetWeights getInstance() {
        if (instance == null) {
            instance = new FrequencyWordNetWeights();
        }
        return instance;
    }

    private FrequencyWordNetWeights() {
        super(Configuration.getInstance().getWordNetWeightFile(WordNetWeightType.FREQUENCY));
    }

    @Override
    protected Set<String> getSynsetBOW(ISynset synset) {
        return SynsetBoW.getSynsetBoW(synset, SynsetBoW.SynsetBoWType.SYNONYMS_GLOSS_WORDS);
    }

    @Override
    protected double weightSynsetBow(Set<String> bow) {
        double frequency = 0.0;
        Lexicon webCoLexicon = Lexicon.getInstance(CollocsDB.WEBCO);
        for (String element : bow) {
            frequency += (double)webCoLexicon.getCount(element);
        }
        return frequency;
    }

    @Override
    protected double weightSynsetBows(Set<String> bow1, Set<String> bow2) {
        double cooccurrence = 0.0;
        Collocs webCoCollocs = Collocs.getInstance(CollocsDB.WEBCO);
        for (String w1 : bow1) {
            for (String w2 : bow2) {
                cooccurrence += (double)webCoCollocs.getCount(w1, w2);
            }
        }
        return cooccurrence;
    }

    public static void main(String[] args) {
        try {
            FrequencyWordNetWeights.getInstance().test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

