/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WordNetOffsetIterator
implements Iterator<String> {
    private Iterator<ISynset> currentIterator;
    private final Map<POS, Iterator<ISynset>> iterators = new HashMap<POS, Iterator<ISynset>>();

    public WordNetOffsetIterator() {
        this(WordNet.getInstance(), POS.values());
    }

    public WordNetOffsetIterator(WordNet wn) {
        this(wn, POS.values());
    }

    public WordNetOffsetIterator(WordNet wn, POS ... acceptedPos) {
        POS[] pOSArray = acceptedPos;
        int n = acceptedPos.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            this.iterators.put(pos, wn.getSynsetIterator(pos));
            ++n2;
        }
        if (acceptedPos.length == 0) {
            throw new RuntimeException("Needs at least one valid PoS!");
        }
        this.setNextCurrentIterator();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.currentIterator.hasNext();
        if (!hasNext) {
            this.setNextCurrentIterator();
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public String next() {
        return WordNet.synsetToString(this.currentIterator.next());
    }

    @Override
    public void remove() {
        if (this.currentIterator != null) {
            this.currentIterator.remove();
        }
    }

    private void setNextCurrentIterator() {
        Set<POS> available = this.iterators.keySet();
        if (!available.isEmpty()) {
            POS pos = this.iterators.keySet().iterator().next();
            this.currentIterator = this.iterators.get(pos);
            this.iterators.remove(pos);
        }
    }

    public static void main(String[] args) {
        try {
            int counter = 1;
            System.out.println("TESTING ITERATOR, please wait ...");
            WordNetOffsetIterator iterator = new WordNetOffsetIterator();
            while (iterator.hasNext()) {
                System.out.println("[" + counter + "] LOOKING AT: " + iterator.next());
                ++counter;
            }
            System.out.println("DONE!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

