/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet;

import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import it.uniroma1.lcl.jlt.wordnet.WordNetVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WordNetFrequencies {
    private static final Log log = LogFactory.getLog(WordNetFrequencies.class);
    private IntegerCounter<String> frequencies = new IntegerCounter();
    private Map<String, IntegerCounter<String>> lemmaPosFrequencies = new HashMap<String, IntegerCounter<String>>();
    private static Map<WordNetVersion, WordNetFrequencies> singleton = new HashMap<WordNetVersion, WordNetFrequencies>();

    public static synchronized WordNetFrequencies getInstance() {
        return WordNetFrequencies.getInstance(WordNetVersion.WN_30);
    }

    public static synchronized WordNetFrequencies getInstance(WordNetVersion wnv) {
        if (!singleton.containsKey((Object)wnv)) {
            singleton.put(wnv, new WordNetFrequencies(wnv));
        }
        return singleton.get((Object)wnv);
    }

    private WordNetFrequencies() {
        this(WordNetVersion.WN_30);
    }

    private WordNetFrequencies(WordNetVersion wnv) {
        String wordNetData = String.valueOf(Files.addFileSeparator(Configuration.getInstance().getWordNetData(wnv))) + "cntlist";
        WordNet wn = WordNet.getInstance(wnv);
        int total = 0;
        int notFound = 0;
        try {
            Scanner reader = new Scanner(new File(wordNetData));
            while (reader.hasNextLine()) {
                ++total;
                String line = reader.nextLine();
                String[] split = line.split(" ");
                Integer freq = Integer.parseInt(split[0]);
                IWord sense = wn.getSenseFromSenseKey(split[1]);
                if (sense == null) {
                    log.debug((Object)("Could not find any sense for sensekey=" + split[1]));
                    ++notFound;
                    continue;
                }
                String senseToString = wn.senseToString(sense);
                this.frequencies.count(senseToString, freq);
                String lemmaPos = wn.senseToLemmaPosString(sense);
                IntegerCounter<String> senses = this.lemmaPosFrequencies.get(lemmaPos);
                if (senses == null) {
                    senses = new IntegerCounter();
                    this.lemmaPosFrequencies.put(lemmaPos, senses);
                }
                senses.count(senseToString, freq);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        log.info((Object)(String.valueOf(total) + " total senses frequencies read."));
        log.info((Object)(String.valueOf(notFound) + " senses not found."));
    }

    public int getSenseFrequency(String sense) {
        return (Integer)this.frequencies.get(sense);
    }

    public IntegerCounter<String> getLemmaFrequencies(String lemma, POS pos) {
        String lemmaPos = String.valueOf(lemma) + "#" + pos.getTag();
        return this.lemmaPosFrequencies.get(lemmaPos);
    }

    public static void main(String[] args) {
        WordNetFrequencies wnfrequencies = WordNetFrequencies.getInstance();
        log.info((Object)wnfrequencies.getSenseFrequency("star#n#1"));
        log.info((Object)wnfrequencies.getLemmaFrequencies("star", POS.NOUN).toLineString());
    }
}

