/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import edu.mit.jwi.Dictionary;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.data.parse.SenseKeyParser;
import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Pointer;
import edu.mit.jwi.item.Synset;
import edu.mit.jwi.item.SynsetID;
import edu.mit.jwi.morph.IStemmer;
import edu.mit.jwi.morph.SimpleStemmer;
import edu.mit.jwi.morph.WordnetStemmer;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Sets;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.wordnet.WordNetVersion;
import it.uniroma1.lcl.jlt.wordnet.data.WordNetMappings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WordNet {
    private static final String SENSE_SEPARATOR = "#";
    private final WordNetVersion wnv;
    private IDictionary dictionary;
    private IStemmer simpleStemmer;
    private IStemmer wnStemmer;
    private static Map<WordNetVersion, WordNet> singleton = new HashMap<WordNetVersion, WordNet>();

    public SimpleStemmer getSimpleStemmer() {
        return (SimpleStemmer)this.simpleStemmer;
    }

    public WordnetStemmer getWnStemmer() {
        return (WordnetStemmer)this.wnStemmer;
    }

    private WordNet(WordNetVersion wnv) {
        try {
            String location = Configuration.getInstance().getWordNetData(wnv);
            Dictionary dict = new Dictionary(new URL("file", null, location));
            if (Configuration.getInstance().getWordNetUnlimitedCache()) {
                dict.getCache().setMaximumCapacity(Integer.MAX_VALUE);
            }
            this.dictionary = dict;
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        this.wnv = wnv;
        try {
            this.dictionary.open();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.simpleStemmer = new SimpleStemmer();
        this.wnStemmer = new WordnetStemmer(this.dictionary);
    }

    public static synchronized WordNet getInstance() {
        return WordNet.getInstance(WordNetVersion.WN_30);
    }

    public static synchronized WordNet getInstance(WordNetVersion wnv) {
        if (!singleton.containsKey((Object)wnv)) {
            singleton.put(wnv, new WordNet(wnv));
        }
        return singleton.get((Object)wnv);
    }

    public IDictionary getDictionary() {
        return this.dictionary;
    }

    public Iterator<IIndexWord> getNounSenseIterator() {
        return this.getSenseIterator(POS.NOUN);
    }

    public Iterator<IIndexWord> getSenseIterator(POS pos) {
        return this.dictionary.getIndexWordIterator(pos);
    }

    public Iterator<ISynset> getSynsetIterator(POS pos) {
        return this.dictionary.getSynsetIterator(pos);
    }

    public List<IWord> getSenses(String word) {
        return this.getSenses(word, POS.NOUN);
    }

    public List<IWord> getSenses(String word, POS pos) {
        return this.getSenses(this.getIndexWord(word, pos));
    }

    public List<ISynset> getSynsets(String word) {
        return this.getSynsets(word, POS.NOUN);
    }

    public List<ISynset> getSynsets(String word, POS pos) {
        return this.getSynsets(this.getIndexWord(word, pos));
    }

    public IIndexWord getIndexWord(String word) {
        return this.dictionary.getIndexWord(word, POS.NOUN);
    }

    public IIndexWord getIndexWord(String word, POS pos) {
        return this.dictionary.getIndexWord(word, pos);
    }

    public List<IWord> getSenses(IIndexWord idxWord) {
        ArrayList<IWord> senses = new ArrayList<IWord>();
        if (idxWord != null) {
            for (IWordID senseID : idxWord.getWordIDs()) {
                senses.add(this.dictionary.getWord(senseID));
            }
        }
        return senses;
    }

    public List<ISynset> getSynsets(IIndexWord idxWord) {
        ArrayList<ISynset> synsets = new ArrayList<ISynset>();
        if (idxWord != null) {
            for (IWordID senseID : idxWord.getWordIDs()) {
                synsets.add(this.dictionary.getWord(senseID).getSynset());
            }
        }
        return synsets;
    }

    public ISynset getSynsetFromID(ISynsetID id) {
        return this.dictionary.getSynset(id);
    }

    public boolean synsetContains(ISynset sense, String word) {
        for (IWord w : sense.getWords()) {
            if (!w.getLemma().equals(word)) continue;
            return true;
        }
        return false;
    }

    public IWord getSenseFromSynset(ISynset sense, String word) {
        word = Strings.getLemma(word).toLowerCase();
        for (IWord w : sense.getWords()) {
            if (!w.getLemma().toLowerCase().equals(word)) continue;
            return w;
        }
        return null;
    }

    public boolean isa(Collection<IWord> hypoSenses, Collection<IWord> hyperSenses) {
        for (IWord hypoSense : hypoSenses) {
            for (IWord hyperSense : hyperSenses) {
                if (!this.isa(hypoSense, hyperSense)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isa(IWord hypoSense, Collection<IWord> hyperSenses) {
        for (IWord hyperSense : hyperSenses) {
            if (!this.isa(hypoSense, hyperSense)) continue;
            return true;
        }
        return false;
    }

    public boolean isa(IWord hypoSense, IWord hyperSense) {
        return this.isa(hypoSense.getSynset(), hyperSense.getSynset());
    }

    private boolean isa(ISynset hypoSense, ISynset hyperSense) {
        if (((ISynsetID)hypoSense.getID()).equals(hyperSense.getID())) {
            return true;
        }
        ArrayList hypernymIDs = new ArrayList();
        hypernymIDs.addAll(hypoSense.getRelatedSynsets((IPointer)Pointer.HYPERNYM));
        hypernymIDs.addAll(hypoSense.getRelatedSynsets((IPointer)Pointer.HYPERNYM_INSTANCE));
        if (hypernymIDs.isEmpty()) {
            return false;
        }
        for (ISynsetID hypernymID : hypernymIDs) {
            if (!this.isa(this.dictionary.getSynset(hypernymID), hyperSense)) continue;
            return true;
        }
        return false;
    }

    public boolean isaDirect(IWord hypoSense, IWord hyperSense) {
        return this.isaDirect(hypoSense.getSynset(), hyperSense.getSynset());
    }

    public boolean isaDirect(ISynset hypoSense, ISynset hyperSense) {
        ArrayList hypernymIDs = new ArrayList();
        hypernymIDs.addAll(hypoSense.getRelatedSynsets((IPointer)Pointer.HYPERNYM));
        hypernymIDs.addAll(hypoSense.getRelatedSynsets((IPointer)Pointer.HYPERNYM_INSTANCE));
        return hypernymIDs.contains(hyperSense.getID());
    }

    public List<ISynset> dfs(Collection<ISynset> srcSenses, Collection<ISynset> targetSenses) {
        for (ISynset srcSense : srcSenses) {
            for (ISynset targetSense : targetSenses) {
                List<ISynset> path = this.dfs(srcSense, targetSense);
                if (path.isEmpty()) continue;
                return path;
            }
        }
        return new ArrayList<ISynset>();
    }

    public List<ISynset> dfs(ISynset srcSense, ISynset targetSense) {
        return this.dfs(srcSense, targetSense, 5);
    }

    public List<ISynset> dfs(ISynset srcSense, ISynset targetSense, int maxDepth) {
        ArrayList<ISynset> path = new ArrayList<ISynset>();
        path.add(srcSense);
        return this.dfs(srcSense, targetSense, 0, new HashSet<ISynset>(), path, maxDepth);
    }

    private List<ISynset> dfs(ISynset srcSense, ISynset targetSense, int currentDepth, Set<ISynset> done, List<ISynset> path, int maxDepth) {
        if (currentDepth > maxDepth) {
            return new ArrayList<ISynset>();
        }
        if (done.contains(srcSense.getID())) {
            return new ArrayList<ISynset>();
        }
        if (((ISynsetID)srcSense.getID()).equals(targetSense.getID())) {
            return path;
        }
        HashSet<ISynset> newDone = new HashSet<ISynset>(done);
        newDone.add(srcSense);
        List relatedIDs = srcSense.getRelatedSynsets();
        if (relatedIDs.isEmpty()) {
            return new ArrayList<ISynset>();
        }
        for (ISynsetID relatedID : relatedIDs) {
            ISynset relatedSynset = this.dictionary.getSynset(relatedID);
            ArrayList<ISynset> newPath = new ArrayList<ISynset>(path);
            newPath.add(relatedSynset);
            List<ISynset> path2 = this.dfs(relatedSynset, targetSense, currentDepth + 1, newDone, newPath, maxDepth);
            if (path2.isEmpty()) continue;
            return path2;
        }
        return new ArrayList<ISynset>();
    }

    public IWord getSense(String word, int senseNumber) {
        return this.getSense(word, POS.NOUN, senseNumber);
    }

    public IWord getSense(String word, POS pos, int senseNumber) {
        List<IWord> senses = this.getSenses(word, pos);
        for (IWord sense : senses) {
            if (this.getSenseNumber(sense) != senseNumber) continue;
            return sense;
        }
        return null;
    }

    public int getSenseNumber(IWord sense) {
        ISenseEntry entry = this.dictionary.getSenseEntry(sense.getSenseKey());
        if (entry != null) {
            return this.dictionary.getSenseEntry(sense.getSenseKey()).getSenseNumber();
        }
        return -1;
    }

    public static IWord mapSenseToVersion(IWord sense, WordNetVersion sourceVersion) {
        return WordNet.mapSenseToVersion(sense, sourceVersion, WordNetVersion.WN_30);
    }

    public static IWord mapSenseToVersion(IWord sense, WordNetVersion sourceVersion, WordNetVersion targetVersion) {
        if (!targetVersion.equals((Object)WordNetVersion.WN_30)) {
            throw new RuntimeException("Only wn 3.0 as target available");
        }
        ISenseKey oldSenseKey = sense.getSenseKey();
        ISenseKey newSenseKey = WordNetMappings.getInstance().getTargetSenseKey(oldSenseKey, sourceVersion);
        return WordNet.getInstance((WordNetVersion)targetVersion).dictionary.getWord(newSenseKey);
    }

    public IWord getSenseFromSenseKey(ISenseKey sensekey) {
        return this.getSenseFromSenseKey(sensekey.toString());
    }

    public IWord getSenseFromSenseKey(String sensekey) {
        String lemma = sensekey.split("%")[0];
        HashSet<IWord> senses = new HashSet<IWord>();
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            senses.addAll(this.getSenses(lemma, pos));
            ++n2;
        }
        for (IWord sense : senses) {
            if (!sense.getSenseKey().toString().equals(sensekey)) continue;
            return sense;
        }
        return null;
    }

    public ISenseKey getSenseKeyFromString(String senseKey) {
        return SenseKeyParser.getInstance().parseLine(senseKey);
    }

    public IWord getSenseFromID(IWordID id) {
        return this.dictionary.getWord(id);
    }

    public String senseToString(IWord sense) {
        return new StringBuffer().append(sense.getLemma()).append(SENSE_SEPARATOR).append(sense.getPOS().getTag()).append(SENSE_SEPARATOR).append(this.getSenseNumber(sense)).toString();
    }

    public String senseToLemmaPosString(IWord sense) {
        return new StringBuffer().append(sense.getLemma()).append(SENSE_SEPARATOR).append(sense.getPOS().getTag()).toString();
    }

    public List<String> sensesToString(Iterable<IWord> senses) {
        ArrayList<String> list = new ArrayList<String>();
        for (IWord sense : senses) {
            list.add(this.senseToString(sense));
        }
        return list;
    }

    public String getRelatedSynsetsString(ISynset synset) {
        return this.getRelatedSynsetsString(synset, false);
    }

    public String getRelatedSynsetsString(ISynset synset, boolean includeLexicalRelations) {
        StringBuilder buffer = new StringBuilder();
        Map relatedSemMap = synset.getRelatedMap();
        for (IPointer pointer : relatedSemMap.keySet()) {
            List relatedSynsets = (List)relatedSemMap.get(pointer);
            for (ISynsetID relatedSynset : relatedSynsets) {
                buffer.append(pointer.getSymbol()).append(" ").append(Synset.zeroFillOffset((int)relatedSynset.getOffset())).append(relatedSynset.getPOS().getTag()).append(" ");
            }
        }
        if (includeLexicalRelations) {
            HashMap relatedLexMap = new HashMap();
            for (IWord sense : synset.getWords()) {
                Map relatedSenseMap = sense.getRelatedMap();
                for (IPointer pointer : relatedSenseMap.keySet()) {
                    List relatedSenses = (List)relatedSenseMap.get(pointer);
                    HashSet<ISynsetID> relatedSynsets = (HashSet<ISynsetID>)relatedLexMap.get(pointer);
                    if (relatedSynsets == null) {
                        relatedSynsets = new HashSet<ISynsetID>();
                        relatedLexMap.put(pointer, relatedSynsets);
                    }
                    for (IWordID relatedSense : relatedSenses) {
                        relatedSynsets.add((ISynsetID)this.dictionary.getWord(relatedSense).getSynset().getID());
                    }
                }
            }
            for (IPointer pointer : relatedLexMap.keySet()) {
                Set relatedSynsets = (Set)relatedLexMap.get(pointer);
                for (ISynsetID relatedSynset : relatedSynsets) {
                    buffer.append(pointer.getSymbol()).append(" ").append(Synset.zeroFillOffset((int)relatedSynset.getOffset())).append(relatedSynset.getPOS().getTag()).append(" ");
                }
            }
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public Set<ISynset> getRelatedSynsets(ISynset synset) {
        return this.getRelatedSynsets(synset, false);
    }

    public Set<ISynset> getRelatedSynsets(ISynset synset, boolean includeLexicalRelations) {
        HashSet<ISynset> relatedSynsets = new HashSet<ISynset>();
        ArrayList<ISynsetID> relatedSynsetIDs = new ArrayList<ISynsetID>(synset.getRelatedSynsets());
        if (includeLexicalRelations) {
            for (IWord sense : synset.getWords()) {
                for (IWordID wordID : sense.getRelatedWords()) {
                    relatedSynsetIDs.add(wordID.getSynsetID());
                }
            }
        }
        for (ISynsetID synsetID : relatedSynsetIDs) {
            relatedSynsets.add(this.getSynsetFromID(synsetID));
        }
        return relatedSynsets;
    }

    public Multimap<IPointer, ISynset> getRelatedSynsetsMap(ISynset synset) {
        return this.getRelatedSynsetsMap(synset, false);
    }

    public Multimap<IPointer, ISynset> getRelatedSynsetsMap(ISynset synset, boolean includeLexicalRelations) {
        HashMultimap relatedSynsetsMap = new HashMultimap();
        HashMultimap relatedSynsetIDsMap = new HashMultimap();
        Map relatedMap = synset.getRelatedMap();
        for (IPointer pointer : relatedMap.keySet()) {
            for (ISynsetID synsetID : (List)relatedMap.get(pointer)) {
                relatedSynsetIDsMap.put((Object)pointer, (Object)synsetID);
            }
        }
        if (includeLexicalRelations) {
            for (IWord sense : synset.getWords()) {
                Map relatedWordIDs = sense.getRelatedMap();
                for (IPointer pointer : relatedWordIDs.keySet()) {
                    for (IWordID wordID : (List)relatedWordIDs.get(pointer)) {
                        relatedSynsetIDsMap.put((Object)pointer, (Object)wordID.getSynsetID());
                    }
                }
            }
        }
        for (IPointer pointer : relatedSynsetIDsMap.keySet()) {
            for (ISynsetID synsetID : relatedSynsetIDsMap.get((Object)pointer)) {
                relatedSynsetsMap.put((Object)pointer, (Object)this.getSynsetFromID(synsetID));
            }
        }
        return relatedSynsetsMap;
    }

    public Set<String> getSynonyms(ISynset synset) {
        HashSet<String> synonyms = new HashSet<String>();
        for (IWord sense : synset.getWords()) {
            synonyms.add(sense.getLemma().toLowerCase());
        }
        return synonyms;
    }

    public Set<IWord> getSynomyms(IWord sense) {
        HashSet<IWord> synonyms = new HashSet<IWord>();
        for (IWord candidate : sense.getSynset().getWords()) {
            if (candidate.equals(sense)) continue;
            synonyms.add(candidate);
        }
        return synonyms;
    }

    public String synsetToSenseString(ISynset synset) {
        StringBuffer buffer = new StringBuffer();
        for (IWord w : synset.getWords()) {
            buffer.append(this.senseToString(w)).append("|");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public String getLexicographicIdFromSynset(ISynset synset, String word) {
        IWord sense = this.getSenseFromSynset(synset, word);
        return this.getLexicographicIdFromSense(sense);
    }

    public String getLexicographicIdFromSenseString(String senseString) {
        return this.getLexicographicIdFromSense(this.getSenseFromSenseString(senseString));
    }

    public String getLexicographicIdFromOffset(String offset, String word) {
        return this.getLexicographicIdFromSynset(this.getSynsetFromOffset(offset), word);
    }

    public String getLexicographicIdFromSense(IWord sense) {
        return sense.getSenseKey().toString();
    }

    public String synsetToFirstSenseString(ISynset synset) {
        return this.senseToString(synset.getWord(1));
    }

    public String synsetsToFirstSenseString(Collection<ISynset> synsets) {
        StringBuffer sb = new StringBuffer();
        for (ISynset s : synsets) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.synsetToFirstSenseString(s));
        }
        return sb.toString();
    }

    public String synsetsToSenseString(Collection<ISynset> synsets) {
        StringBuffer sb = new StringBuffer();
        for (ISynset s : synsets) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.synsetToSenseString(s));
        }
        return sb.toString();
    }

    public static String synsetToString(ISynset synset) {
        return String.valueOf(Synset.zeroFillOffset((int)((ISynsetID)synset.getID()).getOffset())) + synset.getPOS().getTag();
    }

    public String synsetsToString(List<ISynset> synsets) {
        StringBuffer sb = new StringBuffer();
        for (ISynset s : synsets) {
            sb.append(String.valueOf(this.senseToString(s.getWord(1))) + "->");
        }
        return sb.toString().substring(0, sb.length() - 2);
    }

    public static String trimOffset(String value) {
        String[] fields = value.split("-");
        if (fields.length > 1) {
            value = String.valueOf(fields[fields.length - 2]) + fields[fields.length - 1];
        }
        return value;
    }

    public static SynsetID parseSynsetOffset(String value) {
        if (value == null) {
            return null;
        }
        if ((value = WordNet.trimOffset(value)).length() != 9) {
            return null;
        }
        int offset = 0;
        try {
            offset = Integer.parseInt(value.substring(0, 8));
        }
        catch (Exception e) {
            return null;
        }
        char tag = Character.toLowerCase(value.charAt(8));
        POS pos = null;
        try {
            pos = POS.getPartOfSpeech((char)tag);
        }
        catch (Exception e) {
            return null;
        }
        if (pos != null) {
            return new SynsetID(offset, pos);
        }
        return null;
    }

    public POS getPOSFromOffset(String value) {
        if (value == null) {
            return null;
        }
        return POS.getPartOfSpeech((char)Strings.lastCharOf(value).charAt(0));
    }

    public ISynset getSynsetFromOffset(String value) {
        return this.dictionary.getSynset((ISynsetID)WordNet.parseSynsetOffset(value));
    }

    public ISynset getSynsetFromSenseString(String value) {
        IWord word_sense = this.getSenseFromSenseString(value = Strings.prefixUntil(value, '|'));
        if (word_sense == null) {
            return null;
        }
        return word_sense.getSynset();
    }

    public IWord getSenseFromSenseString(String value) {
        value = Strings.prefixUntil(value, '|');
        String[] triple = value.split(SENSE_SEPARATOR);
        return this.getSense(triple[0], POS.getPartOfSpeech((char)triple[1].charAt(0)), Integer.parseInt(triple[2]));
    }

    public void close() {
        this.dictionary.close();
    }

    public static void closeAllWordNets() {
        for (WordNetVersion wnv : singleton.keySet()) {
            singleton.get((Object)wnv).close();
        }
    }

    public String toString() {
        return (Object)((Object)this.wnv) + ":" + this.dictionary.getVersion();
    }

    public Set<String> stem(String word) {
        return this.stem(word, POS.NOUN);
    }

    public Set<String> stem(String word, POS pos) {
        LinkedHashSet<String> stems = new LinkedHashSet<String>();
        stems.addAll(this.simpleStemmer.findStems(word, pos));
        stems.addAll(this.wnStemmer.findStems(word, pos));
        return stems;
    }

    public Set<IIndexWord> getIndexWords(String lemma) {
        HashSet<IIndexWord> lp = new HashSet<IIndexWord>();
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            IIndexWord iw = this.dictionary.getIndexWord(lemma, pos);
            if (iw != null) {
                lp.add(iw);
            }
            ++n2;
        }
        return lp;
    }

    public Set<ISynset> getAllSynsets() {
        return this.getAllSynsets(POS.values());
    }

    public Set<ISynset> getAllSynsets(POS pos) {
        return this.getAllSynsets(new POS[]{pos});
    }

    public Set<ISynset> getAllSynsets(POS[] poses) {
        HashSet<ISynset> synsets = new HashSet<ISynset>();
        POS[] pOSArray = poses;
        int n = poses.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            for (String word : this.getAllWords(pos)) {
                for (ISynset synset : this.getSynsets(word, pos)) {
                    synsets.add(synset);
                }
            }
            ++n2;
        }
        return synsets;
    }

    private int getSynsetRank(String word, ISynset sense) {
        List<ISynset> wordSenses = this.getSynsets(word, sense.getPOS());
        int index = 0;
        while (index < wordSenses.size()) {
            if (wordSenses.get(index).equals(sense)) {
                return index + 1;
            }
            ++index;
        }
        return 0;
    }

    public String synsetToSenseString(String word, ISynset sense) {
        StringBuffer buffer = new StringBuffer();
        return buffer.append(word).append(SENSE_SEPARATOR).append(sense.getPOS().getTag()).append(SENSE_SEPARATOR).append(this.getSynsetRank(word, sense)).toString();
    }

    private void getAncestors(Map<ISynset, Integer> ancestors, ISynset synset, int distance, ISynset until) {
        ArrayList hypers = new ArrayList();
        ancestors.put(synset, distance);
        if (until != null && synset.equals(until)) {
            return;
        }
        hypers.addAll(synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM));
        hypers.addAll(synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM_INSTANCE));
        int nextDistance = distance + 1;
        for (ISynsetID h : hypers) {
            if (ancestors.keySet().contains(this.getSynsetFromID(h))) continue;
            this.getAncestors(ancestors, this.getSynsetFromID(h), nextDistance, until);
        }
    }

    private void getDescendants(Map<ISynset, Integer> descendants, ISynset synset, int distance) {
        ArrayList hypos = new ArrayList();
        descendants.put(synset, distance);
        hypos.addAll(synset.getRelatedSynsets((IPointer)Pointer.HYPONYM));
        hypos.addAll(synset.getRelatedSynsets((IPointer)Pointer.HYPONYM_INSTANCE));
        int nextDistance = distance + 1;
        for (ISynsetID h : hypos) {
            this.getDescendants(descendants, this.getSynsetFromID(h), nextDistance);
        }
    }

    public List<ISynset> getSiblings(ISynset synset) {
        return this.getSiblings(synset, true);
    }

    public List<ISynset> getSiblings(ISynset synset, boolean bInstances) {
        ArrayList<ISynset> siblings = new ArrayList<ISynset>();
        for (ISynset hyper : this.getHypernyms(synset)) {
            siblings.addAll(this.getHyponyms(hyper, bInstances));
        }
        siblings.remove(synset);
        return siblings;
    }

    public List<ISynset> getHypernyms(ISynset synset, boolean bInstances) {
        ArrayList<ISynset> hypers = new ArrayList<ISynset>();
        if (this.wnv == WordNetVersion.WN_30 && synset.getOffset() == 2423762) {
            return hypers;
        }
        if (bInstances) {
            for (ISynsetID hyper : synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM_INSTANCE)) {
                hypers.add(this.getSynsetFromID(hyper));
            }
        }
        for (ISynsetID hyper : synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM)) {
            hypers.add(this.getSynsetFromID(hyper));
        }
        return hypers;
    }

    public List<ISynset> getHypernyms(ISynset synset) {
        return this.getHypernyms(synset, true);
    }

    public List<ISynset> getHyponyms(ISynset synset) {
        return this.getHyponyms(synset, true);
    }

    public List<ISynset> getHyponyms(ISynset synset, boolean bInstances) {
        ArrayList<ISynset> hypos = new ArrayList<ISynset>();
        for (ISynsetID hypo : synset.getRelatedSynsets((IPointer)Pointer.HYPONYM)) {
            hypos.add(this.getSynsetFromID(hypo));
        }
        if (bInstances) {
            for (ISynsetID hypo : synset.getRelatedSynsets((IPointer)Pointer.HYPONYM_INSTANCE)) {
                hypos.add(this.getSynsetFromID(hypo));
            }
        }
        return hypos;
    }

    public Set<IWord> getNeighborhood(IWord sense) {
        return this.getNeighborhood(sense, false);
    }

    public Set<IWord> getNeighborhood(IWord sense, boolean bSynsetGrained) {
        HashSet<IWord> senseNeighborHood = new HashSet<IWord>();
        if (bSynsetGrained) {
            senseNeighborHood.add(sense);
            for (ISynset hypernym : this.getHypernyms(sense.getSynset())) {
                senseNeighborHood.add(hypernym.getWord(1));
            }
            for (ISynset hyponym : this.getHyponyms(sense.getSynset())) {
                senseNeighborHood.add(hyponym.getWord(1));
            }
        } else {
            senseNeighborHood.addAll(this.getSynomyms(sense));
            for (ISynset hypernym : this.getHypernyms(sense.getSynset())) {
                senseNeighborHood.addAll(hypernym.getWords());
            }
            for (ISynset hyponym : this.getHyponyms(sense.getSynset())) {
                senseNeighborHood.addAll(hyponym.getWords());
            }
            senseNeighborHood.add(sense);
        }
        return senseNeighborHood;
    }

    public Map<ISynset, Integer> getAncestorsWithDepth(ISynset instance) {
        return this.getAncestorsWithDepthUntil(instance, null);
    }

    public Map<ISynset, Integer> getAncestorsWithDepthUntil(ISynset instance, ISynset until) {
        ArrayList hypers = new ArrayList();
        LinkedHashMap<ISynset, Integer> ancestors = new LinkedHashMap<ISynset, Integer>();
        hypers.addAll(instance.getRelatedSynsets((IPointer)Pointer.HYPERNYM_INSTANCE));
        hypers.addAll(instance.getRelatedSynsets((IPointer)Pointer.HYPERNYM));
        for (ISynsetID h : hypers) {
            this.getAncestors(ancestors, this.getSynsetFromID(h), 1, until);
        }
        return ancestors;
    }

    public List<ISynset> getAncestors(ISynset instance, boolean bIncludeInitialSynset) {
        ArrayList<ISynset> list = new ArrayList<ISynset>();
        if (bIncludeInitialSynset) {
            list.add(instance);
        }
        list.addAll(this.getAncestorsWithDepth(instance).keySet());
        return list;
    }

    public List<ISynset> getCommonAncestors(ISynset c1, ISynset c2) {
        List<ISynset> anc1 = this.getAncestors(c1);
        anc1.retainAll(this.getAncestors(c2));
        return anc1;
    }

    public List<ISynset> getAncestors(ISynset instance) {
        return this.getAncestors(instance, false);
    }

    public List<ISynset> getAncestorsUntil(ISynset instance, ISynset until) {
        return new ArrayList<ISynset>(this.getAncestorsWithDepthUntil(instance, until).keySet());
    }

    public Set<List<ISynset>> getAncestorsPaths(ISynset synset) {
        HashSet<List<ISynset>> paths = new HashSet<List<ISynset>>();
        HashSet<List<ISynset>> subpaths = new HashSet<List<ISynset>>();
        for (ISynset iSynset : this.getHypernyms(synset)) {
            subpaths.addAll(this.getAncestorsPaths(iSynset));
        }
        if (subpaths.isEmpty()) {
            ArrayList<ISynset> arrayList = new ArrayList<ISynset>();
            arrayList.add(synset);
            paths.add(arrayList);
            return paths;
        }
        for (List list : subpaths) {
            ArrayList<ISynset> path = new ArrayList<ISynset>();
            path.add(synset);
            path.addAll(list);
            paths.add(path);
        }
        return paths;
    }

    public Set<List<ISynset>> getAncestorsPaths(ISynset synset, Set<ISynset> selection) {
        HashSet<List<ISynset>> paths = new HashSet<List<ISynset>>();
        HashSet<List<ISynset>> subpaths = new HashSet<List<ISynset>>();
        for (ISynset hypernym : this.getHypernyms(synset)) {
            subpaths.addAll(this.getAncestorsPaths(hypernym, selection));
        }
        boolean addThisSynset = selection.contains(synset);
        if (subpaths.isEmpty() && addThisSynset) {
            ArrayList<ISynset> arrayList = new ArrayList<ISynset>();
            arrayList.add(synset);
            paths.add(arrayList);
            return paths;
        }
        for (List list : subpaths) {
            ArrayList<ISynset> path = new ArrayList<ISynset>();
            if (addThisSynset) {
                path.add(synset);
            }
            path.addAll(list);
            paths.add(path);
        }
        return paths;
    }

    public Map<ISynset, Integer> getDescendantsWithDepth(ISynset instance) {
        ArrayList hypos = new ArrayList();
        LinkedHashMap<ISynset, Integer> descendants = new LinkedHashMap<ISynset, Integer>();
        hypos.addAll(instance.getRelatedSynsets((IPointer)Pointer.HYPONYM_INSTANCE));
        hypos.addAll(instance.getRelatedSynsets((IPointer)Pointer.HYPONYM));
        for (ISynsetID h : hypos) {
            this.getDescendants(descendants, this.getSynsetFromID(h), 1);
        }
        return descendants;
    }

    public Set<ISynset> getDescendants(ISynset s) {
        return this.getDescendants(s, false);
    }

    public Set<ISynset> getDescendants(ISynset instance, boolean bIncludeInitialSynset) {
        return this.getDescendants(instance, bIncludeInitialSynset, false);
    }

    public Set<ISynset> getDescendants(ISynset instance, boolean bIncludeInitialSynset, boolean bIncludeInstances) {
        HashSet<ISynset> descendants = new HashSet<ISynset>();
        this.getDescendants(instance, descendants, bIncludeInstances);
        if (bIncludeInitialSynset) {
            descendants.add(instance);
        }
        return descendants;
    }

    private void getDescendants(ISynset s, Set<ISynset> descendants, boolean bIncludeInstances) {
        if (this.wnv == WordNetVersion.WN_30 && s.getPOS() == POS.VERB && this.synsetToFirstSenseString(s).equals("inhibit#v#4")) {
            return;
        }
        for (ISynset h : this.getHyponyms(s, bIncludeInstances)) {
            descendants.add(h);
            this.getDescendants(h, descendants, bIncludeInstances);
        }
    }

    public Map<ISynset, Integer> getNeighboursWithDepth(ISynset synset, int maxDistance) {
        return this.getNeighboursWithDepth(synset, false, maxDistance);
    }

    public Map<ISynset, Integer> getNeighboursWithDepth(ISynset synset, boolean includeLexicalRelations, int maxDistance) {
        Set<ISynset> related = this.getRelatedSynsets(synset, includeLexicalRelations);
        LinkedHashMap<ISynset, Integer> neighbours = new LinkedHashMap<ISynset, Integer>();
        int distance = 1;
        while (distance <= maxDistance) {
            HashSet<ISynset> newRelateds = new HashSet<ISynset>();
            for (ISynset s : related) {
                if (!neighbours.containsKey(s)) {
                    neighbours.put(s, distance);
                }
                newRelateds.addAll(this.getRelatedSynsets(s, includeLexicalRelations));
            }
            related.clear();
            related.addAll(newRelateds);
            ++distance;
        }
        return neighbours;
    }

    public static Pair<IWord, Integer> ancestorsContain(Map<ISynset, Integer> ancestors, String lemma) {
        for (ISynset ancestor : ancestors.keySet()) {
            for (IWord sense : ancestor.getWords()) {
                if (!sense.getLemma().equalsIgnoreCase(lemma)) continue;
                return new Pair<IWord, Integer>(sense, ancestors.get(ancestor));
            }
        }
        return null;
    }

    public static IWord ancestorsContain(List<ISynset> synsets, String lemma) {
        for (ISynset synset : synsets) {
            for (IWord sense : synset.getWords()) {
                if (!sense.getLemma().equalsIgnoreCase(lemma)) continue;
                return sense;
            }
        }
        return null;
    }

    public static IWord getSynonymSense(ISynset synset, String lemma) {
        for (IWord w : synset.getWords()) {
            if (!w.getLemma().equalsIgnoreCase(lemma)) continue;
            return w;
        }
        return null;
    }

    public Set<String> getSynsetWords(ISynset synset) {
        HashSet<String> words = new HashSet<String>();
        for (IWord sense : synset.getWords()) {
            words.add(sense.getLemma());
        }
        return words;
    }

    public String getSingularOf(String word) {
        return this.getSingularOf(word, POS.NOUN);
    }

    public String getSingularOf(String word, POS pos) {
        IExceptionEntry exc = this.dictionary.getExceptionEntry(word, pos);
        if (exc != null) {
            return (String)exc.getRootForms().get(0);
        }
        String suffix = "";
        if (pos == POS.NOUN) {
            if (word.endsWith("ful")) {
                word = Strings.substring(word, 0, -3);
                suffix = "ful";
            } else if (word.endsWith("ss") || word.length() <= 2) {
                return word;
            }
        }
        String[] suffixes = null;
        String[] replacements = null;
        switch (pos) {
            case NOUN: {
                suffixes = new String[]{"s", "ses", "shes", "ches", "zes", "xes", "men", "ies"};
                replacements = new String[]{"", "s", "sh", "ch", "z", "x", "man", "y"};
                break;
            }
            case VERB: {
                suffixes = new String[]{"s", "ies", "es", "es", "ed", "ed", "ing", "ing"};
                replacements = new String[]{"", "y", "e", "", "e", "", "e", ""};
                break;
            }
            case ADJECTIVE: {
                suffixes = new String[]{"er", "est", "er", "est"};
                replacements = new String[]{"", "", "e", "e"};
                break;
            }
            case ADVERB: {
                suffixes = new String[]{};
            }
        }
        int k = 0;
        while (k < suffixes.length) {
            String ret;
            if (word.endsWith(suffixes[k]) && this.getSenses(ret = String.valueOf(Strings.substring(word, 0, -suffixes[k].length())) + (String)replacements[k], pos).size() > 0) {
                return String.valueOf(ret) + suffix;
            }
            ++k;
        }
        return String.valueOf(word) + suffix;
    }

    public String getPluralOf(String word) {
        int len = word.length();
        word = word.endsWith("y") ? String.valueOf(word.substring(0, len - 1)) + "ies" : (word.endsWith("s") || word.endsWith("z") || word.endsWith("ch") || word.endsWith("sh") || word.endsWith("x") ? String.valueOf(word) + "es" : String.valueOf(word) + "s");
        return word;
    }

    public boolean isPlural(String word) {
        IIndexWord iw = this.getIndexWord(word = word.toLowerCase().replace(' ', '_'), POS.NOUN);
        if (iw != null) {
            return !iw.getLemma().toLowerCase().equals(word);
        }
        for (String stem : this.simpleStemmer.findStems(word, POS.NOUN)) {
            if (!stem.toLowerCase().equals(word)) continue;
            return false;
        }
        return true;
    }

    public Set<String> getWordsWithPolysemy(int polysemy) {
        HashSet<String> words = new HashSet<String>();
        Iterator i = this.dictionary.getIndexWordIterator(POS.NOUN);
        while (i.hasNext()) {
            IIndexWord iw = (IIndexWord)i.next();
            int poly = this.getSenses(iw).size();
            if (poly != polysemy) continue;
            words.add(iw.getLemma());
        }
        return words;
    }

    public int getPolysemyOf(String word, POS pos) {
        return this.getSenses(word, pos).size();
    }

    public double getAveragePolysemy(Set<String> words, POS pos, boolean bWordsInWordNetOnly) {
        double totalPoly = 0.0;
        double total = 0.0;
        for (String word : words) {
            int poly = this.getPolysemyOf(word, pos);
            totalPoly += (double)poly;
            if (poly <= 0 && bWordsInWordNetOnly) continue;
            total += 1.0;
        }
        return totalPoly / total;
    }

    public boolean isMonosemous(String word, POS pos) {
        return this.getPolysemyOf(word, pos) == 1;
    }

    public boolean isPolysemous(String word, POS pos) {
        return this.getPolysemyOf(word, pos) > 1;
    }

    public Set<String> getAllWords() {
        HashSet<String> words = new HashSet<String>();
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS p = pOSArray[n2];
            Iterator i = this.dictionary.getIndexWordIterator(p);
            while (i.hasNext()) {
                IIndexWord iw = (IIndexWord)i.next();
                words.add(iw.getLemma());
            }
            ++n2;
        }
        return words;
    }

    public Set<String> getAllWords(POS pos) {
        HashSet<String> words = new HashSet<String>();
        Iterator i = this.dictionary.getIndexWordIterator(pos);
        while (i.hasNext()) {
            IIndexWord iw = (IIndexWord)i.next();
            words.add(iw.getLemma());
        }
        return words;
    }

    public Set<String> getAllWordsWithPos() {
        HashSet<String> words = new HashSet<String>();
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS p = pOSArray[n2];
            Iterator i = this.dictionary.getIndexWordIterator(p);
            while (i.hasNext()) {
                IIndexWord iw = (IIndexWord)i.next();
                words.add(String.valueOf(iw.getLemma()) + SENSE_SEPARATOR + p.getTag());
            }
            ++n2;
        }
        return words;
    }

    public Set<String> getWordNetStems(String word) {
        HashSet<String> stems = new HashSet<String>();
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            stems.addAll(this.wnStemmer.findStems(word, pos));
            ++n2;
        }
        return stems;
    }

    public Set<String> getSimpleStems(String word) {
        HashSet<String> stems = new HashSet<String>();
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            List posStems = this.simpleStemmer.findStems(word, pos);
            if (posStems != null) {
                stems.addAll(posStems);
            }
            ++n2;
        }
        return stems;
    }

    public int getHypernymDistanceFrom(ISynset synset, ISynset target) {
        return this.getHypernymDistanceFrom(synset, target, 0);
    }

    private int getHypernymDistanceFrom(ISynset synset, ISynset target, int dist) {
        if (synset.equals(target)) {
            return dist;
        }
        int bestDist = Integer.MAX_VALUE;
        for (ISynset h : this.getHypernyms(synset)) {
            int d = this.getHypernymDistanceFrom(h, target, dist + 1);
            if (d >= bestDist) continue;
            bestDist = d;
        }
        return bestDist;
    }

    public int getHeight(IWord sense) {
        return this.getHeight(sense.getSynset());
    }

    public int getHeight(ISynset synset) {
        return this.getPrivateHeight(synset, synset.getPOS());
    }

    public int getHeight(ISynset synset, POS pos) {
        return this.getPrivateHeight(synset, pos);
    }

    private int getPrivateHeight(ISynset synset, POS pos) {
        if (this.wnv == WordNetVersion.WN_30 && pos == POS.VERB && this.synsetToFirstSenseString(synset).equals("inhibit#v#4")) {
            return 0;
        }
        int bestHypernymDistance = Integer.MAX_VALUE;
        for (ISynset h : this.getHypernyms(synset)) {
            bestHypernymDistance = Math.min(bestHypernymDistance, this.getPrivateHeight(h, pos));
        }
        if (bestHypernymDistance == Integer.MAX_VALUE) {
            return 0;
        }
        return 1 + bestHypernymDistance;
    }

    public int getDistanceFrom(ISynset synset, ISynset target, int maxDistance) {
        return this.getDistanceFrom(synset, Sets.varargsToHashSet(target), 0, new HashSet<ISynset>(), maxDistance);
    }

    public int getDistanceFrom(ISynset synset, Set<ISynset> targets, int maxDistance) {
        return this.getDistanceFrom(synset, targets, 0, new HashSet<ISynset>(), maxDistance);
    }

    private int getDistanceFrom(ISynset synset, Set<ISynset> targets, int dist, Set<ISynset> visited, int maxDistance) {
        if (dist > maxDistance) {
            return Integer.MAX_VALUE;
        }
        if (targets.contains(synset)) {
            return dist;
        }
        visited = new HashSet<ISynset>(visited);
        visited.add(synset);
        int bestDist = Integer.MAX_VALUE;
        for (ISynset h : this.getRelatedSynsets(synset, true)) {
            int d;
            if (visited.contains(h) || (d = this.getDistanceFrom(h, targets, dist + 1, visited, maxDistance)) >= bestDist) continue;
            bestDist = d;
        }
        return bestDist;
    }

    public void explore() {
        this.explore(this.getSense("entity", POS.NOUN, 1).getSynset(), 0);
    }

    public void explore(ISynset synset, int tab) {
        ArrayList ids = new ArrayList(synset.getRelatedSynsets((IPointer)Pointer.HYPONYM));
        ids.addAll(synset.getRelatedSynsets((IPointer)Pointer.HYPONYM_INSTANCE));
        int k = 0;
        while (k < tab) {
            System.out.print("  ");
            ++k;
        }
        System.out.println(this.synsetToSenseString(synset));
        for (ISynsetID id : ids) {
            this.explore(this.getSynsetFromID(id), tab + 1);
        }
    }

    public Set<String> getLemmasFromSynset(ISynset synset) {
        HashSet<String> words = new HashSet<String>();
        for (IWord word : synset.getWords()) {
            words.add(word.getLemma());
        }
        return words;
    }

    public static boolean isInstance(ISynset synset) {
        List hyperSynsets = synset.getRelatedSynsets((IPointer)Pointer.HYPERNYM_INSTANCE);
        return !hyperSynsets.isEmpty();
    }

    public List<String> getMonosemousWords() throws IOException {
        return this.getMonosemousWords(3, "[A-Za-z_]*");
    }

    public List<String> getMonosemousWords(int minimumWordLength) throws IOException {
        return this.getMonosemousWords(minimumWordLength, null);
    }

    public List<String> getMonosemousWords(int minimumWordLength, String regularExpression) throws IOException {
        ArrayList<String> monos = new ArrayList<String>();
        Set<String> wordnetWords = this.getAllWords();
        Iterator<String> wIter = wordnetWords.iterator();
        while (wIter.hasNext()) {
            String word = wIter.next().toString();
            if (this.getSenses(word).size() != 1 || regularExpression != null && !word.matches(regularExpression) || word.length() <= minimumWordLength) continue;
            monos.add(word);
        }
        return monos;
    }

    public static char getCharFromPOS(ISynset synset) {
        switch (synset.getPOS()) {
            case NOUN: {
                return 'n';
            }
            case VERB: {
                return 'v';
            }
            case ADVERB: {
                return 'r';
            }
            case ADJECTIVE: {
                return 'a';
            }
        }
        return '?';
    }

    public static POS getPOSfromChar(String pos) {
        return WordNet.getPOSfromChar(pos.charAt(0));
    }

    public static POS getPOSfromChar(char pos) {
        switch (pos) {
            case 'n': {
                return POS.NOUN;
            }
            case 'v': {
                return POS.VERB;
            }
            case 'r': {
                return POS.ADVERB;
            }
            case 'a': {
                return POS.ADJECTIVE;
            }
        }
        return null;
    }

    public boolean containsLemma(String lemma) {
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            if (!this.getSynsets(lemma, pos).isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean containsLemma(String lemma, POS pos) {
        return !this.getSynsets(lemma, pos).isEmpty();
    }

    public boolean containsLemmaPos(String lemmaPos) {
        return !this.getSynsets(Strings.getLemma(lemmaPos), Strings.getPos(lemmaPos)).isEmpty();
    }

    public boolean containsSense(String sense) {
        return this.getSynsetFromSenseString(sense) != null;
    }

    public Set<IWord> getSynsetsWords(Collection<ISynset> synsets) {
        HashSet<IWord> senses = new HashSet<IWord>();
        for (ISynset synset : synsets) {
            senses.addAll(synset.getWords());
        }
        return senses;
    }

    public static void main(String[] args) {
        ISynset syn;
        WordNet wn = WordNet.getInstance();
        ISynset apple = wn.getSynsetFromSenseString("cooking_apple#n#1");
        Multimap<IPointer, ISynset> related = wn.getRelatedSynsetsMap(apple, true);
        for (IPointer pointer : related.keySet()) {
            Collection pointerRelated = related.get((Object)pointer);
            System.out.println("|" + pointer.getName() + "(s:" + pointer.getSymbol() + ")| = " + pointerRelated.size());
            for (ISynset s : pointerRelated) {
                System.out.println("\t[" + pointer.getName() + "]" + wn.synsetToFirstSenseString(s));
            }
        }
        System.exit(0);
        ISynset mark = wn.getSynsetFromSenseString("mark#n#12");
        System.out.println("Ancestors: " + wn.synsetsToSenseString(wn.getAncestors(mark)));
        ISynset train = wn.getSynsetFromSenseString("train#v#7");
        System.out.println("Ancestors: " + wn.synsetsToSenseString(wn.getAncestors(train)));
        System.exit(1);
        ISynset animal = wn.getSynsetFromSenseString("animal#n#1");
        ISynset cat = wn.getSynsetFromSenseString("cat#n#1");
        for (ISynset iSynset : wn.getAncestorsUntil(cat, animal)) {
            System.out.println(wn.synsetToSenseString(iSynset));
        }
        for (IWord iWord : wn.getSenses("cat", POS.NOUN)) {
            int dist = wn.getHypernymDistanceFrom(iWord.getSynset(), animal);
            System.out.println(String.valueOf(wn.senseToString(iWord)) + ":" + dist);
        }
        System.out.println(wn.getDescendantsWithDepth(wn.getSense("house", 1).getSynset()));
        System.out.println(wn.getDescendants(wn.getSense("house", 1).getSynset()));
        System.out.println("Height(physical object.n.1) = " + wn.getHeight(wn.getSense("physical_object", 1)));
        System.out.println("Height(eat.v.1) = " + wn.getHeight(wn.getSynsetFromSenseString("eat#v#1")));
        System.out.println("Height(eat.v.4) = " + wn.getHeight(wn.getSynsetFromSenseString("eat#v#4")));
        System.out.println("Height(train.v.9) = " + wn.getHeight(wn.getSynsetFromSenseString("train#v#9")));
        System.out.println("Height(entity.n.1) = " + wn.getHeight(wn.getSynsetFromSenseString("entity#n#1")));
        System.out.println("Height(call.n.6) = " + wn.getHeight(wn.getSynsetFromSenseString("call#n#6")));
        HashSet<ISynset> hashSet = new HashSet<ISynset>();
        hashSet.add(wn.getSense("car", 1).getSynset());
        hashSet.add(wn.getSense("house", 1).getSynset());
        System.out.println(wn.synsetsToSenseString(hashSet));
        System.out.println(wn.synsetsToFirstSenseString(hashSet));
        System.exit(1);
        System.out.println(wn.getSingularOf("hands"));
        System.out.println(wn.getSingularOf("ashes"));
        System.out.println(wn.getSingularOf("peaches"));
        System.out.println(wn.getSingularOf("peach"));
        System.out.println(wn.getSingularOf("wives"));
        System.out.println(wn.getSingularOf("knifes"));
        System.out.println(wn.getSingularOf("kisses"));
        System.out.println(wn.getSingularOf("cases"));
        System.out.println(wn.getSingularOf("possesses"));
        System.out.println(wn.getSingularOf("posts"));
        System.out.println(wn.getSingularOf("lingos"));
        System.out.println(wn.getSingularOf("groupies"));
        System.out.println(wn.getSingularOf("guis"));
        System.out.println(wn.getSingularOf("guys"));
        System.out.println(wn.getSingularOf("aches"));
        System.out.println(wn.getSingularOf("indices"));
        System.out.println(wn.getSingularOf("acciaccature"));
        System.out.println(wn.getSingularOf("leaves"));
        System.out.println(wn.getSingularOf("men"));
        System.out.println(wn.getSingularOf("buses"));
        System.out.println(wn.getSingularOf("potatoes"));
        System.out.println(wn.getSingularOf("handsful"));
        System.out.println(wn.getSingularOf("ladies"));
        System.out.println(wn.getSingularOf("bus_drivers"));
        System.out.println(wn.getSingularOf("apple_companies"));
        System.out.println(wn.getSingularOf("bus_driver"));
        System.out.println(wn.getSingularOf("apple_company"));
        System.out.println(wn.getSingularOf("kilos_kilos"));
        System.out.println(wn.getSingularOf("went_away"));
        System.out.println(wn.getWordNetStems("dangling"));
        System.out.println(wn.getWordNetStems("superamazing"));
        System.out.println(wn.getSimpleStems("superamazing"));
        System.exit(1);
        System.out.println(wn.getPluralOf("baby"));
        System.out.println(wn.getPluralOf("friend"));
        System.out.println(wn.getPluralOf("date"));
        IWord pear1 = wn.getSense("pear", 2);
        System.out.println(wn.getRelatedSynsets(pear1.getSynset()));
        System.exit(1);
        System.out.println(pear1.getLemma());
        System.out.println(pear1.getSynset());
        System.out.println("All:");
        for (ISynsetID id : pear1.getSynset().getRelatedSynsets()) {
            syn = wn.getSynsetFromID(id);
            System.out.println(syn);
        }
        System.out.println("HYPERNYMs:");
        for (ISynsetID id : pear1.getSynset().getRelatedSynsets((IPointer)Pointer.HYPERNYM)) {
            syn = wn.getSynsetFromID(id);
            System.out.println(syn);
        }
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            Iterator<IIndexWord> i = wn.getSenseIterator(pos);
            while (i.hasNext()) {
                IIndexWord iw = i.next();
                System.out.println("Ora sto lavorando su " + iw.getLemma());
                for (IWord sense1 : wn.getSenses(iw)) {
                    List lexicallyRelated = sense1.getRelatedWords();
                    List semanticallyRelated = sense1.getSynset().getRelatedSynsets();
                    for (IWordID wordID : lexicallyRelated) {
                        IWord sense2 = wn.getSenseFromID(wordID);
                        System.out.println(sense1 + " -lexical-> " + sense2);
                    }
                    for (ISynsetID synsetID : semanticallyRelated) {
                        ISynset synset2 = wn.getSynsetFromID(synsetID);
                        System.out.println(sense1 + " -semantic-> " + synset2);
                    }
                }
            }
            ++n2;
        }
        for (IWord sense : wn.getSenses("apple", POS.NOUN)) {
            System.out.println(String.valueOf(sense.getLemma()) + SENSE_SEPARATOR + sense.getPOS() + ":" + wn.senseToString(sense) + ":" + WordNet.synsetToString(sense.getSynset()));
        }
        System.out.println(wn.getSynsetFromOffset("07739125n"));
        System.out.println(wn.getWnStemmer().findStems("hands", POS.NOUN));
    }
}

