/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet;

import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class WeightedSense
implements Comparable<WeightedSense>,
Serializable {
    private static final long serialVersionUID = -1024331091496205756L;
    protected static NumberFormat FORMAT = DecimalFormat.getInstance(Locale.UK);
    private final IWord sense;
    protected Double weight;

    static {
        FORMAT.setMaximumFractionDigits(6);
        FORMAT.setMinimumFractionDigits(6);
    }

    public WeightedSense(IWord sense, double weight) {
        this.sense = sense;
        this.weight = weight;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public WeightedSense(IWord sense) {
        this.sense = sense;
    }

    public IWord getSense() {
        return this.sense;
    }

    @Override
    public int compareTo(WeightedSense o) {
        return o.getWeight().compareTo(this.weight);
    }

    public boolean equals(Object o) {
        if (!(o instanceof WeightedSense)) {
            return false;
        }
        return ((IWordID)this.sense.getID()).equals(((WeightedSense)o).sense.getID());
    }

    public int hashCode() {
        return this.sense.hashCode();
    }

    public boolean sumWeights(WeightedSense o) {
        if (o.sense.equals(this.sense)) {
            this.weight = this.weight + o.getWeight();
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.sense == null) {
            return "?";
        }
        return buffer.append(WordNet.getInstance().senseToString(this.sense)).append(":").append(FORMAT.format(this.weight)).toString();
    }
}

