/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.gigaword.Gigaword;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WNPseudowords {
    static IntegerCounter<String> gigaCounter = Gigaword.getInstance().getGigawordWordlist(50, "N", true, true);

    public static void main(String[] args) throws IOException {
        WordNet wn = WordNet.getInstance();
        IntegerCounter<Integer> counter = new IntegerCounter<Integer>();
        IntegerCounter<Integer> overallCounter = new IntegerCounter<Integer>();
        IntegerCounter<Integer> total = new IntegerCounter<Integer>();
        int wordCounter = 0;
        BufferedWriter bw = Files.getBufferedWriter("output/PWs.1000.txt");
        int MIN_SENTENCES = 1000;
        for (String word : wn.getAllWords(POS.NOUN)) {
            List<IWord> senses = wn.getSenses(word, POS.NOUN);
            if (senses.size() <= 1) continue;
            ++wordCounter;
            total.count(Integer.valueOf(senses.size()), senses.size());
            List<String> pseudoword = WNPseudowords.getPseudoword(word, 1000);
            if (pseudoword.contains(null)) {
                for (String ps : pseudoword) {
                    if (ps == null) continue;
                    overallCounter.count(senses.size());
                }
                continue;
            }
            overallCounter.count(Integer.valueOf(senses.size()), senses.size());
            counter.count(senses.size());
            bw.write("<" + word + ">\t" + Strings.join(pseudoword, "*") + "\n");
        }
        bw.close();
        Iterator<String> iterator = counter.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)((Object)iterator.next());
            System.out.println(String.valueOf(key) + "\t" + counter.get(key));
        }
        System.out.println("Overall, " + counter.getTotal() + " covered out of " + wordCounter);
        iterator = overallCounter.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)((Object)iterator.next());
            System.out.println(String.valueOf(key) + "\t" + overallCounter.get(key));
        }
        System.out.println("Overall, " + overallCounter.getTotal() + " covered out of " + total.getTotal());
    }

    public static List<String> getPseudoword(String word, int min_sentences) {
        ArrayList<String> pseudoword = new ArrayList<String>();
        WordNet wn = WordNet.getInstance();
        List<IWord> senses = wn.getSenses(word, POS.NOUN);
        ArrayList pseudo = new ArrayList();
        ArrayList<String> doneAlready = new ArrayList<String>();
        for (IWord sense : senses) {
            List<String> words = WNPseudowords.getNeighbouringWords(sense);
            List<String> mono = WNPseudowords.getMonosemousWords(words);
            IntegerCounter sortedMono = new IntegerCounter();
            ArrayList monoWithCounts = new ArrayList();
            mono.removeAll(doneAlready);
            String candidate = null;
            for (String m : mono) {
                int c = (Integer)gigaCounter.get(m.toLowerCase());
                if (c < min_sentences) continue;
                candidate = m;
                break;
            }
            doneAlready.addAll(mono);
            pseudoword.add(candidate);
        }
        return pseudoword;
    }

    public static List<String> getNeighbouringWords(IWord sense) {
        ArrayList<String> words = new ArrayList<String>();
        WordNet wn = WordNet.getInstance();
        for (String w : wn.getSynonyms(sense.getSynset())) {
            words.add(w.toLowerCase());
        }
        for (ISynset h : wn.getHypernyms(sense.getSynset())) {
            for (String w : wn.getSynonyms(h)) {
                if (words.contains(w = w.toLowerCase())) continue;
                words.add(w);
            }
        }
        for (ISynset h : wn.getHyponyms(sense.getSynset(), false)) {
            for (String w : wn.getSynonyms(h)) {
                if (words.contains(w = w.toLowerCase())) continue;
                words.add(w);
            }
        }
        for (ISynset s : wn.getSiblings(sense.getSynset(), false)) {
            for (String w : wn.getSynonyms(s)) {
                if (words.contains(w = w.toLowerCase())) continue;
                words.add(w);
            }
        }
        return words;
    }

    public static List<String> getMonosemousWords(List<String> words) {
        ArrayList<String> mono = new ArrayList<String>();
        WordNet wn = WordNet.getInstance();
        for (String w : words) {
            if (!wn.isMonosemous(w, POS.NOUN)) continue;
            mono.add(w);
        }
        return mono;
    }
}

