/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wordnet;

import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Pointer;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PseudowordEvaluationTwo {
    WordNet WN = WordNet.getInstance();

    public static void main(String[] args) {
        PseudowordEvaluationTwo ps = new PseudowordEvaluationTwo();
        String path = "/home/pilehvar/workspace/Pseudoing/output/SimilarityPseudowords.N.0.inf.newLKB.txt";
        PseudowordEvaluationTwo.checkWordNetStats();
    }

    public static void checkWordNetStats() {
        WordNet WN = WordNet.getInstance();
        IntegerCounter<Integer> monoCounter = new IntegerCounter<Integer>();
        IntegerCounter<Integer> totalCounter = new IntegerCounter<Integer>();
        for (String noun : WN.getAllWords(POS.NOUN)) {
            List<IWord> senses = WN.getSenses(noun, POS.NOUN);
            int poly = WN.getPolysemyOf(noun, POS.NOUN);
            for (IWord sense : senses) {
                boolean flag = false;
                ISynset synset = sense.getSynset();
                for (IWord synWord : synset.getWords()) {
                    String synW = synWord.getLemma();
                    if (WN.getPolysemyOf(synW, POS.NOUN) != 1) continue;
                    flag = true;
                }
                if (flag) {
                    monoCounter.count(poly);
                }
                totalCounter.count(poly);
            }
        }
        int monoInPolysemous = 0;
        int totalInPolysemous = 0;
        Iterator iterator = totalCounter.keySet().iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            System.out.println(String.valueOf(p) + "\t" + monoCounter.get(p) + "\t" + totalCounter.get(p));
            if (p <= 1) continue;
            monoInPolysemous += ((Integer)monoCounter.get(p)).intValue();
            totalInPolysemous += ((Integer)totalCounter.get(p)).intValue();
        }
        System.out.println(String.valueOf(monoInPolysemous) + "\t" + totalInPolysemous);
    }

    public void check(String path) {
        int totalSenses = 0;
        int coveredSenses = 0;
        try {
            BufferedReader br = Files.getBufferedReader(path);
            while (br.ready()) {
                String line = br.readLine();
                String pseudoword = line.split("\t")[0];
                String seed = pseudoword.split(" ")[0].replace(">", "").replace("<", "").trim();
                pseudoword = pseudoword.replaceAll("<[^ ]*>", "").trim();
                int senseNumber = 1;
                String[] stringArray = pseudoword.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String word = stringArray[n2];
                    Set<String> neighbours = this.getSynonyms(this.WN.getSense(seed, senseNumber));
                    if (neighbours.contains(word)) {
                        System.out.println(String.valueOf(seed) + ": " + pseudoword + "\t" + word);
                        ++coveredSenses;
                    } else {
                        for (String w : neighbours) {
                            if (WordNet.getInstance().getSenses(w, POS.NOUN).size() != 1) continue;
                            System.out.println("\t" + seed + ": " + pseudoword + "\t" + w);
                        }
                    }
                    ++senseNumber;
                    ++totalSenses;
                    ++n2;
                }
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.print(String.valueOf(coveredSenses) + " out of " + totalSenses + " were covered! (" + (double)coveredSenses / (double)totalSenses + " )");
    }

    public Set<String> getSynonyms(IWord sense) {
        HashSet<String> synsetWords = new HashSet<String>();
        for (IWord w : sense.getSynset().getWords()) {
            synsetWords.add(w.getLemma().toLowerCase());
        }
        return synsetWords;
    }

    public Set<String> getHypernyms(IWord sense) {
        HashSet<String> hypers = new HashSet<String>();
        for (ISynset h : this.WN.getHypernyms(sense.getSynset())) {
            for (String w : this.WN.getSynonyms(h)) {
                w = w.toLowerCase();
                hypers.add(w);
            }
        }
        return hypers;
    }

    public Set<String> getHyponyms(IWord sense) {
        HashSet<String> hypo = new HashSet<String>();
        for (ISynset h : this.WN.getHyponyms(sense.getSynset())) {
            for (String w : this.WN.getSynonyms(h)) {
                w = w.toLowerCase();
                hypo.add(w);
            }
        }
        return hypo;
    }

    static Set<String> getMeronyms(IWord sense) {
        HashSet<String> meron = new HashSet<String>();
        WordNet wn = WordNet.getInstance();
        for (ISynset m : PseudowordEvaluationTwo.getMeronyms(sense.getSynset(), true)) {
            for (String w : wn.getSynonyms(m)) {
                w = w.toLowerCase();
                meron.add(w);
            }
        }
        return meron;
    }

    public static List<ISynset> getMeronyms(ISynset synset, boolean bInstances) {
        ArrayList<ISynset> hypers = new ArrayList<ISynset>();
        if (bInstances) {
            for (ISynsetID hyper : synset.getRelatedSynsets((IPointer)Pointer.MERONYM_PART)) {
                hypers.add(WordNet.getInstance().getSynsetFromID(hyper));
            }
        }
        for (ISynsetID hyper : synset.getRelatedSynsets((IPointer)Pointer.MERONYM_SUBSTANCE)) {
            hypers.add(WordNet.getInstance().getSynsetFromID(hyper));
        }
        for (ISynsetID hyper : synset.getRelatedSynsets((IPointer)Pointer.MERONYM_MEMBER)) {
            hypers.add(WordNet.getInstance().getSynsetFromID(hyper));
        }
        return hypers;
    }

    static Set<String> getSiblings(IWord sense) {
        HashSet<String> sib = new HashSet<String>();
        WordNet wn = WordNet.getInstance();
        for (ISynset s : wn.getSiblings(sense.getSynset(), false)) {
            for (String w : wn.getSynonyms(s)) {
                w = w.toLowerCase();
                sib.add(w);
            }
        }
        return sib;
    }
}

