/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiktionary;

import it.uniroma1.lcl.jlt.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class WiktionaryGlossFactory {
    public static Set<String> getGlosses(String lemma) throws IOException {
        HashSet<String> result = new HashSet<String>();
        String folder = Configuration.getInstance().getWiktionaryIndex();
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(folder));
        IndexSearcher is = new IndexSearcher((Directory)dir, true);
        TermQuery tq = new TermQuery(new Term("lemma", lemma));
        Hits hits = is.search((Query)tq);
        int i = 0;
        while (i < hits.length()) {
            Document d = hits.doc(i);
            List fields = d.getFields();
            HashSet<String> fieldsNames = new HashSet<String>();
            for (Field f : fields) {
                fieldsNames.add(f.name());
            }
            String gloss = "";
            if (fieldsNames.contains("gloss")) {
                gloss = d.get("gloss");
            }
            result.add(gloss);
            ++i;
        }
        is.close();
        return result;
    }

    public static void main(String[] args) {
        try {
            Set<String> result = WiktionaryGlossFactory.getGlosses("barracuda");
            for (String g : result) {
                System.out.println(g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

