/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki.disambiguation;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.wiki.disambiguation.WikiDisambiguationItem;
import it.uniroma1.lcl.jlt.wiki.disambiguation.WikiDisambiguationPage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class WikiDisambiguationPageFactory {
    public static WikiDisambiguationPage getPage(String lemma) throws IOException {
        WikiDisambiguationPage result = new WikiDisambiguationPage(lemma);
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(Configuration.getInstance().getWikipediaDisambiguationIndexDirectory()));
        IndexSearcher is = new IndexSearcher((Directory)dir, true);
        TermQuery tq = new TermQuery(new Term("lemma", lemma));
        Hits hits = is.search((Query)tq);
        int i = 0;
        while (i < hits.length()) {
            Document d = hits.doc(i);
            List fields = d.getFields();
            HashSet<String> fieldsNames = new HashSet<String>();
            for (Object f : fields) {
                if (!(f instanceof Field)) continue;
                Field field = (Field)f;
                fieldsNames.add(field.name());
            }
            if (fieldsNames.contains("meta")) {
                for (String s : fieldsNames) {
                    if (s.equals("meta") || s.equals("id") || s.equals("lemma")) continue;
                    result.addMetaInfo(s, d.get(s));
                }
            } else {
                List<String> labels = Arrays.asList(d.getValues("label"));
                HashSet<String> synonyms = new HashSet<String>(Arrays.asList(d.getValues("synonym")));
                String tag = "";
                if (fieldsNames.contains("tag")) {
                    tag = d.get("tag");
                }
                String title = "";
                if (fieldsNames.contains("title")) {
                    title = d.get("title");
                }
                String gloss = "";
                if (fieldsNames.contains("gloss")) {
                    gloss = d.get("gloss");
                }
                String rawItemText = "";
                if (fieldsNames.contains("rawItemText")) {
                    rawItemText = d.get("rawItemText");
                }
                String fatherId = "";
                if (fieldsNames.contains("fatherId")) {
                    fatherId = d.get("fatherId");
                }
                String fatherGloss = "";
                if (fieldsNames.contains("fatherGloss")) {
                    fatherGloss = d.get("fatherGloss");
                }
                long id = -1L;
                try {
                    id = new Long(d.get("id"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                WikiDisambiguationItem wdi = new WikiDisambiguationItem(id, d.get("lemma"), labels, synonyms, tag, title, gloss, rawItemText, fatherId, fatherGloss);
                result.addItem(wdi);
            }
            ++i;
        }
        is.close();
        return result;
    }

    public static void main(String[] args) throws IOException, ParseException {
        WikiDisambiguationPage wdp = WikiDisambiguationPageFactory.getPage("michelle williams");
        System.out.println("PAGE:" + wdp.getLemma());
        System.out.println("METAINFOS:" + wdp.getMetaInfos());
        System.out.println(wdp.getItems().size());
        for (WikiDisambiguationItem wdi : wdp.getItems()) {
            System.out.println(wdi.toCSV("\t"));
        }
    }
}

