/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki.disambiguation;

import it.uniroma1.lcl.jlt.wiki.disambiguation.WikiDisambiguationIndexer;
import it.uniroma1.lcl.jlt.wiki.disambiguation.WikiDisambiguationItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WikiDisambiguationPage {
    private String lemma = null;
    private List<WikiDisambiguationItem> items;
    private Map<String, String> metainfos;

    public WikiDisambiguationPage(String lemma) {
        this.lemma = lemma;
        this.items = new ArrayList<WikiDisambiguationItem>();
        this.metainfos = new HashMap<String, String>();
    }

    public void addItem(WikiDisambiguationItem item) {
        this.items.add(item);
    }

    public List<WikiDisambiguationItem> getItems() {
        return new ArrayList<WikiDisambiguationItem>(this.items);
    }

    public Iterator<WikiDisambiguationItem> getIterator() {
        return this.items.iterator();
    }

    public String getLemma() {
        return this.lemma;
    }

    public Map<String, String> getMetaInfos() {
        return new HashMap<String, String>(this.metainfos);
    }

    public void addMetaInfo(String metainfoName, String value) {
        this.metainfos.put(metainfoName, value);
    }

    public void parseMetaInfos(String metainfos) {
        if (metainfos == null || metainfos.isEmpty()) {
            return;
        }
        Set<String> contents = WikiDisambiguationIndexer.getContentBetween(metainfos.replaceAll("\\}\\}", "## ").replaceAll("\\{\\{", " ##"), "##", new HashSet<String>());
        for (String content : contents) {
            String[] metainfoSplit = content.split("\\|");
            if (metainfoSplit.length == 1) {
                this.addMetaInfo(metainfoSplit[0], "");
                continue;
            }
            if (metainfoSplit.length <= 1) continue;
            StringBuffer value = new StringBuffer(metainfoSplit[1]);
            int i = 2;
            while (i < metainfoSplit.length) {
                value.append("|").append(metainfoSplit[i]);
                ++i;
            }
            this.addMetaInfo(metainfoSplit[0], value.toString());
        }
    }

    public String toCSV(String sep) {
        StringBuffer result = new StringBuffer();
        result.append("Lemma:").append(sep).append(this.lemma).append("\n");
        for (String metaKey : this.metainfos.keySet()) {
            result.append("Meta:").append(sep).append(metaKey).append(sep).append(this.metainfos.get(metaKey)).append("\n");
        }
        for (WikiDisambiguationItem wdi : this.items) {
            result.append(wdi.toCSV(sep)).append("\n");
        }
        return result.toString();
    }
}

