/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki.data;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.util.Language;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WikiVersions {
    private final Map<Language, String> lang2version = new HashMap<Language, String>();
    private static WikiVersions instance;

    public static synchronized WikiVersions getInstance() {
        if (instance == null) {
            instance = new WikiVersions();
        }
        return instance;
    }

    private WikiVersions() {
        try {
            this.load(Configuration.getInstance().getWikipediaVersionFile());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot init: " + ioe);
        }
    }

    private void load(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while (reader.ready()) {
            String line = reader.readLine();
            if (line.startsWith("#")) continue;
            String[] split = line.split("\t");
            if (split.length != 2) {
                throw new RuntimeException("Invalid line: " + line);
            }
            Language language = Language.valueOf(split[0]);
            this.lang2version.put(language, split[1]);
        }
        reader.close();
    }

    public String getVersion(Language language) {
        return this.lang2version.get((Object)language);
    }
}

