/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki.data;

import it.uniroma1.lcl.jlt.wiki.data.WikiPage;
import it.uniroma1.lcl.jlt.wiki.data.WikiWord;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WikiText {
    public static final Log log = LogFactory.getLog(WikiText.class);
    private List<WikiWord> wikiWords;

    public WikiText(String[] words, String[] senses) {
        if (words.length != senses.length) {
            log.warn((Object)("Different lengths: WORDS[" + words.length + "] SENSES [" + senses.length + "]"));
        }
        int i = 0;
        this.wikiWords = new ArrayList<WikiWord>();
        HashSet<String> doneWords = new HashSet<String>();
        HashSet<String> doneSenses = new HashSet<String>();
        if (words != null && senses != null) {
            while (i < words.length && i < senses.length) {
                String word = words[i];
                String sense = senses[i];
                if (!word.isEmpty()) {
                    if (doneWords.add(word)) {
                        this.wikiWords.add(new WikiWord(word, sense, i));
                        if (!sense.isEmpty()) {
                            doneSenses.add(sense);
                        }
                    } else if (!sense.isEmpty() && doneSenses.add(sense)) {
                        this.wikiWords.add(new WikiWord(word, sense, i));
                    }
                }
                ++i;
            }
        }
    }

    public WikiText(ArrayList<WikiWord> alww) {
        this.wikiWords = alww;
    }

    public WikiText() {
        this.wikiWords = new ArrayList<WikiWord>();
    }

    public void addWikiWord(WikiWord ww) {
        this.wikiWords.add(ww);
    }

    public WikiWord getWikiWord(int n) {
        WikiWord ww = null;
        if (this.wikiWords == null) {
            return null;
        }
        if (n < 0 || n > this.size()) {
            return null;
        }
        for (WikiWord wikiw : this.wikiWords) {
            if (n == 0) {
                ww = wikiw;
            }
            --n;
        }
        return ww;
    }

    public int size() {
        return this.wikiWords.size();
    }

    public WikiWord getRandomWikiWord() {
        Random r = new Random();
        int n = r.nextInt(this.size());
        return this.getWikiWord(n);
    }

    public WikiWord getRandomWikiWord(String titolo) {
        int n;
        String senso = new String();
        Random r = new Random();
        WikiWord casuale = null;
        while ((senso = (casuale = this.getWikiWord(n = r.nextInt(this.size()))).getWikiSense()).equalsIgnoreCase(titolo)) {
        }
        return casuale;
    }

    public List<WikiWord> getWikiWords() {
        ArrayList<WikiWord> ww = new ArrayList<WikiWord>();
        for (WikiWord wikiw : this.wikiWords) {
            ww.add(wikiw);
        }
        return ww;
    }

    public boolean containsText(String s) {
        boolean b = false;
        for (WikiWord wikiw : this.wikiWords) {
            if (!wikiw.getWikiText().equals(s)) continue;
            b = true;
            break;
        }
        return b;
    }

    public boolean containsSense(WikiPage sourceSense) {
        boolean b = false;
        for (WikiWord wikiw : this.wikiWords) {
            HashSet<String> lemmas = new HashSet<String>(sourceSense.getCategoryLemmas());
            lemmas.add(sourceSense.getLemma().toLowerCase());
            if (!lemmas.contains(wikiw.getWikiText().toLowerCase())) continue;
            b = true;
            break;
        }
        return b;
    }

    public boolean contains(WikiPage p) {
        HashSet<String> lemmas = new HashSet<String>(p.getCategoryLemmas());
        lemmas.add(p.getLemma().toLowerCase());
        boolean b = false;
        for (WikiWord wikiw : this.wikiWords) {
            if (!lemmas.contains(wikiw.getWikiText().toLowerCase())) continue;
            b = true;
            break;
        }
        return b;
    }

    public boolean contains(String word) {
        boolean b = false;
        for (WikiWord wikiw : this.wikiWords) {
            if (!word.equalsIgnoreCase(wikiw.getWikiText())) continue;
            b = true;
            break;
        }
        return b;
    }

    public boolean containsSense(String title) {
        boolean b = false;
        for (WikiWord wikiw : this.wikiWords) {
            if (!title.equalsIgnoreCase(wikiw.getWikiSense())) continue;
            b = true;
            break;
        }
        return b;
    }

    public void removeWikiText(WikiWord w) {
        this.wikiWords.remove(w);
    }
}

