/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki.data;

import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.wiki.data.WikiText;
import it.uniroma1.lcl.jlt.wiki.data.WikiWord;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WikiPage {
    private final String id;
    private final String title;
    private final String lemma;
    private final WikiText text;
    private final List<String> infoboxLinks;
    private final List<String> tableLinks;
    private final List<String> categoryLemmas;
    private final List<String> categories;
    private final List<String> translations;
    private final List<String> images;
    private Set<String> linkedPages;
    private final boolean disambiguation;

    public WikiPage(String id, String title, String lemma, WikiText text, String[] infoboxLinks, String[] tableLinks, String[] categories, String[] categoryLemmas, String[] translations, String[] images, boolean disambiguation) throws IOException {
        int n;
        int n2;
        String[] stringArray;
        this.id = id;
        this.title = title;
        this.lemma = lemma;
        this.text = text;
        this.infoboxLinks = new ArrayList<String>();
        if (infoboxLinks != null) {
            stringArray = infoboxLinks;
            n2 = infoboxLinks.length;
            n = 0;
            while (n < n2) {
                String infoboxLink = stringArray[n];
                this.infoboxLinks.add(infoboxLink);
                ++n;
            }
        }
        this.tableLinks = new ArrayList<String>();
        if (tableLinks != null) {
            stringArray = tableLinks;
            n2 = tableLinks.length;
            n = 0;
            while (n < n2) {
                String tableLink = stringArray[n];
                this.tableLinks.add(tableLink);
                ++n;
            }
        }
        this.categoryLemmas = new ArrayList<String>();
        if (categoryLemmas != null) {
            stringArray = categoryLemmas;
            n2 = categoryLemmas.length;
            n = 0;
            while (n < n2) {
                String categoryLemma = stringArray[n];
                this.categoryLemmas.add(categoryLemma);
                ++n;
            }
        }
        this.categories = new ArrayList<String>();
        if (categories != null) {
            stringArray = categories;
            n2 = categories.length;
            n = 0;
            while (n < n2) {
                String category = stringArray[n];
                this.categories.add(category);
                ++n;
            }
        }
        this.translations = new ArrayList<String>();
        if (translations != null) {
            stringArray = translations;
            n2 = translations.length;
            n = 0;
            while (n < n2) {
                String translation = stringArray[n];
                this.translations.add(translation);
                ++n;
            }
        }
        this.images = new ArrayList<String>();
        if (images != null) {
            stringArray = images;
            n2 = images.length;
            n = 0;
            while (n < n2) {
                String image = stringArray[n];
                this.images.add(image);
                ++n;
            }
        }
        this.disambiguation = disambiguation;
    }

    public String toString() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public String getLemma() {
        return this.lemma;
    }

    public String getTitle() {
        return this.title;
    }

    public WikiText getText() {
        return this.text;
    }

    public List<String> getCategoryLemmas() {
        return this.categoryLemmas;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<String> getTranslations() {
        return this.translations;
    }

    public List<String> getImages() {
        return this.images;
    }

    public List<String> getInfoboxLinks() {
        return this.infoboxLinks;
    }

    public boolean isDisambiguation() {
        return this.disambiguation;
    }

    public double size() {
        return this.text.size();
    }

    public Set<String> getLinkedPages() {
        if (this.linkedPages == null) {
            this.linkedPages = new HashSet<String>();
            for (WikiWord w : this.getText().getWikiWords()) {
                String sense = w.getWikiSense();
                if (sense.isEmpty()) continue;
                this.linkedPages.add(Strings.forceFirstCharUppercase(sense));
            }
        }
        return this.linkedPages;
    }

    public Set<String> getNonLinkedMonosemousWords() {
        WordNet wn = WordNet.getInstance();
        HashSet<String> words = new HashSet<String>();
        for (WikiWord w : this.getText().getWikiWords()) {
            String lemma;
            List<IWord> senses;
            if (!w.getWikiSense().isEmpty() || (senses = wn.getSenses(lemma = w.getWikiText(), POS.NOUN)).size() != 1) continue;
            words.add(lemma);
        }
        return words;
    }

    public boolean equals(WikiPage b) {
        return this.getId().equals(b.getId());
    }
}

