/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.wiki.SearchWiki;
import it.uniroma1.lcl.jlt.wiki.SearchWikiCentral;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WikipediaLinkTranslations {
    private static final boolean VERBOSE = false;
    protected static final Log log = LogFactory.getLog(WikipediaLinkTranslations.class);
    public static final String LINK_TRANSLATION_MARKER = "*";

    public static Multimap<Language, String> getTranslations(String title, String[] allTranslations, Map<String, Language> languageIDs) {
        return WikipediaLinkTranslations.getTranslations(title, allTranslations, languageIDs, true);
    }

    public static Multimap<Language, String> getTranslations(String title, String[] allTranslations, Map<String, Language> languageIDs, boolean normalize) {
        return WikipediaLinkTranslations.getTranslations(title, allTranslations, languageIDs, normalize, true);
    }

    public static Multimap<Language, String> getTranslations(String title, String[] allTranslations, Map<String, Language> languageIDs, boolean normalize, boolean addRedirections) {
        StringBuffer sb = new StringBuffer();
        Map<Language, String> baseTranslations = WikipediaLinkTranslations.getPageTranslations(allTranslations, languageIDs);
        LinkedHashMultimap allTranlantions = new LinkedHashMultimap();
        for (Language language : baseTranslations.keySet()) {
            String translation;
            String cleanTranslation = translation = baseTranslations.get((Object)language);
            if (normalize) {
                cleanTranslation = cleanTranslation.replaceAll("\\(.*\\)?", "").toLowerCase();
            }
            if ((cleanTranslation = cleanTranslation.trim().replaceAll("\\s+", "_")).isEmpty()) continue;
            LinkedHashSet<String> translations = new LinkedHashSet<String>();
            translations.add(cleanTranslation);
            if (addRedirections) {
                SearchWiki sw = SearchWikiCentral.getInstance(language);
                try {
                    Set<String> translationRedirections = null;
                    translationRedirections = normalize ? sw.getLemmasFromRedirectionsToThisPage(translation) : sw.getTitlesFromRedirectionsToThisPage(translation);
                    for (String translationRedirection : translationRedirections) {
                        if (normalize) {
                            translationRedirection = translationRedirection.replaceAll("\\(.*\\)?", "").toLowerCase();
                        }
                        translationRedirection = translationRedirection.trim().replaceAll("\\s+", "_");
                        translations.add(translationRedirection);
                    }
                }
                catch (IOException e) {
                    log.debug((Object)("Could not get redirections for: " + translation));
                }
            }
            allTranlantions.putAll((Object)language, translations);
        }
        return allTranlantions;
    }

    public static Map<Language, String> getPageTranslations(String[] allTranslations, Map<String, Language> languageIDs) {
        LinkedHashMap<Language, String> translations = new LinkedHashMap<Language, String>();
        int i = 0;
        while (i < allTranslations.length) {
            String languageID;
            Language language;
            String languageTranslation = allTranslations[i];
            int semicolon = languageTranslation.indexOf(":");
            if (semicolon != -1 && (language = languageIDs.get(languageID = languageTranslation.substring(0, semicolon))) != null) {
                String translation = languageTranslation.substring(semicolon + 1);
                translations.put(language, translation);
            }
            ++i;
        }
        return translations;
    }
}

