/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import it.uniroma1.lcl.jlt.Configuration;
import java.io.IOException;

public class WikiParsingUtility {
    private WikiParsingUtility() {
    }

    public static String extractLink(String s) {
        s = WikiParsingUtility.rimuoviPunteggiaturaLink(s);
        s = WikiParsingUtility.getLink(s);
        String[] pair = s.split("IsLiNk");
        String sense = s;
        if (pair.length >= 2) {
            sense = "LiNk" + pair[0];
            if (!(sense = sense.substring(sense.indexOf("LiNk") + 4).replaceAll("IsSpAcE", " ")).isEmpty()) {
                String firstChar = sense.substring(0, 1).toUpperCase();
                sense = sense.length() > 1 ? String.valueOf(firstChar) + sense.substring(1) : firstChar;
                sense = sense.trim();
            } else {
                sense = null;
            }
        }
        return sense;
    }

    public static String extractText(String s) {
        s = WikiParsingUtility.rimuoviPunteggiaturaLink(s);
        s = WikiParsingUtility.getLink(s);
        String[] pair = s.split("IsLiNk");
        String sense = s;
        if (pair.length >= 2) {
            sense = pair[1];
        }
        return sense.replaceAll("IsSpAcE", " ").trim();
    }

    public static boolean isLink(String s) {
        return s.contains("IsLiNk");
    }

    public static String getLink(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals("")) {
            return "";
        }
        String temp = new String(s);
        temp = s.replaceAll("IsOpEnRoUnDeD", "(");
        temp = temp.replaceAll("IsClOsEdRoUnDeD", ")");
        temp = temp.replaceAll("IsOpEnSqUaRe", "[");
        temp = temp.replaceAll("IsClOsEdSqUaRe", "]");
        temp = temp.replaceAll("IsOpEnCuRlY", "{");
        temp = temp.replaceAll("IsClOsEdCuRlY", "}");
        temp = temp.replaceAll("IsOpEnAnGlE", "<");
        temp = temp.replaceAll("IsClOsEdAnGlE", ">");
        return temp;
    }

    public static String risolviEntities(String testo) {
        testo = testo.replaceAll("&apos;", "'");
        testo = testo.replaceAll("&quot;", "\"");
        testo = testo.replaceAll("&lt;", "<");
        testo = testo.replaceAll("&gt;", ">");
        testo = testo.replaceAll("&amp;ndash;", "-");
        testo = testo.replaceAll("&amp;", "&");
        return testo;
    }

    public static String rimuoviTestoInutile(String testo) {
        String[] a;
        int idx = 0;
        int idx2 = 0;
        String[] stringArray = a = testo.split("\n");
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(":''") && line.endsWith(".''")) {
                idx = testo.indexOf(":''");
                idx2 = testo.indexOf("\n", idx) + 1;
                if (idx != -1 && idx2 > idx) {
                    String t = testo.substring(idx, idx2);
                    testo = testo.replace(t, "");
                }
            }
            ++n2;
        }
        return testo;
    }

    public static String rimuoviDoppieQuadre(String testo) {
        int idx;
        int previousPosition = 0;
        int position = 0;
        StringBuffer sb = new StringBuffer();
        while ((idx = testo.indexOf("[[", position)) != -1) {
            position = idx;
            sb.append(testo.substring(previousPosition, position).replaceAll("([:;,.*'\"])", " $1"));
            int idx2a = testo.indexOf("]]", position);
            int idx2b = testo.indexOf("[[", position + 2);
            if (idx2a == -1) {
                idx2a = testo.length();
            }
            if (idx2a > position + 2 && (idx2a < idx2b || idx2b == -1)) {
                char c;
                String testoLink = testo.substring(position + 2, idx2a);
                if (WikiParsingUtility.isCategory(testoLink)) {
                    testo = sb.toString();
                    return testo;
                }
                sb.append(" ");
                String[] pair = testoLink.split("\\|", 2);
                int spacesFirstBegin = 0;
                int spacesSecondBegin = 0;
                int spacesFirstEnd = 0;
                int spacesSecondEnd = 0;
                int i = 0;
                while (i < pair[0].length()) {
                    c = pair[0].charAt(i);
                    if (c != ' ' && c != '\t') break;
                    ++spacesFirstBegin;
                    ++i;
                }
                pair[0] = pair[0].substring(spacesFirstBegin);
                i = pair[0].length() - 1;
                while (i >= 0) {
                    c = pair[0].charAt(i);
                    if (c != ' ' && c != '\t') break;
                    ++spacesFirstEnd;
                    --i;
                }
                pair[0] = pair[0].substring(0, pair[0].length() - spacesFirstEnd);
                if (pair.length == 2) {
                    i = 0;
                    while (i < pair[1].length()) {
                        c = pair[1].charAt(i);
                        if (c != ' ' && c != '\t') break;
                        ++spacesSecondBegin;
                        ++i;
                    }
                    pair[1] = pair[1].substring(spacesSecondBegin);
                    i = pair[1].length() - 1;
                    while (i >= 0) {
                        c = pair[1].charAt(i);
                        if (c != ' ' && c != '\t') break;
                        ++spacesSecondEnd;
                        --i;
                    }
                    pair[1] = pair[1].substring(0, pair[1].length() - spacesSecondEnd);
                }
                if (!WikiParsingUtility.isNamespace(testoLink)) {
                    if (pair.length == 2 && pair[1].length() > 0) {
                        char c2;
                        int pair0length = pair[0].length();
                        int pair1length = pair[1].length();
                        int i2 = 0;
                        while (i2 < pair0length) {
                            c2 = pair[0].charAt(i2);
                            if (!WikiParsingUtility.isAlphaNum(c2) && c2 != ' ' && c2 != '\t' && c2 != '(' && c2 != ')' && c2 != '[' && c2 != ']' && c2 != '{' && c2 != '}' && c2 != '<' && c2 != '>') {
                                if (c2 != '.' && c2 != ':' && c2 != ';' && c2 != ',' || i2 != pair0length - 1) {
                                    sb.append('\\');
                                    sb.append(c2);
                                }
                            } else if (c2 == ' ' || c2 == '\t') {
                                sb.append("IsSpAcE");
                            } else if (c2 == '(') {
                                sb.append("IsOpEnRoUnDeD");
                            } else if (c2 == ')') {
                                sb.append("IsClOsEdRoUnDeD");
                            } else if (c2 == '[') {
                                sb.append("IsOpEnSqUaRe");
                            } else if (c2 == ']') {
                                sb.append("IsClOsEdSqUaRe");
                            } else if (c2 == '{') {
                                sb.append("IsOpEnCuRlY");
                            } else if (c2 == '}') {
                                sb.append("IsClOsEdCuRlY");
                            } else if (c2 == '<') {
                                sb.append("IsOpEnAnGlE");
                            } else if (c2 == '>') {
                                sb.append("IsClOsEdAnGlE");
                            } else {
                                sb.append(c2);
                            }
                            ++i2;
                        }
                        sb.append("IsLiNk");
                        i2 = 0;
                        while (i2 < pair1length) {
                            c2 = pair[1].charAt(i2);
                            if (!WikiParsingUtility.isAlphaNum(c2) && c2 != ' ' && c2 != '\t' && c2 != '(' && c2 != ')' && c2 != '[' && c2 != ']' && c2 != '{' && c2 != '}' && c2 != '<' && c2 != '>') {
                                if (c2 != '.' && c2 != ':' && c2 != ';' && c2 != ',' || i2 != pair1length - 1) {
                                    sb.append('\\');
                                    sb.append(c2);
                                }
                            } else if (c2 == ' ' || c2 == '\t') {
                                sb.append("IsSpAcE");
                            } else if (c2 == '(') {
                                sb.append("IsOpEnRoUnDeD");
                            } else if (c2 == ')') {
                                sb.append("IsClOsEdRoUnDeD");
                            } else if (c2 == '[') {
                                sb.append("IsOpEnSqUaRe");
                            } else if (c2 == ']') {
                                sb.append("IsClOsEdSqUaRe");
                            } else if (c2 == '{') {
                                sb.append("IsOpEnCuRlY");
                            } else if (c2 == '}') {
                                sb.append("IsClOsEdCuRlY");
                            } else if (c2 == '<') {
                                sb.append("IsOpEnAnGlE");
                            } else if (c2 == '>') {
                                sb.append("IsClOsEdAnGlE");
                            } else {
                                sb.append(c2);
                            }
                            ++i2;
                        }
                    } else if (pair.length == 1 || pair[1].length() == 0) {
                        pair[0] = pair[0].replaceAll(" ", "IsSpAcE");
                        StringBuffer sb0 = new StringBuffer();
                        int i3 = 0;
                        while (i3 < pair[0].length()) {
                            char c3 = pair[0].charAt(i3);
                            if (!WikiParsingUtility.isAlphaNum(c3) && c3 != ' ' && c3 != '\t' && c3 != '(' && c3 != ')' && c3 != '[' && c3 != ']' && c3 != '{' && c3 != '}' && c3 != '<' && c3 != '>') {
                                if (c3 != '.' && c3 != ':' && c3 != ';' && c3 != ',' || i3 != pair[0].length() - 1) {
                                    sb0.append('\\');
                                    sb0.append(c3);
                                }
                            } else if (c3 == ' ' || c3 == '\t') {
                                sb0.append("IsSpAcE");
                            } else if (c3 == '(') {
                                sb0.append("IsOpEnRoUnDeD");
                            } else if (c3 == ')') {
                                sb0.append("IsClOsEdRoUnDeD");
                            } else if (c3 == '[') {
                                sb0.append("IsOpEnSqUaRe");
                            } else if (c3 == ']') {
                                sb0.append("IsClOsEdSqUaRe");
                            } else if (c3 == '{') {
                                sb0.append("IsOpEnCuRlY");
                            } else if (c3 == '}') {
                                sb0.append("IsClOsEdCuRlY");
                            } else if (c3 == '<') {
                                sb0.append("IsOpEnAnGlE");
                            } else if (c3 == '>') {
                                sb0.append("IsClOsEdAnGlE");
                            } else {
                                sb0.append(c3);
                            }
                            ++i3;
                        }
                        sb.append(sb0);
                        sb.append("IsLiNk");
                        sb.append(sb0);
                    }
                }
                position = idx2a + 2;
            } else {
                int paren = 0;
                int testoLength = testo.length();
                int k = position;
                while (k < testoLength) {
                    if (k + 1 == testoLength) {
                        paren = 0;
                        position = k + 1;
                        sb.append(" ");
                        break;
                    }
                    char c = testo.charAt(k);
                    switch (c) {
                        case '[': {
                            if (testo.charAt(k + 1) != '[') break;
                            ++paren;
                            ++k;
                            break;
                        }
                        case ']': {
                            if (testo.charAt(k + 1) != ']') break;
                            --paren;
                            ++k;
                        }
                    }
                    if (paren == 0) {
                        position = k + 1;
                        sb.append(" ");
                        break;
                    }
                    ++k;
                }
                if (k == testoLength) {
                    position = testoLength;
                }
            }
            previousPosition = position;
        }
        if (position < 0) {
            position = 0;
        }
        if (position < testo.length()) {
            sb.append(testo.substring(position).replaceAll("([:;,.*'\"])", " $1"));
        }
        testo = sb.toString();
        return testo;
    }

    public static String rimuoviParentesi(String testo) {
        int k;
        StringBuffer sb = new StringBuffer();
        int[] skip = new int[4];
        skip[3] = 0;
        skip[2] = 0;
        skip[1] = 0;
        skip[0] = 0;
        int tonda = testo.indexOf("(");
        int quadra = testo.indexOf("[");
        int graffa = testo.indexOf("{");
        int angolo = testo.indexOf("<");
        if (tonda < 0) {
            tonda = testo.length();
        }
        if (quadra < 0) {
            quadra = testo.length();
        }
        if (graffa < 0) {
            graffa = testo.length();
        }
        if (angolo < 0) {
            angolo = testo.length();
        }
        if ((k = Math.min(Math.min(tonda, quadra), Math.min(graffa, angolo))) > 0) {
            sb.append(testo.substring(0, k));
        }
        while (k < testo.length()) {
            char c = testo.charAt(k);
            switch (c) {
                case '(': {
                    skip[0] = skip[0] + 1;
                    break;
                }
                case '[': {
                    skip[1] = skip[1] + 1;
                    break;
                }
                case '{': {
                    skip[2] = skip[2] + 1;
                    break;
                }
                case '<': {
                    skip[3] = skip[3] + 1;
                    break;
                }
                case ')': {
                    skip[0] = skip[0] - 1;
                    break;
                }
                case ']': {
                    skip[1] = skip[1] - 1;
                    break;
                }
                case '}': {
                    skip[2] = skip[2] - 1;
                    break;
                }
                case '>': {
                    skip[3] = skip[3] - 1;
                }
            }
            if (skip[0] <= 0 && skip[1] <= 0 && skip[2] <= 0 && skip[3] <= 0 && c != '(' && c != '[' && c != '{' && c != '<' && c != ')' && c != ']' && c != '}' && c != '>') {
                sb.append(c);
            }
            ++k;
        }
        testo = sb.toString();
        return testo;
    }

    public static String rimuoviNewLine(String testo) {
        if (testo == null) {
            return null;
        }
        String tempText = testo.replaceAll("[\t\r]", "");
        String[] lines = tempText.split("\n");
        StringBuffer sb = new StringBuffer();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().startsWith("==")) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(line);
            }
            ++n2;
        }
        tempText = sb.toString().replaceAll("'''", "");
        testo = tempText = tempText.replaceAll("''", "");
        return testo;
    }

    public static String rimuoviPunteggiatura(String s) {
        char c;
        if (s == null) {
            return null;
        }
        int spacesBegin = 0;
        int spacesEnd = 0;
        String temp = new String(s);
        int i = 0;
        while (i < s.length()) {
            c = s.charAt(i);
            if (c != ' ' && c != '\t') break;
            ++spacesBegin;
            ++i;
        }
        temp = s.substring(spacesBegin);
        i = temp.length() - 1;
        while (i >= 0) {
            c = temp.charAt(i);
            if (c != ' ' && c != '\t') break;
            ++spacesEnd;
            --i;
        }
        temp = temp.substring(0, temp.length() - spacesEnd);
        temp = s.replaceAll("[,.:;' *\"]", "");
        if (temp != null) {
            temp = temp.replace("\n", " ");
        }
        return temp;
    }

    public static String rimuoviPunteggiaturaLink(String s) {
        String temp = new String(s);
        int spacesBegin = 0;
        int spacesEnd = 0;
        if (temp.startsWith("*") && (temp = s.substring(1, temp.length())).length() == 0) {
            return temp;
        }
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != ' ' && temp.charAt(i) != '\t') break;
            ++spacesBegin;
            ++i;
        }
        temp = s.substring(spacesBegin);
        i = temp.length() - 1;
        while (i >= 0) {
            if (temp.charAt(i) != ' ' && temp.charAt(i) != '\t') break;
            ++spacesEnd;
            --i;
        }
        temp = temp.substring(0, temp.length() - spacesEnd);
        return temp;
    }

    public static String redirectionPage(String testo) {
        if (!(testo.startsWith("#redirect") || testo.startsWith("#REDIRECT") || testo.startsWith("#Redirect"))) {
            return null;
        }
        int aperta = 0;
        int chiusa = 0;
        aperta = testo.indexOf("[[");
        chiusa = testo.indexOf("]]");
        if (aperta < 0 || chiusa < 0) {
            return null;
        }
        String redirezione = testo.substring(aperta + 2, chiusa).replace('_', ' ');
        String result = "ReDiReCtIoNpAgE:".concat(redirezione);
        return result;
    }

    public static boolean isNamespace(String s) {
        return s.matches(".*[^ \\t_]:[^ \\t_].*");
    }

    public static boolean isCategory(String s) {
        if (s == null) {
            return false;
        }
        String categoryPrefix = Configuration.getInstance().getCategoryPrefix();
        return s.startsWith(categoryPrefix) || s.startsWith(categoryPrefix.toLowerCase());
    }

    public static boolean isAlphaNum(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public static boolean isAlphaNum(String s) {
        boolean bIsAlphaNum = false;
        int i = 0;
        while (i < s.length()) {
            if (WikiParsingUtility.isAlphaNum(s.charAt(i))) {
                bIsAlphaNum = true;
                break;
            }
            ++i;
        }
        return bIsAlphaNum;
    }

    public static void main(String[] args) throws IOException {
        String test = "It has a half-life of 35 days.";
        System.out.println(WikiParsingUtility.extractText(test));
    }
}

