/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import it.uniroma1.lcl.jlt.wiki.SearchWiki;
import it.uniroma1.lcl.jlt.wiki.data.WikiPage;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.queryParser.ParseException;

public class WikiMapper {
    private SearchWiki source;
    private SearchWiki target;

    public WikiMapper(String sourceIndexDir, String targetIndexDir) throws IOException {
        this.source = new SearchWiki(sourceIndexDir);
        this.target = new SearchWiki(targetIndexDir);
    }

    public void map(String filename) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        for (String title : this.source.getAllPageTitles()) {
            try {
                WikiPage sourcePage = this.source.getPageByTitle(title);
                String lemma = sourcePage.getLemma();
                double bestSimilarity = 0.0;
                WikiPage bestTargetPage = null;
                for (WikiPage targetPage : this.target.getSenses(lemma)) {
                    double similarity = this.getSimilarity(sourcePage, targetPage);
                    if (!(bestSimilarity < similarity)) continue;
                    bestSimilarity = similarity;
                    bestTargetPage = targetPage;
                }
                bw.write(String.valueOf(title) + "\t");
                if (bestTargetPage != null) {
                    bw.write(bestTargetPage.getTitle());
                } else {
                    bw.write("<NONE>");
                }
                bw.write("\n");
                bw.flush();
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        bw.close();
    }

    public double getSimilarity(WikiPage source, WikiPage target) {
        ArrayList<Collection<String>> sourceSetList = new ArrayList<Collection<String>>();
        sourceSetList.add(Collections.singleton(source.getTitle()));
        sourceSetList.add(source.getCategories());
        sourceSetList.add(source.getCategoryLemmas());
        sourceSetList.add(source.getLinkedPages());
        sourceSetList.add(source.getTranslations());
        ArrayList<Collection<String>> targetSetList = new ArrayList<Collection<String>>();
        targetSetList.add(Collections.singleton(target.getTitle()));
        targetSetList.add(target.getCategories());
        targetSetList.add(target.getCategoryLemmas());
        targetSetList.add(target.getLinkedPages());
        targetSetList.add(target.getTranslations());
        Iterator i = targetSetList.iterator();
        double score = 0.0;
        for (Collection collection : sourceSetList) {
            Collection targetSet = (Collection)i.next();
            int initialSize = collection.size();
            collection.retainAll(targetSet);
            int finalSize = collection.size();
            score += (double)(finalSize / initialSize);
        }
        return score / (double)sourceSetList.size();
    }

    public static void main(String[] args) throws IOException {
        args = new String[]{"/home/roberto/workspace/Wiki2WN/resources/wiki_index", "/home/roberto/workspace/Wiki2WN/resources/wiki_index"};
        if (args.length < 2) {
            System.out.println("Usage: WikiMapper <source_index> <target_index> [mapping_filename]");
            System.exit(1);
        }
        WikiMapper mapper = new WikiMapper(args[0], args[1]);
        mapper.map(args.length > 2 ? args[2] : "mapping.txt");
    }
}

