/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.Constants;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.Language;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;

public class WikiGlossIndexer {
    private static final Log log = LogFactory.getLog(WikiGlossIndexer.class);
    private IndexWriter writer = null;

    public WikiGlossIndexer(Language ... languages) throws IOException {
        IntegerCounter<Language> glossCounter = new IntegerCounter<Language>();
        Language[] languageArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            String indexPath = Configuration.getInstance().getWikiGlossIndexDir(language);
            log.info((Object)("WRITING INDEX TO " + indexPath));
            SimpleFSDirectory dir = new SimpleFSDirectory(new File(indexPath));
            this.writer = new IndexWriter((Directory)dir, (Analyzer)new StandardAnalyzer(Version.LUCENE_CURRENT), true, IndexWriter.MaxFieldLength.UNLIMITED);
            this.writer.setMaxMergeDocs(Configuration.getInstance().getMaxMergeDocs());
            this.createIndex(language, glossCounter);
            this.writer.optimize();
            this.writer.close();
            ++n2;
        }
        log.info((Object)("STATISTICS ON THE GLOSSES: " + glossCounter));
    }

    private void createIndex(Language language, IntegerCounter<Language> glossCounter) throws IOException {
        int counter = 0;
        BufferedReader br = Files.getBufferedReader(Configuration.getInstance().getWikiGlossDump(language));
        while (br.ready()) {
            String line = br.readLine();
            String[] lines = line.split("\t");
            if (lines == null) {
                log.warn((Object)("INVALID LINE: " + line));
                continue;
            }
            if (lines.length < 4) {
                log.warn((Object)("SKIPPING EMPTY GLOSS: " + line));
                continue;
            }
            this.createGlossa(lines[0], lines[1], lines[2], lines[3]);
            if (counter % 100000 == 0) {
                log.info((Object)("INDEXED " + counter + " GLOSSES SO FAR..."));
            }
            ++counter;
            glossCounter.count(language);
        }
        br.close();
    }

    private void createGlossa(String id, String title, String term, String gloss) throws CorruptIndexException, IOException {
        Document currentDoc = new Document();
        currentDoc.add((Fieldable)new Field(Constants.WikiGlossIndexFields.ID.toString(), id, Field.Store.YES, Field.Index.NOT_ANALYZED));
        currentDoc.add((Fieldable)new Field(Constants.WikiGlossIndexFields.LEMMA.toString(), term, Field.Store.YES, Field.Index.NOT_ANALYZED));
        currentDoc.add((Fieldable)new Field(Constants.WikiGlossIndexFields.TITLE.toString(), title, Field.Store.YES, Field.Index.NOT_ANALYZED));
        currentDoc.add((Fieldable)new Field(Constants.WikiGlossIndexFields.GLOSS.toString(), gloss, Field.Store.YES, Field.Index.NOT_ANALYZED));
        this.writer.addDocument(currentDoc);
    }

    public static void main(String[] args) {
        try {
            Language[] languages = new Language[]{Language.CA, Language.DE, Language.EN, Language.ES, Language.FR, Language.IT};
            new WikiGlossIndexer(languages);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

