/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.wiki.SearchWikiGloss;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchWikiGlossCentral {
    private static final Log log = LogFactory.getLog(SearchWikiGlossCentral.class);
    private static Map<Language, SearchWikiGloss> singleton = new HashMap<Language, SearchWikiGloss>();

    public static synchronized SearchWikiGloss getInstance() {
        return SearchWikiGlossCentral.getInstance(Language.EN);
    }

    public static synchronized SearchWikiGloss getInstance(Language language) {
        if (!singleton.containsKey((Object)language)) {
            try {
                singleton.put(language, new SearchWikiGloss(language));
            }
            catch (IOException ioe) {
                log.info((Object)("Wrong parameters or missing Wikipedia index for language " + language.toString()));
                singleton.put(language, null);
            }
        }
        return singleton.get((Object)language);
    }

    public void close() throws IOException {
        for (Language lang : singleton.keySet()) {
            singleton.get((Object)lang).close();
        }
    }

    public static void main(String[] args) {
        try {
            String title2;
            SearchWikiGloss enSearchWikiGloss = SearchWikiGlossCentral.getInstance(Language.EN);
            String lemma = "play";
            System.out.println("PRINTING GLOSSES FOR LEMMA " + lemma);
            Map<String, String> glosses = enSearchWikiGloss.getGlossesForTitles(lemma);
            int counter = 0;
            for (String title2 : glosses.keySet()) {
                System.out.println("    " + counter + ". " + title2 + " = " + glosses.get(title2));
                ++counter;
            }
            System.out.println("------------------------------");
            title2 = "Duke Ellington";
            System.out.println("PRINTING GLOSS FOR TITLE " + title2);
            System.out.println("    " + enSearchWikiGloss.getGlossByTitle(title2));
            System.out.println("------------------------------");
            String id = "12";
            System.out.println("PRINTING GLOSS FOR ID " + id);
            System.out.println("    " + enSearchWikiGloss.getGlossById(id));
            System.out.println("------------------------------");
            enSearchWikiGloss.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

