/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.Constants;
import it.uniroma1.lcl.jlt.util.Language;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class SearchWikiGloss {
    private final IndexSearcher is;

    public SearchWikiGloss() throws IOException {
        this(Language.EN);
    }

    public SearchWikiGloss(Language language) throws IOException {
        this(Configuration.getInstance().getWikiGlossIndexDir(language));
    }

    public SearchWikiGloss(String indexDir) throws IOException {
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(indexDir));
        this.is = new IndexSearcher((Directory)dir, true);
    }

    public Set<String> getGlosses(String lemma) throws IOException {
        return new HashSet<String>(this.getGlossesForTitles(lemma).values());
    }

    public Map<String, String> getGlossesForTitles(String lemma) throws IOException {
        HashMap<String, String> glosses = new HashMap<String, String>();
        TermQuery tq = new TermQuery(new Term(Constants.WikiGlossIndexFields.LEMMA.toString(), lemma));
        Hits hits = this.is.search((Query)tq);
        int k = 0;
        while (k < hits.length()) {
            Document d = hits.doc(k);
            String title = d.get(Constants.WikiGlossIndexFields.TITLE.toString());
            String gloss = d.get(Constants.WikiGlossIndexFields.GLOSS.toString());
            gloss = gloss.trim();
            glosses.put(title, gloss);
            ++k;
        }
        return glosses;
    }

    public String getGlossByTitle(String title) throws IOException {
        return this.getGlosses(Constants.WikiGlossIndexFields.TITLE, title);
    }

    public String getGlossById(String id) throws IOException {
        return this.getGlosses(Constants.WikiGlossIndexFields.ID, id);
    }

    private String getGlosses(Constants.WikiGlossIndexFields field, String value) throws IOException {
        TermQuery tq = new TermQuery(new Term(field.toString(), value));
        Hits hits = this.is.search((Query)tq);
        if (hits.length() <= 0) {
            return null;
        }
        Document d = hits.doc(0);
        String gloss = d.get(Constants.WikiGlossIndexFields.GLOSS.toString());
        return gloss;
    }

    public void close() throws IOException {
        this.is.close();
    }
}

