/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.wiki.SearchWiki;
import it.uniroma1.lcl.jlt.wiki.data.WikiPage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchWikiCentral {
    private static final Log log = LogFactory.getLog(SearchWikiCentral.class);
    private static Map<Language, SearchWiki> singleton = new HashMap<Language, SearchWiki>();

    public static synchronized SearchWiki getInstance() {
        return SearchWikiCentral.getInstance(Language.EN);
    }

    public static synchronized SearchWiki getInstance(Language language) {
        if (!singleton.containsKey((Object)language)) {
            try {
                singleton.put(language, new SearchWiki(language));
            }
            catch (IOException ioe) {
                log.info((Object)("Wrong parameters or missing Wikipedia index for language " + language.toString()));
                singleton.put(language, null);
            }
        }
        return singleton.get((Object)language);
    }

    public void close() throws IOException {
        for (Language lang : singleton.keySet()) {
            singleton.get((Object)lang).close();
        }
    }

    public static void main(String[] args) throws Exception {
        args = "EN,apple".split(",");
        if (args.length < 2) {
            System.out.println("Usage: SearchWikiCentral <language> <lemma>");
            System.exit(1);
        }
        String lang = args[0];
        String lemma = Strings.join(args, 1, args.length + 1, "_");
        SearchWiki sw = SearchWikiCentral.getInstance(Language.valueOf(lang));
        for (WikiPage wp : sw.getSenses(lemma)) {
            System.out.println("Linked pages=" + wp.getLinkedPages());
            System.out.println("id=" + wp.getId());
            System.out.println("title=" + wp.getTitle());
            System.out.println("lemma=" + wp.getLemma());
            System.out.println("categories=" + wp.getCategories());
            System.out.println("category_lemmas=" + wp.getCategoryLemmas());
            System.out.println("translations=" + wp.getTranslations());
            System.out.println();
        }
    }
}

