/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.wiki;

import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.wiki.SearchWikiCategory;
import it.uniroma1.lcl.jlt.wiki.data.WikiCategory;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SearchWikiCategoryCentral {
    private static Map<Language, SearchWikiCategory> singleton = new HashMap<Language, SearchWikiCategory>();

    public static synchronized SearchWikiCategory getInstance() {
        return SearchWikiCategoryCentral.getInstance(Language.EN);
    }

    public static synchronized SearchWikiCategory getInstance(Language language) {
        if (!singleton.containsKey((Object)language)) {
            try {
                singleton.put(language, new SearchWikiCategory(language));
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not init index: " + ioe.getMessage());
            }
        }
        return singleton.get((Object)language);
    }

    public void close() throws IOException {
        for (Language lang : singleton.keySet()) {
            singleton.get((Object)lang).close();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: SearchWikiCategoryCentral <language> <lemma>");
            System.exit(1);
        }
        System.out.println("REQUEST ARGUMENTS: " + Arrays.toString(args));
        String lang = args[0];
        SearchWikiCategory sw = SearchWikiCategoryCentral.getInstance(Language.valueOf(lang));
        System.out.println("LOADED INDEX FOR LANGUAGE: " + lang);
        String title = Strings.join(args, 1, args.length + 1, " ");
        System.out.println("QUERYING: \"" + title + "\"");
        WikiCategory category = sw.getCategoryByTitle(title);
        System.out.println("PAGE FOLLOWS:\n");
        System.out.println("\tid=" + category.getId());
        System.out.println("\ttitle=" + category.getTitle());
        System.out.println("\theads=" + category.getHeads());
        System.out.println("\ttokens=" + category.getTokens());
        System.out.println("\tparse=" + category.getParseTree());
        System.out.println("\tminimal=" + category.getMinimalNPs());
        System.out.println("\tsuper=" + category.getSuperCategories());
        System.out.println("\tsub=" + category.getSubCategories());
        System.out.println("\ttranslations=" + category.getTranslations());
        System.out.println("\tinWN=" + category.isInWordNet());
        System.out.println("\twnLemma=" + category.getWordNetLemmas());
        System.out.println();
    }
}

